/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang;

import com.intellij.CommonBundle;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004H\u0002\u001a+\u0010\u0007\u001a\u00020\u00012\b\b\u0001\u0010\b\u001a\u00020\u00012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\f\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LANG_BUNDLE", "", "ourBundle", "Ljava/lang/ref/Reference;", "Ljava/util/ResourceBundle;", "getBundle", "kotlin.jvm.PlatformType", "message", "key", "params", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "storeBundle", "", "bundle", "intellij.groovy.psi"})
public final class BundleKt {
    @NonNls
    private static final String LANG_BUNDLE = "messages.langBundle";
    private static Reference<ResourceBundle> ourBundle;

    private static final ResourceBundle getBundle() {
        Reference<ResourceBundle> reference = ourBundle;
        if (reference == null || (reference = reference.get()) == null) {
            ResourceBundle resourceBundle;
            ResourceBundle p1 = resourceBundle = ResourceBundle.getBundle(LANG_BUNDLE);
            BundleKt.storeBundle(p1);
            reference = resourceBundle;
        }
        return reference;
    }

    private static final void storeBundle(ResourceBundle bundle) {
        ourBundle = new SoftReference<ResourceBundle>(bundle);
    }

    @Nls
    @NotNull
    public static final String message(@PropertyKey(resourceBundle="messages.langBundle") @NotNull String key, Object ... params) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        String string = CommonBundle.message((ResourceBundle)BundleKt.getBundle(), (String)key, (Object[])Arrays.copyOf(params, params.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CommonBundle.message(getBundle(), key, *params)");
        return string;
    }
}

