/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.sam.SamConversionKt;

public class ClosureAsAnonymousParameterEnhancer
extends AbstractClosureParameterEnhancer {
    @Override
    @Nullable
    protected PsiType getClosureParameterType(GrClosableBlock closure, int index) {
        ArrayList expectedTypes;
        if (closure.getParent() instanceof GrSafeCastExpression) {
            GrSafeCastExpression safeCastExpression = (GrSafeCastExpression)closure.getParent();
            GrTypeElement typeElement = safeCastExpression.getCastTypeElement();
            if (typeElement != null) {
                PsiType castType = typeElement.getType();
                expectedTypes = ContainerUtil.newArrayList(GroovyExpectedTypesProvider.getDefaultExpectedTypes(safeCastExpression));
                Iterator iterator2 = expectedTypes.iterator();
                while (iterator2.hasNext()) {
                    if (TypesUtil.isAssignable((PsiType)iterator2.next(), castType, closure)) continue;
                    iterator2.remove();
                }
                if (expectedTypes.isEmpty()) {
                    expectedTypes.add(castType);
                }
            } else {
                expectedTypes = GroovyExpectedTypesProvider.getDefaultExpectedTypes(closure);
            }
        } else {
            expectedTypes = GroovyExpectedTypesProvider.getDefaultExpectedTypes(closure);
        }
        for (PsiType constraint : expectedTypes) {
            PsiType suggestion;
            PsiType[] parameterTypes;
            MethodSignature sam2;
            PsiClassType.ClassResolveResult result;
            PsiClass resolved;
            if (!(constraint instanceof PsiClassType) || (resolved = (result = ((PsiClassType)constraint).resolveGenerics()).getElement()) == null || (sam2 = SamConversionKt.findSingleAbstractSignature(resolved)) == null || index >= (parameterTypes = sam2.getParameterTypes()).length || (suggestion = result.getSubstitutor().substitute(parameterTypes[index])) == null) continue;
            if (GroovyConfigUtils.getInstance().isVersionAtLeast(closure, "2.3") && suggestion instanceof PsiWildcardType && ((PsiWildcardType)suggestion).isSuper()) {
                return ((PsiWildcardType)suggestion).getBound();
            }
            return TypesUtil.substituteAndNormalizeType(suggestion, result.getSubstitutor(), null, closure);
        }
        return null;
    }
}

