/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;

public class GroovyNameSuggestionProvider
implements NameSuggestionProvider {
    public SuggestedNameInfo getSuggestedNames(final PsiElement element, @Nullable PsiElement nameSuggestionContext, Set<String> result) {
        PsiType type;
        if (nameSuggestionContext == null) {
            nameSuggestionContext = element;
        }
        if (element instanceof GrVariable && nameSuggestionContext instanceof GroovyPsiElement && (type = ((GrVariable)element).getTypeGroovy()) != null) {
            String[] names2 = GroovyNameSuggestionUtil.suggestVariableNameByType(type, new DefaultGroovyVariableNameValidator((GroovyPsiElement)nameSuggestionContext));
            result.addAll(Arrays.asList(names2));
            return new SuggestedNameInfo(names2){

                public void nameChosen(String name) {
                    JavaStatisticsManager.incVariableNameUseCount((String)name, (VariableKind)JavaCodeStyleManager.getInstance((Project)element.getProject()).getVariableKind((PsiVariable)((GrVariable)element)), (String)((GrVariable)element).getName(), (PsiType)type);
                }
            };
        }
        return null;
    }
}

