/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureParameterUsageInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.NewParameterCollidesWithLocalUsageInfo;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.PsiCallReference;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrMethodCallUsageInfo;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrUnresolvableLocalCollisionDetector;

class GrChageSignatureUsageSearcher {
    private final JavaChangeInfo myChangeInfo;
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChageSignatureUsageSearcher");

    GrChageSignatureUsageSearcher(JavaChangeInfo changeInfo) {
        this.myChangeInfo = changeInfo;
    }

    public UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        PsiMethod element = this.myChangeInfo.getMethod();
        if (element instanceof PsiMethod) {
            PsiMethod method = element;
            this.findSimpleUsages(method, result);
            UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
            return UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    private void findSimpleUsages(PsiMethod method, ArrayList<UsageInfo> result) {
        PsiMethod[] overridingMethods = this.findSimpleUsagesWithoutParameters(method, result, true, true, true);
        this.findParametersUsage(method, result, overridingMethods);
    }

    private void detectLocalsCollisionsInMethod(final GrMethod method, final ArrayList<UsageInfo> result, boolean isOriginal) {
        if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(method.getLanguage())) {
            return;
        }
        Object[] parameters = method.getParameterList().getParameters();
        final HashSet deletedOrRenamedParameters = new HashSet();
        if (isOriginal) {
            ContainerUtil.addAll(deletedOrRenamedParameters, (Object[])parameters);
            for (JavaParameterInfo parameterInfo : this.myChangeInfo.getNewParameters()) {
                if (parameterInfo.getOldIndex() < 0) continue;
                Object parameter = parameters[parameterInfo.getOldIndex()];
                if (!parameterInfo.getName().equals(parameter.getName())) continue;
                deletedOrRenamedParameters.remove(parameter);
            }
        }
        GrOpenBlock block = method.getBlock();
        for (JavaParameterInfo parameterInfo : this.myChangeInfo.getNewParameters()) {
            int oldParameterIndex = parameterInfo.getOldIndex();
            String newName = parameterInfo.getName();
            if (oldParameterIndex >= 0) {
                Object parameter;
                if (!isOriginal || newName.equals((parameter = parameters[oldParameterIndex]).getName())) continue;
                GrUnresolvableLocalCollisionDetector.CollidingVariableVisitor collidingVariableVisitor = new GrUnresolvableLocalCollisionDetector.CollidingVariableVisitor((PsiParameter)parameter, method){
                    final /* synthetic */ PsiParameter val$parameter;
                    final /* synthetic */ GrMethod val$method;
                    {
                        this.val$parameter = psiParameter;
                        this.val$method = grMethod;
                    }

                    @Override
                    public void visitCollidingVariable(PsiVariable collidingVariable) {
                        if (!deletedOrRenamedParameters.contains(collidingVariable)) {
                            result.add(new RenamedParameterCollidesWithLocalUsageInfo(this.val$parameter, (PsiElement)collidingVariable, this.val$method));
                        }
                    }
                };
                if (block == null) continue;
                GrUnresolvableLocalCollisionDetector.visitLocalsCollisions((PsiElement)parameter, newName, block, collidingVariableVisitor);
                continue;
            }
            GrUnresolvableLocalCollisionDetector.CollidingVariableVisitor variableVisitor = new GrUnresolvableLocalCollisionDetector.CollidingVariableVisitor(){

                @Override
                public void visitCollidingVariable(PsiVariable collidingVariable) {
                    if (!deletedOrRenamedParameters.contains(collidingVariable)) {
                        result.add(new NewParameterCollidesWithLocalUsageInfo((PsiElement)collidingVariable, (PsiElement)collidingVariable, (PsiMethod)method));
                    }
                }
            };
            if (block == null) continue;
            GrUnresolvableLocalCollisionDetector.visitLocalsCollisions(method, newName, block, variableVisitor);
        }
    }

    private void findParametersUsage(PsiMethod method, ArrayList<UsageInfo> result, PsiMethod[] overriders) {
        if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(method.getLanguage())) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (JavaParameterInfo info : this.myChangeInfo.getNewParameters()) {
            if (info.getOldIndex() < 0) continue;
            PsiParameter parameter = parameters[info.getOldIndex()];
            if (info.getName().equals(parameter.getName())) continue;
            GrChageSignatureUsageSearcher.addParameterUsages(parameter, result, (ParameterInfo)info);
            for (PsiMethod overrider : overriders) {
                if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(overrider.getLanguage())) continue;
                PsiParameter parameter1 = overrider.getParameterList().getParameters()[info.getOldIndex()];
                if (!parameter.getName().equals(parameter1.getName())) continue;
                GrChageSignatureUsageSearcher.addParameterUsages(parameter1, result, (ParameterInfo)info);
            }
        }
    }

    private PsiMethod[] findSimpleUsagesWithoutParameters(PsiMethod method, ArrayList<UsageInfo> result, boolean isToModifyArgs, boolean isToThrowExceptions, boolean isOriginal) {
        PsiElement element;
        boolean needToChangeCalls;
        PsiMethod[] overridingMethods;
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)method.getProject());
        for (PsiMethod overridingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(overridingMethod.getLanguage())) continue;
            result.add((UsageInfo)new OverriderUsageInfo(overridingMethod, method, isOriginal, isToModifyArgs, isToThrowExceptions));
        }
        boolean bl = needToChangeCalls = !this.myChangeInfo.isGenerateDelegate() && (this.myChangeInfo.isNameChanged() || this.myChangeInfo.isParameterSetOrOrderChanged() || this.myChangeInfo.isExceptionSetOrOrderChanged() || this.myChangeInfo.isVisibilityChanged());
        if (needToChangeCalls) {
            PsiReference[] refs;
            for (PsiReference ref : refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)method, (SearchScope)projectScope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                boolean isToCatchExceptions;
                element = ref.getElement();
                if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(element.getLanguage())) continue;
                boolean bl2 = isToCatchExceptions = isToThrowExceptions && this.needToCatchExceptions(RefactoringUtil.getEnclosingMethod((PsiElement)element));
                if (PsiUtil.isMethodUsage(element)) {
                    result.add(new GrMethodCallUsageInfo(element, isToModifyArgs, isToCatchExceptions, method));
                    continue;
                }
                if (element instanceof GrDocTagValueToken) {
                    result.add(new UsageInfo(ref.getElement()));
                    continue;
                }
                if (element instanceof GrMethod && ((GrMethod)element).isConstructor()) {
                    DefaultConstructorImplicitUsageInfo implicitUsageInfo = new DefaultConstructorImplicitUsageInfo((PsiMethod)((GrMethod)element), ((GrMethod)element).getContainingClass(), method);
                    result.add((UsageInfo)implicitUsageInfo);
                    continue;
                }
                if (element instanceof PsiClass) {
                    LOG.assertTrue(method.isConstructor());
                    PsiClass psiClass = (PsiClass)element;
                    if (psiClass instanceof GrAnonymousClassDefinition) {
                        result.add(new GrMethodCallUsageInfo(element, isToModifyArgs, isToCatchExceptions, method));
                        continue;
                    }
                    result.add((UsageInfo)new NoConstructorClassUsageInfo(psiClass));
                    continue;
                }
                if (ref instanceof PsiCallReference) {
                    result.add((UsageInfo)new CallReferenceUsageInfo((PsiCallReference)ref));
                    continue;
                }
                result.add((UsageInfo)new MoveRenameUsageInfo(element, ref, (PsiElement)method));
            }
        } else if (this.myChangeInfo.isParameterTypesChanged()) {
            PsiReference[] refs;
            for (PsiReference reference : refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)method, (SearchScope)projectScope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                element = reference.getElement();
                if (!(element instanceof GrDocTagValueToken)) continue;
                result.add(new UsageInfo(reference));
            }
        }
        if (method instanceof GrMethod) {
            this.detectLocalsCollisionsInMethod((GrMethod)method, result, isOriginal);
        }
        for (PsiMethod overridingMethod : overridingMethods) {
            if (!(overridingMethod instanceof GrMethod)) continue;
            this.detectLocalsCollisionsInMethod((GrMethod)overridingMethod, result, isOriginal);
        }
        return overridingMethods;
    }

    private static void addParameterUsages(PsiParameter parameter, ArrayList<UsageInfo> results2, ParameterInfo info) {
        for (PsiReference psiReference : ReferencesSearch.search((PsiElement)parameter)) {
            PsiElement parmRef = psiReference.getElement();
            ChangeSignatureParameterUsageInfo usageInfo = new ChangeSignatureParameterUsageInfo(parmRef, parameter.getName(), info.getName());
            results2.add((UsageInfo)usageInfo);
        }
        if (info.getName() != parameter.getName()) {
            // empty if block
        }
    }

    private boolean needToCatchExceptions(PsiMethod caller) {
        return this.myChangeInfo.isExceptionSetOrOrderChanged();
    }

    private static class RenamedParameterCollidesWithLocalUsageInfo
    extends UnresolvableCollisionUsageInfo {
        private final PsiElement myCollidingElement;
        private final PsiMethod myMethod;

        public RenamedParameterCollidesWithLocalUsageInfo(PsiParameter parameter, PsiElement collidingElement, PsiMethod method) {
            super((PsiElement)parameter, collidingElement);
            this.myCollidingElement = collidingElement;
            this.myMethod = method;
        }

        public String getDescription() {
            return RefactoringBundle.message((String)"there.is.already.a.0.in.the.1.it.will.conflict.with.the.renamed.parameter", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myCollidingElement, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)this.myMethod, (boolean)true)});
        }
    }
}

