/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.gutter.ConsoleIndicatorRenderer;
import org.jetbrains.kotlin.console.gutter.IconWithTooltip;
import org.jetbrains.kotlin.console.gutter.ReplIcons;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eR\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/console/HistoryUpdater;", "", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;)V", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "getConsoleView", "()Lcom/intellij/execution/console/LanguageConsoleImpl;", "consoleView$delegate", "Lkotlin/Lazy;", "addCommandTextToHistoryEditor", "", "trimmedCommandText", "", "addFoldingRegion", "historyEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "startOffset", "", "endOffset", "command", "addLineBreakIfNeeded", "printNewCommandInHistory", "Lcom/intellij/openapi/util/TextRange;", "idea"})
public final class HistoryUpdater {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy consoleView$delegate;
    private final KotlinConsoleRunner runner;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HistoryUpdater.class), "consoleView", "getConsoleView()Lcom/intellij/execution/console/LanguageConsoleImpl;"))};
    }

    private final LanguageConsoleImpl getConsoleView() {
        Lazy lazy = this.consoleView$delegate;
        HistoryUpdater historyUpdater = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (LanguageConsoleImpl)lazy.getValue();
    }

    @NotNull
    public final TextRange printNewCommandInHistory(@NotNull String trimmedCommandText) {
        RangeHighlighter rangeHighlighter;
        EditorEx historyEditor;
        Intrinsics.checkParameterIsNotNull((Object)trimmedCommandText, (String)"trimmedCommandText");
        EditorEx editorEx = historyEditor = this.getConsoleView().getHistoryViewer();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"historyEditor");
        this.addLineBreakIfNeeded(editorEx);
        DocumentEx documentEx = historyEditor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)documentEx, (String)"historyEditor.document");
        int startOffset = documentEx.getTextLength();
        int endOffset = startOffset + trimmedCommandText.length();
        this.addCommandTextToHistoryEditor(trimmedCommandText);
        this.addFoldingRegion(historyEditor, startOffset, endOffset, trimmedCommandText);
        RangeHighlighter $receiver = rangeHighlighter = historyEditor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 6000, null, HighlighterTargetArea.EXACT_RANGE);
        IconWithTooltip historyMarker = this.runner.isReadLineMode() ? ReplIcons.INSTANCE.getREADLINE_MARKER() : ReplIcons.INSTANCE.getCOMMAND_MARKER();
        $receiver.setGutterIconRenderer((GutterIconRenderer)new ConsoleIndicatorRenderer(historyMarker));
        historyEditor.getScrollingModel().scrollVertically(endOffset);
        return new TextRange(startOffset, endOffset);
    }

    private final void addCommandTextToHistoryEditor(String trimmedCommandText) {
        EditorEx consoleEditor;
        EditorEx editorEx = consoleEditor = this.getConsoleView().getConsoleEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"consoleEditor");
        DocumentEx consoleDocument = editorEx.getDocument();
        consoleDocument.setText((CharSequence)trimmedCommandText);
        LanguageConsoleView languageConsoleView = (LanguageConsoleView)this.getConsoleView();
        Editor editor = (Editor)consoleEditor;
        DocumentEx documentEx = consoleDocument;
        Intrinsics.checkExpressionValueIsNotNull((Object)documentEx, (String)"consoleDocument");
        LanguageConsoleImpl.printWithHighlighting((LanguageConsoleView)languageConsoleView, (Editor)editor, (TextRange)new TextRange(0, documentEx.getTextLength()));
        this.getConsoleView().flushDeferredText();
        consoleDocument.setText((CharSequence)"");
    }

    private final void addLineBreakIfNeeded(EditorEx historyEditor) {
        DocumentEx historyDocument;
        if (this.runner.isReadLineMode()) {
            return;
        }
        DocumentEx documentEx = historyDocument = historyEditor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)documentEx, (String)"historyDocument");
        String historyText = documentEx.getText();
        int textLength = historyText.length();
        String string = historyText;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"historyText");
        if (!StringsKt.endsWith$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) {
            historyDocument.insertString(textLength, (CharSequence)"\n");
            if (textLength == 0) {
                this.runner.addGutterIndicator(historyEditor, ReplIcons.INSTANCE.getHISTORY_INDICATOR());
            } else {
                historyDocument.insertString(textLength + 1, (CharSequence)"\n");
            }
        } else if (!StringsKt.endsWith$default((String)historyText, (String)"\n\n", (boolean)false, (int)2, null)) {
            historyDocument.insertString(textLength, (CharSequence)"\n");
        }
    }

    private final void addFoldingRegion(EditorEx historyEditor, int startOffset, int endOffset, String command2) {
        List cmdLines = StringsKt.lines((CharSequence)command2);
        int linesCount = cmdLines.size();
        if (linesCount < 2) {
            return;
        }
        FoldingModelEx foldingModel = historyEditor.getFoldingModel();
        foldingModel.runBatchFoldingOperation(new Runnable(foldingModel, startOffset, endOffset, cmdLines){
            final /* synthetic */ FoldingModelEx $foldingModel;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ List $cmdLines;

            public final void run() {
                this.$foldingModel.addFoldRegion(this.$startOffset, this.$endOffset, "" + (String)this.$cmdLines.get(0) + " ...");
            }
            {
                this.$foldingModel = foldingModelEx;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$cmdLines = list2;
            }
        });
    }

    public HistoryUpdater(@NotNull KotlinConsoleRunner runner) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runner), (String)"runner");
        this.runner = runner;
        this.consoleView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LanguageConsoleImpl>(this){
            final /* synthetic */ HistoryUpdater this$0;

            @NotNull
            public final LanguageConsoleImpl invoke() {
                LanguageConsoleView languageConsoleView = HistoryUpdater.access$getRunner$p(this.this$0).getConsoleView();
                if (languageConsoleView == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.console.LanguageConsoleImpl");
                }
                return (LanguageConsoleImpl)languageConsoleView;
            }
            {
                this.this$0 = historyUpdater;
                super(0);
            }
        }));
    }

    @NotNull
    public static final /* synthetic */ KotlinConsoleRunner access$getRunner$p(HistoryUpdater $this) {
        return $this.runner;
    }
}

