/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.generate;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.actions.generate.UtilsKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObject;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObjectKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\r\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\r\u001a3\u0010\u0012\u001a\u0004\u0018\u00010\b*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0086\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"MEMBER_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "confirmMemberRewrite", "", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtClass;[Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "generateFunctionSkeleton", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "descriptor", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getPropertiesToUseInGeneratedMember", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "classOrObject", "findDeclaredFunction", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "name", "", "checkSuperClasses", "filter", "Lkotlin/Function1;", "idea"})
public final class UtilsKt {
    private static final DescriptorRenderer MEMBER_RENDERER = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)MEMBER_RENDERER.1.INSTANCE));

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FunctionDescriptor findDeclaredFunction(@NotNull ClassDescriptor $receiver, @NotNull String name2, boolean checkSuperClasses, @NotNull Function1<? super FunctionDescriptor, Boolean> filter2) {
        while (true) {
            Object v2;
            Object object;
            block3: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
                MemberScope memberScope2 = $receiver.getUnsubstitutedMemberScope();
                Name name3 = Name.identifier(name2);
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(name)");
                object = memberScope2.getContributedFunctions(name3, NoLookupLocation.FROM_IDE);
                for (Object element$iv : $receiver$iv) {
                    SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getContainingDeclaration(), (Object)$receiver) && it.getKind() == CallableMemberDescriptor.Kind.DECLARATION && (Boolean)filter2.invoke((Object)it) != false)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            SimpleFunctionDescriptor simpleFunctionDescriptor = v2;
            if (simpleFunctionDescriptor != null) {
                Object it = object = simpleFunctionDescriptor;
                return (FunctionDescriptor)it;
            }
            if (!checkSuperClasses) break;
            $receiver = DescriptorUtilsKt.getSuperClassOrAny($receiver);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtNamedDeclaration> getPropertiesToUseInGeneratedMember(@NotNull KtClassOrObject classOrObject) {
        void var3_3;
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Object it;
        ArrayList arrayList;
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        Iterable $receiver = arrayList = new ArrayList();
        Iterable $receiver$iv = classOrObject.getPrimaryConstructorParameters();
        for (Object element$iv : $receiver$iv) {
            it = (KtParameter)element$iv;
            if (!((KtParameter)it).hasValOrVar()) continue;
            ((Collection)$receiver).add(element$iv);
        }
        Collection cfr_ignored_0 = (Collection)$receiver;
        $receiver$iv = classOrObject.getDeclarations();
        Iterator iterator2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            if (!(element$iv$iv instanceof KtProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            boolean bl;
            it = (KtProperty)element$iv;
            DeclarationDescriptor descriptor2 = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)it, null, 1, null);
            DeclarationDescriptor $i$f$filterIsInstanceTo = descriptor2;
            if ($i$f$filterIsInstanceTo instanceof ValueParameterDescriptor) {
                bl = true;
            } else if ($i$f$filterIsInstanceTo instanceof PropertyDescriptor) {
                PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor2).getGetter();
                bl = propertyGetterDescriptor != null ? propertyGetterDescriptor.isDefault() : true;
            } else {
                bl = false;
            }
            if (!bl) continue;
            ((Collection)$receiver).add(element$iv);
        }
        Collection cfr_ignored_1 = (Collection)$receiver;
        Iterable $receiver$iv2 = arrayList;
        $receiver = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (KtNamedDeclaration)element$iv$iv;
            String string = it.getName();
            if (!KtPsiUtilKt.isIdentifier(string != null ? KtPsiUtilKt.quoteIfNeeded(string) : null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    public static final boolean confirmMemberRewrite(@NotNull KtClass targetClass, FunctionDescriptor ... descriptors2) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)descriptors2, (String)"descriptors");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return true;
        }
        String functionsText2 = ArraysKt.joinToString$default((Object[])descriptors2, (CharSequence)" and ", null, null, (int)0, null, (Function1)confirmMemberRewrite.functionsText.1.INSTANCE, (int)30, null);
        String message2 = "Functions " + functionsText2 + " are already defined\nfor class " + targetClass.getName() + ". Do you want to delete them and proceed?";
        return Messages.showYesNoDialog((Project)targetClass.getProject(), (String)message2, (String)CodeInsightBundle.message((String)"generate.equals.and.hashcode.already.defined.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    public static final KtNamedFunction generateFunctionSkeleton(@NotNull FunctionDescriptor descriptor2, @NotNull KtClassOrObject targetClass) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Project project = targetClass.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"targetClass.project");
        KtCallableDeclaration ktCallableDeclaration = OverrideMemberChooserObjectKt.generateMember(OverrideMemberChooserObject.Companion.create$default(OverrideMemberChooserObject.Companion, project, descriptor2, descriptor2, OverrideMemberChooserObject.BodyType.EMPTY.INSTANCE, false, 16, null), targetClass, false);
        if (ktCallableDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
        }
        return (KtNamedFunction)ktCallableDeclaration;
    }

    @NotNull
    public static final /* synthetic */ DescriptorRenderer access$getMEMBER_RENDERER$p() {
        return MEMBER_RENDERER;
    }
}

