/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.EditorEvaluationCommand;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilder;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H$\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinRuntimeTypeEvaluator;", "Lcom/intellij/debugger/ui/EditorEvaluationCommand;", "Lorg/jetbrains/kotlin/types/KotlinType;", "editor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/debugger/impl/DebuggerContextImpl;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "evaluate", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "threadAction", "", "typeCalculationFinished", "type", "Companion", "idea-jvm"})
public abstract class KotlinRuntimeTypeEvaluator
extends EditorEvaluationCommand<KotlinType> {
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadAction() {
        KotlinType type2 = null;
        try {
            type2 = (KotlinType)this.evaluate();
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (EvaluateException evaluateException) {
        }
        finally {
            this.typeCalculationFinished(type2);
        }
    }

    protected abstract void typeCalculationFinished(@Nullable KotlinType var1);

    @Nullable
    protected KotlinType evaluate(@NotNull EvaluationContextImpl evaluationContext) {
        Intrinsics.checkParameterIsNotNull((Object)evaluationContext, (String)"evaluationContext");
        Project project = evaluationContext.getProject();
        ExpressionEvaluator evaluator2 = (ExpressionEvaluator)DebuggerInvocationUtil.commitAndRunReadAction((Project)project, (EvaluatingComputable)((EvaluatingComputable)new EvaluatingComputable<ExpressionEvaluator>(this, evaluationContext){
            final /* synthetic */ KotlinRuntimeTypeEvaluator this$0;
            final /* synthetic */ EvaluationContextImpl $evaluationContext;

            @NotNull
            public final ExpressionEvaluator compute() {
                PsiElement psiElement2 = KotlinRuntimeTypeEvaluator.access$getMyElement$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"myElement");
                Project project = psiElement2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myElement.project");
                KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
                PsiElement psiElement3 = KotlinRuntimeTypeEvaluator.access$getMyElement$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"myElement");
                String string = psiElement3.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myElement.text");
                PsiElement psiElement4 = KotlinRuntimeTypeEvaluator.access$getMyElement$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"myElement");
                PsiFile psiFile = psiElement4.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"myElement.containingFile");
                KtExpressionCodeFragment codeFragment = ktPsiFactory.createExpressionCodeFragment(string, psiFile.getContext());
                return KotlinEvaluationBuilder.INSTANCE.build((PsiElement)codeFragment, ContextUtil.getSourcePosition((StackFrameContext)((StackFrameContext)this.$evaluationContext)));
            }
            {
                this.this$0 = kotlinRuntimeTypeEvaluator;
                this.$evaluationContext = evaluationContextImpl;
            }
        }));
        com.sun.jdi.Value value2 = evaluator2.evaluate((EvaluationContext)evaluationContext);
        if (value2 != null) {
            DebugProcessImpl debugProcessImpl = evaluationContext.getDebugProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"evaluationContext.debugProcess");
            GlobalSearchScope globalSearchScope = debugProcessImpl.getSearchScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"evaluationContext.debugProcess.searchScope");
            return KotlinRuntimeTypeEvaluator.Companion.getCastableRuntimeType(globalSearchScope, value2);
        }
        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.surrounded.expression.null", (Object[])new Object[0]));
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026ounded.expression.null\"))");
        throw (Throwable)evaluateException;
    }

    public KotlinRuntimeTypeEvaluator(@Nullable Editor editor, @NotNull KtExpression expression2, @NotNull DebuggerContextImpl context, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        super(editor, (PsiElement)expression2, context, indicator);
    }

    public static final /* synthetic */ PsiElement access$getMyElement$p(KotlinRuntimeTypeEvaluator $this) {
        return $this.myElement;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinRuntimeTypeEvaluator$Companion;", "", "()V", "getCastableRuntimeType", "Lorg/jetbrains/kotlin/types/KotlinType;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "value", "Lcom/sun/jdi/Value;", "idea-jvm"})
    public static final class Companion {
        private final KotlinType getCastableRuntimeType(GlobalSearchScope scope2, com.sun.jdi.Value value2) {
            Value myValue = JdiValuesKt.asValue(value2);
            ClassDescriptor psiClass2 = KotlinEvaluationBuilderKt.getClassDescriptor(myValue.getAsmType(), scope2);
            if (psiClass2 != null) {
                return psiClass2.getDefaultType();
            }
            com.sun.jdi.Type type2 = value2.type();
            if (type2 instanceof ClassType) {
                ClassType superclass = ((ClassType)type2).superclass();
                if (superclass != null && Intrinsics.areEqual((Object)"java.lang.Object", (Object)superclass.name()) ^ true) {
                    Type type3 = Type.getType((String)superclass.signature());
                    Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"AsmType.getType(superclass.signature())");
                    psiClass2 = KotlinEvaluationBuilderKt.getClassDescriptor(type3, scope2);
                    if (psiClass2 != null) {
                        return psiClass2.getDefaultType();
                    }
                }
                for (InterfaceType interfaceType : ((ClassType)type2).interfaces()) {
                    Type type4 = Type.getType((String)interfaceType.signature());
                    Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"AsmType.getType(interfaceType.signature())");
                    psiClass2 = KotlinEvaluationBuilderKt.getClassDescriptor(type4, scope2);
                    if (psiClass2 == null) continue;
                    return psiClass2.getDefaultType();
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

