/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u000e\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\u0007H\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "createLineSeparatorByElement", "element", "getLineMarkerInfo", "canHaveSeparator", "", "wantsSeparator", "idea"})
public final class KotlinLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo<PsiElement> getLineMarkerInfo(@NotNull PsiElement element3) {
        block1: {
            block2: {
                PsiElement prevSibling2;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (!DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS || !this.canHaveSeparator(element3) || !this.canHaveSeparator(prevSibling2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default(element3, false, 1, null))) break block1;
                if (this.wantsSeparator(element3)) break block2;
                PsiElement psiElement2 = prevSibling2;
                if (psiElement2 == null) break block1;
                if (!this.wantsSeparator(psiElement2)) break block1;
            }
            return this.createLineSeparatorByElement(element3);
        }
        return null;
    }

    private final boolean canHaveSeparator(@Nullable PsiElement $receiver) {
        return $receiver instanceof KtFunction || $receiver instanceof KtClassInitializer || $receiver instanceof KtProperty && !((KtProperty)$receiver).isLocal();
    }

    private final boolean wantsSeparator(@NotNull PsiElement $receiver) {
        return StringUtil.getLineBreakCount((CharSequence)$receiver.getText()) > 0;
    }

    private final LineMarkerInfo<PsiElement> createLineSeparatorByElement(PsiElement element3) {
        PsiElement anchor2;
        PsiElement psiElement2 = anchor2 = PsiTreeUtil.getDeepestFirst((PsiElement)element3);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"anchor");
        LineMarkerInfo info = new LineMarkerInfo(anchor2, psiElement2.getTextRange(), null, 11, null, null, GutterIconRenderer.Alignment.RIGHT);
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        info.separatorColor = editorColorsManager.getGlobalScheme().getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        return info;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        if (elements2.isEmpty()) {
            return;
        }
        PsiElement first = (PsiElement)CollectionsKt.first(elements2);
        DumbService dumbService = DumbService.getInstance((Project)first.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(first.project)");
        if (dumbService.isDumb() || !ProjectRootsUtil.isInProjectOrLibSource(first)) {
            return;
        }
        HashSet<PsiElement> functions2 = new HashSet<PsiElement>();
        HashSet<PsiElement> properties2 = new HashSet<PsiElement>();
        for (PsiElement psiElement2 : elements2) {
            ProgressManager.checkCanceled();
            PsiElement psiElement3 = psiElement2;
            if (psiElement3 instanceof KtClass) {
                KotlinLineMarkerProviderKt.access$collectInheritedClassMarker((KtClass)psiElement2, result2);
                continue;
            }
            if (psiElement3 instanceof KtNamedFunction) {
                functions2.add(psiElement2);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)psiElement2, result2);
                continue;
            }
            if (psiElement3 instanceof KtProperty) {
                properties2.add(psiElement2);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)psiElement2, result2);
                continue;
            }
            if (!(psiElement3 instanceof KtParameter) || !((KtParameter)psiElement2).hasValOrVar()) continue;
            properties2.add(psiElement2);
            KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)psiElement2, result2);
        }
        KotlinLineMarkerProviderKt.access$collectOverriddenFunctions(functions2, result2);
        KotlinLineMarkerProviderKt.access$collectOverriddenPropertyAccessors(properties2, result2);
        for (PsiElement psiElement4 : elements2) {
            if (!(psiElement4 instanceof KtNamedDeclaration)) continue;
            if (KotlinLineMarkerProviderKt.isExpectDeclaration((KtNamedDeclaration)psiElement4)) {
                KotlinLineMarkerProviderKt.access$collectActualMarkers((KtNamedDeclaration)psiElement4, result2);
                continue;
            }
            if (!KotlinLineMarkerProviderKt.isActualDeclaration((KtNamedDeclaration)psiElement4)) continue;
            KotlinLineMarkerProviderKt.access$collectExpectedMarkers((KtNamedDeclaration)psiElement4, result2);
        }
    }
}

