/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000eH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinJavaMavenConfigurator;", "Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator;", "()V", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "configureModule", "", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "version", "", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "configurePlugin", "", "pom", "Lorg/jetbrains/kotlin/idea/maven/PomFile;", "plugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "createExecutions", "pomFile", "kotlinPlugin", "getStdlibArtifactId", "isKotlinModule", "isRelevantGoal", "goalName", "Companion", "idea-maven"})
public final class KotlinJavaMavenConfigurator
extends KotlinMavenConfigurator {
    private static final String NAME = "maven";
    @NotNull
    public static final String TEST_LIB_ID = "kotlin-test";
    private static final String PRESENTABLE_TEXT = "Maven";
    public static final Companion Companion = new Companion(null);

    @Override
    protected boolean isKotlinModule(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJvmRuntimeInScope(module);
    }

    @Override
    protected boolean isRelevantGoal(@NotNull String goalName) {
        Intrinsics.checkParameterIsNotNull((Object)goalName, (String)"goalName");
        return Intrinsics.areEqual((Object)goalName, (Object)"compile");
    }

    @Override
    @NotNull
    protected String getStdlibArtifactId(@NotNull Module module, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        return KotlinRuntimeLibraryUtilKt.getStdlibArtifactId(moduleRootManager.getSdk(), version);
    }

    @Override
    protected void createExecutions(@NotNull PomFile pomFile, @NotNull MavenDomPlugin kotlinPlugin, @NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)pomFile, (String)"pomFile");
        Intrinsics.checkParameterIsNotNull((Object)kotlinPlugin, (String)"kotlinPlugin");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.createExecution(pomFile, kotlinPlugin, "compile", "compile", module, false);
        this.createExecution(pomFile, kotlinPlugin, "test-compile", "test-compile", module, true);
    }

    @Override
    protected void configurePlugin(@NotNull PomFile pom, @NotNull MavenDomPlugin plugin, @NotNull Module module, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)pom, (String)"pom");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        Sdk sdk = moduleRootManager.getSdk();
        JvmTarget jvmTarget = KotlinRuntimeLibraryUtilKt.getDefaultJvmTarget(sdk, version);
        if (jvmTarget != null) {
            pom.addPluginConfiguration(plugin, "jvmTarget", jvmTarget.getDescription());
        }
    }

    @Override
    public boolean configureModule(@NotNull Module module, @NotNull PsiFile file2, @NotNull String version, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        if (!super.configureModule(module, file2, version, collector2)) {
            return false;
        }
        ConfigureKotlinInProjectUtilsKt.addStdlibToJavaModuleInfo(module, collector2);
        return true;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JvmPlatform.INSTANCE;
    }

    public KotlinJavaMavenConfigurator() {
        super(TEST_LIB_ID, false, NAME, PRESENTABLE_TEXT);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinJavaMavenConfigurator$Companion;", "", "()V", "NAME", "", "PRESENTABLE_TEXT", "TEST_LIB_ID", "idea-maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

