/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.nodejs.jest;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunConfigurationProducer;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.js.JsUtilsKt;
import org.jetbrains.kotlin.idea.nodejs.NodeJsUtilKt;
import org.jetbrains.kotlin.idea.nodejs.TestElementInfo;
import org.jetbrains.kotlin.idea.nodejs.TestElementPath;
import org.jetbrains.kotlin.idea.nodejs.jest.KotlinJestRunConfigurationProducer$WhenMappings;
import org.jetbrains.kotlin.idea.run.RcUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004j\u0004\u0018\u0001`\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J&\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/nodejs/jest/KotlinJestRunConfigurationProducer;", "Lcom/intellij/javascript/jest/JestRunConfigurationProducer;", "()V", "createTestElementRunInfo", "Lorg/jetbrains/kotlin/idea/nodejs/TestElementInfo;", "Lcom/intellij/javascript/jest/JestRunSettings;", "Lorg/jetbrains/kotlin/idea/nodejs/jest/JestTestElementInfo;", "element", "Lcom/intellij/psi/PsiElement;", "originalSettings", "isConfigurationFromCompatibleContext", "", "configuration", "Lcom/intellij/javascript/jest/JestRunConfiguration;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromCompatibleContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "ultimate"})
public final class KotlinJestRunConfigurationProducer
extends JestRunConfigurationProducer {
    /*
     * WARNING - void declaration
     */
    private final TestElementInfo<JestRunSettings> createTestElementRunInfo(PsiElement element3, JestRunSettings originalSettings) {
        JestRunSettings jestRunSettings;
        Module module = ProjectStructureUtilKt.getModule(element3);
        if (module == null || (module = JsUtilsKt.jsOrJsImpl(module)) == null) {
            return null;
        }
        Module module2 = module;
        Project project = module2.getProject();
        String string = JsUtilsKt.getJsTestOutputFilePath(module2);
        if (string == null) {
            return null;
        }
        String testFilePath = string;
        String string2 = originalSettings.getWorkingDirSystemDependentPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"originalSettings.workingDirSystemDependentPath");
        if (StringsKt.isBlank((CharSequence)string2)) {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            VirtualFile virtualFile2 = project2.getBaseDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"project.baseDir");
            String workingDir = FileUtil.toSystemDependentName((String)virtualFile2.getPath());
            jestRunSettings = originalSettings.toBuilder().setWorkingDir(workingDir).build();
        } else {
            jestRunSettings = originalSettings;
        }
        JestRunSettings settings2 = jestRunSettings;
        TestElementPath testElementPath = TestElementPath.Companion.forElement(element3, module2);
        if (testElementPath == null) {
            return null;
        }
        TestElementPath testElementPath2 = testElementPath;
        JestRunSettings.Builder builder = settings2.toBuilder();
        builder.setTestFilePath(testFilePath);
        TestElementPath testElementPath3 = testElementPath2;
        if (testElementPath3 instanceof TestElementPath.BySuite) {
            void suiteNames2;
            TestElementPath.BySuite bySuite = (TestElementPath.BySuite)testElementPath2;
            List<String> list2 = bySuite.component1();
            String testName = bySuite.component2();
            if (testName == null) {
                builder.setScopeKind(JestScopeKind.SUITE);
                builder.setTestNames((List)suiteNames2);
            } else {
                builder.setScopeKind(JestScopeKind.TEST);
                builder.setTestNames(CollectionsKt.plus((Collection)((Collection)suiteNames2), (Object)testName));
            }
        } else if (testElementPath3 instanceof TestElementPath.BySingleFile) {
            builder.setScopeKind(JestScopeKind.TEST_FILE);
        }
        builder.setEnvData(NodeJsUtilKt.getNodeJsEnvironmentVars(module2));
        JestRunSettings jestRunSettings2 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jestRunSettings2, (String)"builder.build()");
        return new TestElementInfo<JestRunSettings>(jestRunSettings2, element3);
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration2, @NotNull ConfigurationContext context) {
        boolean bl;
        PsiElement element3;
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiElement psiElement2 = context.getPsiLocation();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement psiElement3 = element3 = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
        JestRunSettings jestRunSettings = configuration2.getRunSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)jestRunSettings, (String)"configuration.runSettings");
        TestElementInfo<JestRunSettings> testElementInfo = this.createTestElementRunInfo(psiElement3, jestRunSettings);
        if (testElementInfo == null) {
            return false;
        }
        TestElementInfo<JestRunSettings> testElementInfo2 = testElementInfo;
        JestRunSettings thisRunSettings = testElementInfo2.component1();
        JestRunSettings thatRunSettings = configuration2.getRunSettings();
        String string = thisRunSettings.getConfigFileSystemDependentPath();
        JestRunSettings jestRunSettings2 = thatRunSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)jestRunSettings2, (String)"thatRunSettings");
        if (Intrinsics.areEqual((Object)string, (Object)jestRunSettings2.getConfigFileSystemDependentPath()) ^ true) {
            return false;
        }
        if (thatRunSettings.getScopeKind() != thisRunSettings.getScopeKind()) {
            return false;
        }
        switch (KotlinJestRunConfigurationProducer$WhenMappings.$EnumSwitchMapping$0[thisRunSettings.getScopeKind().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = Intrinsics.areEqual((Object)thisRunSettings.getTestFileSystemDependentPath(), (Object)thatRunSettings.getTestFileSystemDependentPath());
                break;
            }
            case 3: 
            case 4: {
                if (Intrinsics.areEqual((Object)thisRunSettings.getTestFileSystemDependentPath(), (Object)thatRunSettings.getTestFileSystemDependentPath()) && Intrinsics.areEqual((Object)thisRunSettings.getTestNames(), (Object)thatRunSettings.getTestNames())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setupConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        void runSettings;
        PsiElement element3;
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        PsiElement psiElement2 = context.getPsiLocation();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement psiElement3 = element3 = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
        Module module = ProjectStructureUtilKt.getModule(psiElement3);
        Module module2 = module;
        if (module2 == null || (module2 = JsUtilsKt.jsOrJsImpl(module2)) == null) {
            return false;
        }
        Module jsModule = module2;
        VirtualFile virtualFile2 = Intrinsics.areEqual((Object)jsModule, (Object)module) ^ true ? jsModule.getModuleFile() : PsiUtilCore.getVirtualFile((PsiElement)element3);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile file2 = virtualFile2;
        Project project = module.getProject();
        if (!this.isTestRunnerPackageAvailableFor(project, file2)) {
            return false;
        }
        JestRunSettings jestRunSettings = configuration2.getRunSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)jestRunSettings, (String)"configuration.runSettings");
        TestElementInfo<JestRunSettings> testElementInfo = this.createTestElementRunInfo(element3, jestRunSettings);
        if (testElementInfo == null) {
            return false;
        }
        TestElementInfo<JestRunSettings> testElementInfo2 = testElementInfo;
        JestRunSettings jestRunSettings2 = testElementInfo2.component1();
        PsiElement enclosingTestElement = testElementInfo2.component2();
        configuration2.setRunSettings((JestRunSettings)runSettings);
        sourceElement.set((Object)enclosingTestElement);
        configuration2.setGeneratedName();
        RcUtilsKt.addBuildTask((RunConfiguration)configuration2);
        return true;
    }
}

