/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.Java9StructureUtilKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0017J\b\u0010\b\u001a\u00020\u0005H\u0017J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/KotlinAddRequiredModuleFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "module", "Lcom/intellij/psi/PsiJavaModule;", "requiredName", "", "(Lcom/intellij/psi/PsiJavaModule;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "isAvailable", "", "startInWriteAction", "Companion", "idea"})
public final class KotlinAddRequiredModuleFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String requiredName;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"module.info.add.requires.family.name", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"QuickFixBundle.message(\"\u2026dd.requires.family.name\")");
        return string;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message((String)"module.info.add.requires.name", (Object[])new Object[]{this.requiredName});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"QuickFixBundle.message(\"\u2026ires.name\", requiredName)");
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement2, @NotNull PsiElement endElement2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startElement2, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement2, (String)"endElement");
        return PsiUtil.isLanguageLevel9OrHigher((PsiElement)((PsiElement)file2)) && startElement2 instanceof PsiJavaModule && startElement2.getManager().isInProject(startElement2) && KotlinAddRequiredModuleFix.Companion.getLBrace((PsiJavaModule)startElement2) != null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement2, @NotNull PsiElement endElement2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startElement2, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement2, (String)"endElement");
        Companion.addModuleRequirement((PsiJavaModule)startElement2, this.requiredName);
    }

    public KotlinAddRequiredModuleFix(@NotNull PsiJavaModule module, @NotNull String requiredName) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)requiredName, (String)"requiredName");
        super((PsiElement)module);
        this.requiredName = requiredName;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/KotlinAddRequiredModuleFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "addModuleRequirement", "", "module", "Lcom/intellij/psi/PsiJavaModule;", "requiredName", "", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "findAddingPlace", "Lcom/intellij/psi/PsiElement;", "getLBrace", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            DiagnosticWithParameters1 dependDiagnostic;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            KtExpression ktExpression = (KtExpression)psiElement2;
            if (ktExpression == null) {
                return null;
            }
            KtExpression expression2 = ktExpression;
            PsiJavaModule psiJavaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)((PsiElement)expression2));
            if (psiJavaModule == null) {
                return null;
            }
            PsiJavaModule javaModule = psiJavaModule;
            DiagnosticWithParameters1 diagnosticWithParameters1 = dependDiagnostic = (DiagnosticWithParameters1)DiagnosticFactory.cast(diagnostic, ErrorsJvm.JAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE);
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticWithParameters1, (String)"dependDiagnostic");
            String moduleName = (String)diagnosticWithParameters1.getA();
            PsiJavaModule psiJavaModule2 = javaModule;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiJavaModule2, (String)"javaModule");
            String string = moduleName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleName");
            return (IntentionAction)new KotlinAddRequiredModuleFix(psiJavaModule2, string);
        }

        public final boolean addModuleRequirement(@NotNull PsiJavaModule module, @NotNull String requiredName) {
            PsiJavaModule tempModule;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)requiredName, (String)"requiredName");
            if (!module.isValid()) {
                return false;
            }
            if (Java9StructureUtilKt.findRequireDirective(module, requiredName) != null) {
                return false;
            }
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)javaPsiFacade, (String)"JavaPsiFacade.getInstance(module.project)");
            PsiJavaParserFacade parserFacade = javaPsiFacade.getParserFacade();
            PsiJavaModule psiJavaModule = tempModule = parserFacade.createModuleFromText("module TempModuleName { requires " + requiredName + "; }");
            Intrinsics.checkExpressionValueIsNotNull((Object)psiJavaModule, (String)"tempModule");
            Iterable iterable = psiJavaModule.getRequires();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"tempModule.requires");
            PsiRequiresStatement requiresStatement = (PsiRequiresStatement)CollectionsKt.first((Iterable)iterable);
            PsiElement psiElement2 = this.findAddingPlace(module);
            if (psiElement2 == null) {
                return false;
            }
            PsiElement addingPlace = psiElement2;
            addingPlace.getParent().addAfter((PsiElement)requiresStatement, addingPlace);
            return true;
        }

        private final PsiElement getLBrace(PsiJavaModule module) {
            PsiJavaModuleReferenceElement nameElement = module.getNameIdentifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)nameElement, (String)"nameElement");
            for (PsiElement element3 = (v954046).getNextSibling(); element3 != null; element3 = element3.getNextSibling()) {
                if (!PsiUtil.isJavaToken((PsiElement)element3, (IElementType)JavaTokenType.LBRACE)) continue;
                return element3;
            }
            return null;
        }

        private final PsiElement findAddingPlace(PsiJavaModule module) {
            PsiRequiresStatement addingPlace;
            Iterable iterable = module.getRequires();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"module.requires");
            PsiRequiresStatement psiRequiresStatement = addingPlace = (PsiRequiresStatement)CollectionsKt.lastOrNull((Iterable)iterable);
            return psiRequiresStatement != null ? (PsiElement)psiRequiresStatement : this.getLBrace(module);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

