/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancement;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J,\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016Jf\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a26\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00040\u001cH\u0002JI\u0010\"\u001a\u0004\u0018\u0001H#\"\b\b\u0000\u0010#*\u00020$2\u0006\u0010%\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H#0\u0017H\u0002\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\u0004\u0018\u00010\u001d*\u00020\u0011H\u0002J\u000e\u0010)\u001a\u0004\u0018\u00010\u001d*\u00020\u0011H\u0002\u00a8\u0006*\u00b2\u0006\r\u0010\u0016\u001a\u00020\u0018X\u008a\u0084\u0002\u00a2\u0006\u0000"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkReceiver", "", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "safeAccess", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "checkType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "doCheckType", "expectedType", "dataFlowValue", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "reportWarning", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/ErrorsJvm$NullabilityInformationSource;", "Lkotlin/ParameterName;", "name", "expectedMustNotBeNull", "actualMayBeNull", "doIfNotNull", "T", "", "type", "body", "(Lorg/jetbrains/kotlin/types/KotlinType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "mayBeNull", "mustNotBeNull", "frontend.java"})
public final class JavaNullabilityChecker
implements AdditionalTypeChecker {
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaNullabilityChecker.class), "dataFlowValue", "<v#0>"))};
    }

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        IElementType iElementType;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"c.expectedType");
        Function0 function0 = (Function0)new Function0<DataFlowValue>(expression2, expressionType, c){
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ KotlinType $expressionType;
            final /* synthetic */ ResolutionContext $c;

            @NotNull
            public final DataFlowValue invoke() {
                return DataFlowValueFactory.createDataFlowValue(this.$expression, this.$expressionType, this.$c);
            }
            {
                this.$expression = ktExpression;
                this.$expressionType = kotlinType;
                this.$c = resolutionContext;
                super(0);
            }
        };
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"c.dataFlowInfo");
        this.doCheckType(expressionType, kotlinType, (Function0<DataFlowValue>)function0, dataFlowInfo, (Function2<? super ErrorsJvm.NullabilityInformationSource, ? super ErrorsJvm.NullabilityInformationSource, Unit>)((Function2)new Function2<ErrorsJvm.NullabilityInformationSource, ErrorsJvm.NullabilityInformationSource, Unit>(c, expression2){
            final /* synthetic */ ResolutionContext $c;
            final /* synthetic */ KtExpression $expression;

            public final void invoke(@NotNull ErrorsJvm.NullabilityInformationSource expectedMustNotBeNull, @NotNull ErrorsJvm.NullabilityInformationSource actualMayBeNull) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)expectedMustNotBeNull), (String)"expectedMustNotBeNull");
                Intrinsics.checkParameterIsNotNull((Object)((Object)actualMayBeNull), (String)"actualMayBeNull");
                this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)this.$expression), expectedMustNotBeNull, actualMayBeNull));
            }
            {
                this.$c = resolutionContext;
                this.$expression = ktExpression;
                super(2);
            }
        }));
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtWhenExpression) {
            if (((KtWhenExpression)expression2).getElseExpression() == null) {
                KotlinType type2;
                KtExpression ktExpression2 = ((KtWhenExpression)expression2).getSubjectExpression();
                if (ktExpression2 == null) {
                    return;
                }
                KtExpression subjectExpression = ktExpression2;
                KotlinType kotlinType2 = c.trace.getType(subjectExpression);
                if (kotlinType2 == null) {
                    return;
                }
                KotlinType kotlinType3 = type2 = kotlinType2;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"type");
                if (FlexibleTypesKt.isFlexible(kotlinType3) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType(type2).getUpperBound())) {
                    ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
                    if (classDescriptor == null) {
                        return;
                    }
                    ClassDescriptor enumClassDescriptor = classDescriptor;
                    BindingTrace bindingTrace = c.trace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"c.trace");
                    BindingContext context = bindingTrace.getBindingContext();
                    KtWhenExpression ktWhenExpression = (KtWhenExpression)expression2;
                    BindingContext bindingContext2 = context;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context");
                    if (WhenChecker.getEnumMissingCases(ktWhenExpression, bindingContext2, enumClassDescriptor).isEmpty() && !WhenChecker.INSTANCE.containsNullCase((KtWhenExpression)expression2, context)) {
                        DataFlowInfo dataFlowInfo2;
                        KtExpression ktExpression3 = subjectExpression;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"subjectExpression");
                        DataFlowValue subjectDataFlowValue = DataFlowValueFactory.createDataFlowValue(ktExpression3, type2, c);
                        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)c.trace.get(BindingContext.EXPRESSION_TYPE_INFO, subjectExpression);
                        DataFlowInfo dataFlowInfo3 = dataFlowInfo2 = kotlinTypeInfo != null ? kotlinTypeInfo.getDataFlowInfo() : null;
                        if (dataFlowInfo2 != null && !dataFlowInfo2.getStableNullability(subjectDataFlowValue).canBeNull()) {
                            return;
                        }
                        BindingTrace bindingTrace2 = c.trace;
                        KtExpression ktExpression4 = ((KtWhenExpression)expression2).getSubjectExpression();
                        if (ktExpression4 == null) {
                            Intrinsics.throwNpe();
                        }
                        bindingTrace2.report(ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA.on((KtExpression)((PsiElement)ktExpression4)));
                    }
                }
            }
        } else if (ktExpression instanceof KtPostfixExpression) {
            if (Intrinsics.areEqual((Object)((KtPostfixExpression)expression2).getOperationToken(), (Object)((Object)KtTokens.EXCLEXCL))) {
                KotlinType baseExpressionType;
                KtExpression ktExpression5 = ((KtPostfixExpression)expression2).getBaseExpression();
                if (ktExpression5 == null) {
                    return;
                }
                KtExpression baseExpression = ktExpression5;
                KotlinType kotlinType4 = c.trace.getType(baseExpression);
                if (kotlinType4 == null) {
                    return;
                }
                KotlinType kotlinType5 = baseExpressionType = kotlinType4;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType5, (String)"baseExpressionType");
                this.doIfNotNull(kotlinType5, (Function0<DataFlowValue>)((Function0)new Function0<DataFlowValue>(baseExpression, baseExpressionType, c){
                    final /* synthetic */ KtExpression $baseExpression;
                    final /* synthetic */ KotlinType $baseExpressionType;
                    final /* synthetic */ ResolutionContext $c;

                    @NotNull
                    public final DataFlowValue invoke() {
                        KtExpression ktExpression = this.$baseExpression;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"baseExpression");
                        KotlinType kotlinType = this.$baseExpressionType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"baseExpressionType");
                        return DataFlowValueFactory.createDataFlowValue(ktExpression, kotlinType, this.$c);
                    }
                    {
                        this.$baseExpression = ktExpression;
                        this.$baseExpressionType = kotlinType;
                        this.$c = resolutionContext;
                        super(0);
                    }
                }), c, (Function0)new Function0<Unit>(c, expression2, baseExpressionType){
                    final /* synthetic */ ResolutionContext $c;
                    final /* synthetic */ KtExpression $expression;
                    final /* synthetic */ KotlinType $baseExpressionType;

                    public final void invoke() {
                        this.$c.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on((PsiElement)((KtPostfixExpression)this.$expression).getOperationReference(), this.$baseExpressionType));
                    }
                    {
                        this.$c = resolutionContext;
                        this.$expression = ktExpression;
                        this.$baseExpressionType = kotlinType;
                        super(0);
                    }
                });
            }
        } else if (ktExpression instanceof KtBinaryExpression && (Intrinsics.areEqual((Object)(iElementType = ((KtBinaryExpression)expression2).getOperationToken()), (Object)((Object)KtTokens.EQEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ))) && ((KtBinaryExpression)expression2).getLeft() != null && ((KtBinaryExpression)expression2).getRight() != null) {
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)expression2;
            KtExpression ktExpression6 = ((KtBinaryExpression)expression2).getLeft();
            if (ktExpression6 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"expression.left!!");
            KtExpression ktExpression7 = ((KtBinaryExpression)expression2).getRight();
            if (ktExpression7 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression7, (String)"expression.right!!");
            SenselessComparisonChecker.checkSenselessComparisonWithNull(ktBinaryExpression, ktExpression6, ktExpression7, c, (Function1<? super KtExpression, ? extends KotlinType>)((Function1)new Function1<KtExpression, KotlinType>(c){
                final /* synthetic */ ResolutionContext $c;

                @Nullable
                public final KotlinType invoke(@NotNull KtExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$c.trace.getType(it);
                }
                {
                    this.$c = resolutionContext;
                    super(1);
                }
            }), (Function1<? super DataFlowValue, ? extends Nullability>)((Function1)new Function1<DataFlowValue, Nullability>(this, c){
                final /* synthetic */ JavaNullabilityChecker this$0;
                final /* synthetic */ ResolutionContext $c;

                @NotNull
                public final Nullability invoke(@NotNull DataFlowValue value2) {
                    Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                    Nullability nullability = (Nullability)((Object)JavaNullabilityChecker.access$doIfNotNull(this.this$0, value2.getType(), (Function0)new Function0<DataFlowValue>(value2){
                        final /* synthetic */ DataFlowValue $value;

                        @NotNull
                        public final DataFlowValue invoke() {
                            return this.$value;
                        }
                        {
                            this.$value = dataFlowValue2;
                            super(0);
                        }
                    }, this.$c, checkType.2.INSTANCE));
                    if (nullability == null) {
                        nullability = Nullability.UNKNOWN;
                    }
                    return nullability;
                }
                {
                    this.this$0 = javaNullabilityChecker;
                    this.$c = resolutionContext;
                    super(1);
                }
            }));
        }
    }

    @Override
    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull((Object)receiverParameter, (String)"receiverParameter");
        Intrinsics.checkParameterIsNotNull((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        KProperty kProperty = $$delegatedProperties[0];
        Lazy dataFlowValue2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<DataFlowValue>(receiverArgument, c){
            final /* synthetic */ ReceiverValue $receiverArgument;
            final /* synthetic */ CallResolutionContext $c;

            @NotNull
            public final DataFlowValue invoke() {
                return DataFlowValueFactory.createDataFlowValue(this.$receiverArgument, this.$c);
            }
            {
                this.$receiverArgument = receiverValue;
                this.$c = callResolutionContext;
                super(0);
            }
        }));
        if (safeAccess) {
            Call call2 = c.call;
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"c.call");
            ASTNode aSTNode = call2.getCallOperationNode();
            if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null) {
                return;
            }
            ASTNode safeAccessElement = aSTNode;
            KotlinType kotlinType = receiverArgument.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverArgument.type");
            this.doIfNotNull(kotlinType, (Function0<DataFlowValue>)((Function0)new Function0<DataFlowValue>(dataFlowValue2, kProperty){
                final /* synthetic */ Lazy $dataFlowValue;
                final /* synthetic */ KProperty $dataFlowValue$metadata;

                @NotNull
                public final DataFlowValue invoke() {
                    Lazy lazy = this.$dataFlowValue;
                    Object var2_2 = null;
                    KProperty kProperty = this.$dataFlowValue$metadata;
                    return (DataFlowValue)lazy.getValue();
                }
                {
                    this.$dataFlowValue = lazy;
                    this.$dataFlowValue$metadata = kProperty;
                    super(0);
                }
            }), (ResolutionContext)c, (Function0)new Function0<Unit>(c, (PsiElement)safeAccessElement, receiverArgument){
                final /* synthetic */ CallResolutionContext $c;
                final /* synthetic */ PsiElement $safeAccessElement;
                final /* synthetic */ ReceiverValue $receiverArgument;

                public final void invoke() {
                    this.$c.trace.report(Errors.UNNECESSARY_SAFE_CALL.on(this.$safeAccessElement, this.$receiverArgument.getType()));
                }
                {
                    this.$c = callResolutionContext;
                    this.$safeAccessElement = psiElement2;
                    this.$receiverArgument = receiverValue;
                    super(0);
                }
            });
            return;
        }
        KotlinType kotlinType = receiverArgument.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverArgument.type");
        KotlinType kotlinType2 = receiverParameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"receiverParameter.type");
        Function0 function0 = (Function0)new Function0<DataFlowValue>(dataFlowValue2, kProperty){
            final /* synthetic */ Lazy $dataFlowValue;
            final /* synthetic */ KProperty $dataFlowValue$metadata;

            @NotNull
            public final DataFlowValue invoke() {
                Lazy lazy = this.$dataFlowValue;
                Object var2_2 = null;
                KProperty kProperty = this.$dataFlowValue$metadata;
                return (DataFlowValue)lazy.getValue();
            }
            {
                this.$dataFlowValue = lazy;
                this.$dataFlowValue$metadata = kProperty;
                super(0);
            }
        };
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"c.dataFlowInfo");
        this.doCheckType(kotlinType, kotlinType2, (Function0<DataFlowValue>)function0, dataFlowInfo, (Function2<? super ErrorsJvm.NullabilityInformationSource, ? super ErrorsJvm.NullabilityInformationSource, Unit>)((Function2)new Function2<ErrorsJvm.NullabilityInformationSource, ErrorsJvm.NullabilityInformationSource, Unit>(receiverArgument, c){
            final /* synthetic */ ReceiverValue $receiverArgument;
            final /* synthetic */ CallResolutionContext $c;

            public final void invoke(@NotNull ErrorsJvm.NullabilityInformationSource expectedMustNotBeNull, @NotNull ErrorsJvm.NullabilityInformationSource actualMayBeNull) {
                KtElement ktElement;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)((Object)expectedMustNotBeNull), (String)"expectedMustNotBeNull");
                Intrinsics.checkParameterIsNotNull((Object)((Object)actualMayBeNull), (String)"actualMayBeNull");
                ReceiverValue receiverValue = this.$receiverArgument;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                if ((object = (ExpressionReceiver)receiverValue) != null && (object = object.getExpression()) != null) {
                    ktElement = (KtElement)object;
                } else {
                    Call call2 = this.$c.call;
                    Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"c.call");
                    KtExpression ktExpression = call2.getCalleeExpression();
                    if (ktExpression != null) {
                        ktElement = ktExpression;
                    } else {
                        Call call3 = this.$c.call;
                        Intrinsics.checkExpressionValueIsNotNull((Object)call3, (String)"c.call");
                        ktElement = call3.getCallElement();
                    }
                }
                KtElement reportOn = ktElement;
                this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)reportOn), expectedMustNotBeNull, actualMayBeNull));
            }
            {
                this.$receiverArgument = receiverValue;
                this.$c = callResolutionContext;
                super(2);
            }
        }));
    }

    private final void doCheckType(KotlinType expressionType, KotlinType expectedType2, Function0<DataFlowValue> dataFlowValue2, DataFlowInfo dataFlowInfo, Function2<? super ErrorsJvm.NullabilityInformationSource, ? super ErrorsJvm.NullabilityInformationSource, Unit> reportWarning) {
        if (TypeUtils.noExpectedType(expectedType2)) {
            return;
        }
        ErrorsJvm.NullabilityInformationSource expectedMustNotBeNull = this.mustNotBeNull(expectedType2);
        ErrorsJvm.NullabilityInformationSource actualMayBeNull = this.mayBeNull(expressionType);
        if (expectedMustNotBeNull == ErrorsJvm.NullabilityInformationSource.KOTLIN && actualMayBeNull == ErrorsJvm.NullabilityInformationSource.KOTLIN) {
            return;
        }
        if (expectedMustNotBeNull != null && actualMayBeNull != null && dataFlowInfo.getStableNullability((DataFlowValue)dataFlowValue2.invoke()) != Nullability.NOT_NULL) {
            reportWarning.invoke((Object)expectedMustNotBeNull, (Object)actualMayBeNull);
        }
    }

    private final <T> T doIfNotNull(KotlinType type2, Function0<DataFlowValue> dataFlowValue2, ResolutionContext<?> c, Function0<? extends T> body2) {
        return (T)(this.mustNotBeNull(type2) == ErrorsJvm.NullabilityInformationSource.JAVA && c.dataFlowInfo.getStableNullability((DataFlowValue)dataFlowValue2.invoke()).canBeNull() ? body2.invoke() : null);
    }

    private final ErrorsJvm.NullabilityInformationSource mustNotBeNull(@NotNull KotlinType $receiver) {
        return !KotlinTypeKt.isError($receiver) && !FlexibleTypesKt.isFlexible($receiver) && !TypeUtils.acceptsNullable($receiver) ? ErrorsJvm.NullabilityInformationSource.KOTLIN : (FlexibleTypesKt.isFlexible($receiver) && !TypeUtils.acceptsNullable(FlexibleTypesKt.asFlexibleType($receiver).getUpperBound()) ? ErrorsJvm.NullabilityInformationSource.KOTLIN : ($receiver instanceof TypeWithEnhancement && this.mustNotBeNull(((TypeWithEnhancement)((Object)$receiver)).getEnhancement()) != null ? ErrorsJvm.NullabilityInformationSource.JAVA : null));
    }

    private final ErrorsJvm.NullabilityInformationSource mayBeNull(@NotNull KotlinType $receiver) {
        return !KotlinTypeKt.isError($receiver) && !FlexibleTypesKt.isFlexible($receiver) && TypeUtils.acceptsNullable($receiver) ? ErrorsJvm.NullabilityInformationSource.KOTLIN : (FlexibleTypesKt.isFlexible($receiver) && TypeUtils.acceptsNullable(FlexibleTypesKt.asFlexibleType($receiver).getLowerBound()) ? ErrorsJvm.NullabilityInformationSource.KOTLIN : ($receiver instanceof TypeWithEnhancement && this.mayBeNull(((TypeWithEnhancement)((Object)$receiver)).getEnhancement()) != null ? ErrorsJvm.NullabilityInformationSource.JAVA : null));
    }

    @Nullable
    public static final /* synthetic */ Object access$doIfNotNull(JavaNullabilityChecker $this, @NotNull KotlinType type2, @NotNull Function0 dataFlowValue2, @NotNull ResolutionContext c, @NotNull Function0 body2) {
        return $this.doIfNotNull(type2, (Function0<DataFlowValue>)dataFlowValue2, c, body2);
    }
}

