/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.jsf.composite.CompositeComponentQuickFixProvider;
import com.intellij.jsf.composite.CompositeNamespaceDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import org.jetbrains.annotations.NotNull;

public class CompositeNamespaceUndefinedElementFixProvider
extends XmlUndefinedElementFixProvider {
    public IntentionAction[] createFixes(@NotNull XmlAttribute attribute) {
        XmlNSDescriptor nsDescriptor;
        if (attribute == null) {
            CompositeNamespaceUndefinedElementFixProvider.$$$reportNull$$$0(0);
        }
        XmlTag tag = attribute.getParent();
        String namespace = attribute.getNamespace();
        if (StringUtil.isEmptyOrSpaces((String)namespace)) {
            namespace = tag.getNamespace();
        }
        if ((nsDescriptor = tag.getNSDescriptor(namespace, true)) instanceof CompositeNamespaceDescriptor) {
            String resourcesPath = ((CompositeNamespaceDescriptor)nsDescriptor).getResourcesPath();
            IntentionAction fix = CompositeComponentQuickFixProvider.createCompositeComponentAttributeQuickFix(attribute, resourcesPath);
            if (fix != null) {
                return new IntentionAction[]{fix};
            }
            return IntentionAction.EMPTY_ARRAY;
        }
        return null;
    }

    public LocalQuickFix[] createFixes(@NotNull XmlTag tag) {
        XmlNSDescriptor descriptor;
        if (tag == null) {
            CompositeNamespaceUndefinedElementFixProvider.$$$reportNull$$$0(1);
        }
        if ((descriptor = tag.getNSDescriptor(tag.getNamespace(), true)) instanceof CompositeNamespaceDescriptor) {
            String resourcesPath = ((CompositeNamespaceDescriptor)descriptor).getResourcesPath();
            LocalQuickFix fix = CompositeComponentQuickFixProvider.createCompositeComponentFileQuickFix(tag, resourcesPath);
            if (fix != null) {
                return new LocalQuickFix[]{fix};
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "attribute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
        }
        objectArray[1] = "com/intellij/jsf/composite/CompositeNamespaceUndefinedElementFixProvider";
        objectArray[2] = "createFixes";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

