/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.utils;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.util.containers.hash.HashMap;
import icons.JsfIcons;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacesConfigTemplateManager
implements FileTemplateGroupDescriptorFactory {
    @NonNls
    public static final String FACELETS_TEMPLATE_NAME = "facelets.xhtml";
    @NonNls
    public static final String FACES_JSP_TEMPLATE_NAME = "faces.jsp";
    @NonNls
    public static final String JSF_XHTML_TEMPLATE_NAME = "jsf.xhtml";
    @NonNls
    public static final FacesConfigVersion DEFAULT_FACES_VERSION = FacesConfigVersion.VERSION_2_2;
    private static final Map<String, FacesConfigVersion> myVersions = new HashMap();

    public FileTemplateGroupDescriptor getFileTemplatesDescriptor() {
        FileTemplateGroupDescriptor groupDescriptor = new FileTemplateGroupDescriptor(FacesBundle.message("template.group.jsf.config.files.title", new Object[0]), AllIcons.FileTypes.FacesConfig);
        for (FacesConfigVersion version : FacesConfigVersion.values()) {
            groupDescriptor.addTemplate(new FileTemplateDescriptor(version.myTemplateName, JsfIcons.FacesFile));
        }
        groupDescriptor.addTemplate(new FileTemplateDescriptor(FACELETS_TEMPLATE_NAME, StdFileTypes.XHTML.getIcon()));
        groupDescriptor.addTemplate(new FileTemplateDescriptor(FACES_JSP_TEMPLATE_NAME, StdFileTypes.JSP.getIcon()));
        groupDescriptor.addTemplate(new FileTemplateDescriptor(JSF_XHTML_TEMPLATE_NAME, StdFileTypes.XHTML.getIcon()));
        return groupDescriptor;
    }

    @NotNull
    public static String getFacesConfigTemplateText(@Nullable String versionString) throws IOException {
        FacesConfigVersion version = FacesConfigTemplateManager.getVersion(versionString);
        FileTemplate template = FileTemplateManager.getDefaultInstance().getJ2eeTemplate(version.myTemplateName);
        String string = template.getText(FileTemplateManager.getDefaultInstance().getDefaultProperties());
        if (string == null) {
            FacesConfigTemplateManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static FacesConfigVersion getVersion(@Nullable String version) {
        if (version != null) {
            for (String templateVersion : myVersions.keySet()) {
                if (!version.startsWith(templateVersion)) continue;
                FacesConfigVersion facesConfigVersion = myVersions.get(templateVersion);
                if (facesConfigVersion == null) {
                    FacesConfigTemplateManager.$$$reportNull$$$0(1);
                }
                return facesConfigVersion;
            }
        }
        FacesConfigVersion facesConfigVersion = DEFAULT_FACES_VERSION;
        if (facesConfigVersion == null) {
            FacesConfigTemplateManager.$$$reportNull$$$0(2);
        }
        return facesConfigVersion;
    }

    static {
        myVersions.put("2.2", FacesConfigVersion.VERSION_2_2);
        myVersions.put("2_2", FacesConfigVersion.VERSION_2_2);
        myVersions.put("2.0", FacesConfigVersion.VERSION_2_0);
        myVersions.put("2_0", FacesConfigVersion.VERSION_2_0);
        myVersions.put("1.2", FacesConfigVersion.VERSION_1_2);
        myVersions.put("1_2", FacesConfigVersion.VERSION_1_2);
        myVersions.put("1.1", FacesConfigVersion.VERSION_1_1);
        myVersions.put("1_1", FacesConfigVersion.VERSION_1_1);
        myVersions.put("1.0", FacesConfigVersion.VERSION_1_0);
        myVersions.put("1_0", FacesConfigVersion.VERSION_1_0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jsf/utils/FacesConfigTemplateManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacesConfigTemplateText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum FacesConfigVersion {
        VERSION_1_0("faces-config.1_0.xml", "1.0"),
        VERSION_1_1("faces-config.1_1.xml", "1.1"),
        VERSION_1_2("faces-config.1_2.xml", "1.2"),
        VERSION_2_0("faces-config.2_0.xml", "2.0"),
        VERSION_2_2("faces-config.2_2.xml", "2.2");

        private final String myTemplateName;
        private final String myVersionName;

        private FacesConfigVersion(String templateName, String versionName) {
            this.myTemplateName = templateName;
            this.myVersionName = versionName;
        }

        public String getTemplateName() {
            return this.myTemplateName;
        }

        public String getVersionName() {
            return this.myVersionName;
        }
    }
}

