/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.CmpFieldTypeExpression;
import com.intellij.codeInsight.generation.EjbMemberChooserObjectBase;
import com.intellij.codeInsight.generation.EncapsulatableClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.codeInsight.generation.TemplateGenerationInfo;
import com.intellij.ide.IconUtilEx;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class CmpFieldClassMember
extends MemberChooserObjectBase
implements EncapsulatableClassMember {
    private final PsiClass myPsiClass;
    private final CmpField myField;

    public CmpFieldClassMember(PsiClass psiClass, CmpField field) {
        super((String)field.getFieldName().getValue(), IconUtilEx.getIcon((Object)field, (int)0, null));
        this.myPsiClass = psiClass;
        this.myField = field;
    }

    public MemberChooserObject getParentNodeDelegate() {
        return new EjbMemberChooserObjectBase((EnterpriseBean)this.myField.getEntityBean());
    }

    @Nullable
    public TemplateGenerationInfo generateGetter() throws IncorrectOperationException {
        PsiClassType objectType = this.getJavaLangObject();
        String methodName = PropertyUtilBase.suggestGetterName((String)((String)this.myField.getFieldName().getValue()), (PsiType)objectType);
        for (PsiMethod method : this.myPsiClass.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterList().getParameters().length != 0) continue;
            return null;
        }
        PsiMethod method = this.createAbstractMethod(methodName, (PsiType)objectType);
        return new TemplateGenerationInfo(method, CmpFieldClassMember.createExpression(method)){

            protected PsiTypeElement getTemplateElement(PsiMethod method) {
                return method.getReturnTypeElement();
            }
        };
    }

    private static CmpFieldTypeExpression createExpression(PsiMethod method) {
        return new CmpFieldTypeExpression(method.getManager());
    }

    private PsiMethod createAbstractMethod(String methodName, PsiType returnType) throws IncorrectOperationException {
        PsiMethod method = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory().createMethod(methodName, returnType);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
        method.getBody().delete();
        return method;
    }

    @Nullable
    public TemplateGenerationInfo generateSetter() throws IncorrectOperationException {
        PsiMethod[] methods;
        String name = (String)this.myField.getFieldName().getValue();
        String methodName = PropertyUtilBase.suggestSetterName((String)name);
        for (PsiMethod method : methods = this.myPsiClass.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterList().getParameters().length != 1 || !PsiType.VOID.equals((Object)method.getReturnType())) continue;
            return null;
        }
        PsiMethod method = this.createAbstractMethod(methodName, (PsiType)PsiType.VOID);
        PsiParameterList parameterList = method.getParameterList();
        String paramName = JavaCodeStyleManager.getInstance((Project)this.myPsiClass.getProject()).propertyNameToVariableName(name, VariableKind.PARAMETER);
        parameterList.add((PsiElement)JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory().createParameter(paramName, (PsiType)this.getJavaLangObject()));
        return new TemplateGenerationInfo(method, CmpFieldClassMember.createExpression(method)){

            protected PsiTypeElement getTemplateElement(PsiMethod method) {
                return method.getParameterList().getParameters()[0].getTypeElement();
            }
        };
    }

    private PsiClassType getJavaLangObject() {
        return PsiType.getJavaLangObject((PsiManager)this.myPsiClass.getManager(), (GlobalSearchScope)this.myPsiClass.getResolveScope());
    }
}

