/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.GenerateEJBReferenceHandler;
import com.intellij.codeInsight.generation.actions.BaseGenerateAction;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EnterpriseBeanSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.JavaeeIcons;
import org.jetbrains.annotations.NotNull;

public class GenerateEJBReference
extends BaseGenerateAction {
    public GenerateEJBReference() {
        super((CodeInsightActionHandler)new GenerateEJBReferenceHandler());
        this.getTemplatePresentation().setIcon(JavaeeIcons.EJB_MODULE_SMALL);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            GenerateEJBReference.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GenerateEJBReference.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GenerateEJBReference.$$$reportNull$$$0(2);
        }
        if (!super.isValidForFile(project, editor, file)) {
            return false;
        }
        PsiClass psiClass = this.getTargetClass(editor, file);
        if (psiClass == null || psiClass.isInterface() || psiClass.isEnum()) {
            return false;
        }
        EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)psiClass);
        if (ejbFacet == null || EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)EjbUtil.getVersion(ejbFacet)) > 0) {
            return false;
        }
        EnterpriseBeanSet enterpriseBeans = ejbFacet.getMergedRoot().getEnterpriseBeans();
        if (enterpriseBeans.getSessions().size() == 0 && enterpriseBeans.getEntities().size() == 0) {
            return false;
        }
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(psiClass)) {
            EjbClassRoleEnum type = role.getType();
            if (type != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS && type != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/generation/actions/GenerateEJBReference";
        objectArray[2] = "isValidForFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

