/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.transactions;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.treetable.JamSpacerColumnInfo;
import com.intellij.jam.view.treetable.JamTreeTableView;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.UserResponse;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.enums.TransAttribute;
import com.intellij.javaee.model.xml.ejb.AssemblyDescriptor;
import com.intellij.javaee.model.xml.ejb.ContainerTransaction;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.Method;
import com.intellij.javaee.model.xml.ejb.MethodContainer;
import com.intellij.javaee.module.view.ejb.nodes.EjbFacetNodeDescriptor;
import com.intellij.javaee.module.view.ejb.permissions.EjbMethodPermissionsView;
import com.intellij.javaee.module.view.ejb.permissions.MethodContainerHelper;
import com.intellij.javaee.module.view.ejb.transactions.EjbTransactionModuleNodeDescriptor;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.ComboBoxTableCellRenderer;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ArrayConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.xml.ui.ComboTableCellEditor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public class EjbTransactionAttributesView
extends JamTreeTableView {
    private final EjbFacet myEjbFacet;
    private final EjbJar myEjbJar;
    private final List<Runnable> myChanges = new ArrayList<Runnable>();

    public EjbTransactionAttributesView(EjbFacet facet, EjbJar ejbJar) {
        super(facet.getModule().getProject(), new EjbTransactionModuleNodeDescriptor(facet, (Object)new J2EEModuleParameters(false)));
        this.myEjbFacet = facet;
        this.myEjbJar = ejbJar;
        this.getComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.getComponent().setFocusable(true);
        this.getTreeTableView().setShowVerticalLines(true);
        this.getTreeTableView().setIntercellSpacing((Dimension)JBUI.size((int)1, (int)0));
        this.init();
        new TreeTableSpeedSearch((TreeTable)this.getTreeTableView());
    }

    @Override
    protected boolean isShowTree() {
        return !EjbCommonModelUtil.getAllEjbs((Project)this.getProject(), null, (EjbFacet)this.myEjbFacet).isEmpty();
    }

    @Override
    @NotNull
    protected String getEmptyPaneText() {
        String string = J2EEBundle.message((String)"message.text.no.ejbs.in.this.module.no.transaction.attributes", (Object[])new Object[0]);
        if (string == null) {
            EjbTransactionAttributesView.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected ColumnInfo[] createColumnInfos() {
        return new ColumnInfo[]{new TreeColumnInfo(J2EEBundle.message((String)"column.transaction.attributes.name", (Object[])new Object[0])), new ColumnInfo<JavaeeNodeDescriptor, String>(J2EEBundle.message((String)"column.transaction.attributes.transaction.attribute", (Object[])new Object[0])){

            public boolean isCellEditable(JavaeeNodeDescriptor o) {
                EjbClassRole role;
                Object element = o.getElement();
                if (element instanceof EjbBase) {
                    return true;
                }
                if (element instanceof PsiClass && (role = EjbHelper.getEjbHelper().getEjbRole((PsiClass)element)) != null && role.isDeclarationRole()) {
                    return true;
                }
                return element instanceof PsiMethod;
            }

            public TableCellRenderer getRenderer(JavaeeNodeDescriptor javaeeNodeDescriptor) {
                return ComboBoxTableCellRenderer.COMBO_WHEN_SELECTED_RENDERER;
            }

            public TableCellEditor getEditor(JavaeeNodeDescriptor item) {
                ComboTableCellEditor editor = new ComboTableCellEditor(TransAttribute.class, true);
                editor.setClickCountToStart(1);
                return editor;
            }

            public void setValue(JavaeeNodeDescriptor o, String aValue) {
                EjbTransactionAttributesView.setTransactionAttribute(o, aValue);
            }

            public String valueOf(JavaeeNodeDescriptor object) {
                return EjbTransactionAttributesView.getTransactionAttribute(object);
            }
        }, new JamSpacerColumnInfo()};
    }

    @Override
    protected void setColumnsPreferredWidth() {
        ColumnInfo[] columnInfos = this.getColumnInfos();
        TableColumnModel columnModel = this.getTreeTableView().getColumnModel();
        TableColumn treeColumn = null;
        int maxPreferredWidth = 0;
        for (int i = 0; i < columnInfos.length; ++i) {
            ColumnInfo columnInfo = columnInfos[i];
            TableColumn column = columnModel.getColumn(i);
            if (TreeTableModel.class.isAssignableFrom(columnInfo.getColumnClass())) {
                treeColumn = column;
            }
            maxPreferredWidth = Math.max(maxPreferredWidth, column.getPreferredWidth());
        }
        if (treeColumn != null && treeColumn.getPreferredWidth() < 4 * maxPreferredWidth) {
            treeColumn.setPreferredWidth(4 * maxPreferredWidth);
        }
    }

    @Override
    protected void cacheNode(JamNodeDescriptor node) {
    }

    @Override
    protected void setValueAt(ColumnInfo columnInfo, JamNodeDescriptor descriptor, Object aValue) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> this.myChanges.add(() -> columnInfo.setValue((Object)descriptor, aValue)), null, null);
    }

    @Override
    public void commit() {
        super.commit();
        this.doCommit();
    }

    @Override
    public void reset() {
        if (this.myChanges.isEmpty()) {
            super.reset();
        }
    }

    private void doCommit() {
        Runnable[] runnables = this.myChanges.toArray(new Runnable[0]);
        this.myChanges.clear();
        for (Runnable runnable : runnables) {
            runnable.run();
        }
    }

    @Override
    protected void cacheValues() {
        super.cacheValues();
        List list = this.myEjbJar.getAssemblyDescriptor().getContainerTransactions();
        for (ContainerTransaction transaction : list) {
            final String value = transaction.getTransAttribute().getStringValue();
            MethodContainerHelper.processMethods(this.myEjbFacet, (MethodContainer)transaction, new ArrayConsumer<Object>(){

                public void consume(Object[] url) {
                    EjbTransactionAttributesView.this.setCachedValue(value, 1, url);
                }
            });
        }
    }

    @Override
    protected List<Object> getEmptyColumnValues() {
        return Collections.nCopies(this.getColumnInfos().length, "");
    }

    @Override
    public Object getData(String dataId) {
        if (DataConstants.HELP_ID.equals(dataId)) {
            return "newEJBedit_module_attr";
        }
        return super.getData(dataId);
    }

    public static String getTransactionAttribute(JavaeeNodeDescriptor descriptor) {
        EjbFacet ejbFacet = (EjbFacet)ObjectUtils.assertNotNull((Object)EjbFacetNodeDescriptor.getEjbFacetForElement((NodeDescriptor)descriptor));
        EjbJar xmlRoot = ejbFacet.getXmlRoot();
        if (xmlRoot == null) {
            return "";
        }
        AssemblyDescriptor assemblyDescriptor = xmlRoot.getAssemblyDescriptor();
        List<Method> attributes = EjbMethodPermissionsView.getObjectAttributes(new MethodContainerHelper.ContainerTransactionHelper(assemblyDescriptor), descriptor);
        return attributes.isEmpty() ? "" : ((ContainerTransaction)attributes.get(0).getParent()).getTransAttribute().getStringValue();
    }

    public static void setTransactionAttribute(JavaeeNodeDescriptor descriptor, String attribute) {
        EjbFacet ejbFacet = (EjbFacet)ObjectUtils.assertNotNull((Object)EjbFacetNodeDescriptor.getEjbFacetForElement((NodeDescriptor)descriptor));
        EjbJar xmlRoot = ejbFacet.getXmlRoot();
        if (xmlRoot == null) {
            return;
        }
        EjbMethodPermissionsView.setObjectAttribute(new MethodContainerHelper.ContainerTransactionHelper(xmlRoot.getAssemblyDescriptor()), (JamNodeDescriptor)descriptor, attribute, true, UserResponse.QUIET);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/transactions/EjbTransactionAttributesView", "getEmptyPaneText"));
    }
}

