/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.editor;

import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.GuiUtils;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CompositeCommittable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NonNls;

public abstract class JavaeeBaseEditor
extends CompositeCommittable
implements CommittablePanel {
    @NonNls
    private static final String ROOT = "root";

    protected final void markAsRoot(JComponent component) {
        component.putClientProperty(ROOT, ROOT);
    }

    protected final void enableChildren(JComponent container, boolean enabled) {
        HashSet excluded = new HashSet();
        GuiUtils.iterateChildren((Component)container, component -> {
            if (component instanceof JComponent && ((JComponent)component).getClientProperty(ROOT) != null) {
                excluded.add((JComponent)component);
            }
        }, (JComponent[])new JComponent[0]);
        excluded.remove(container);
        GuiUtils.enableChildren((Component)container, (boolean)enabled, (JComponent[])excluded.toArray(new JComponent[0]));
    }

    protected final void addContent(JPanel panel, Component content) {
        panel.setLayout(new BorderLayout());
        panel.add(content, "Center");
    }

    protected final void addContent(JPanel panel, CommittablePanel content) {
        panel.setLayout(new BorderLayout());
        panel.add((Component)content.getComponent(), "Center");
        this.addComponent((Committable)content);
    }

    protected final void addContent(JTabbedPane pane, CommittablePanel content, String title) {
        pane.add(title, content.getComponent());
        this.addComponent((Committable)content);
    }

    protected final void addContent(JTabbedPane pane, Component content, String title) {
        pane.add(title, content);
    }

    protected final Splitter createSplitter(CommittablePanel first, CommittablePanel second, boolean vertical) {
        Splitter splitter = this.createSplitter(vertical);
        this.setFirstPanel(splitter, first);
        this.setSecondPanel(splitter, second);
        return splitter;
    }

    protected final Splitter createSplitter(CommittablePanel first, JComponent second, boolean vertical) {
        Splitter splitter = this.createSplitter(vertical);
        this.setFirstPanel(splitter, first);
        splitter.setSecondComponent(second);
        return splitter;
    }

    protected final Splitter createSplitter(JComponent first, CommittablePanel second, boolean vertical) {
        Splitter splitter = this.createSplitter(vertical);
        splitter.setFirstComponent(first);
        this.setSecondPanel(splitter, second);
        return splitter;
    }

    protected final Splitter createSplitter(JComponent first, JComponent second, boolean vertical) {
        Splitter splitter = this.createSplitter(vertical);
        splitter.setFirstComponent(first);
        splitter.setSecondComponent(second);
        return splitter;
    }

    private Splitter createSplitter(boolean vertical) {
        Splitter splitter = new Splitter(vertical);
        splitter.setShowDividerControls(true);
        return splitter;
    }

    private void setFirstPanel(Splitter splitter, CommittablePanel panel) {
        splitter.setFirstComponent(panel.getComponent());
        this.addComponent((Committable)panel);
    }

    private void setSecondPanel(Splitter splitter, CommittablePanel panel) {
        splitter.setSecondComponent(panel.getComponent());
        this.addComponent((Committable)panel);
    }
}

