/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.configuration.view;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaeeRunConfigurationEditorContext {
    private final List<JavaeeDeploymentSettingsEditorListener> myDeploymentSettingsListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final SettingsEditorGroup<CommonStrategy> myCompositeEditor;
    private final ConfigurationFactory myConfigurationFactory;
    private final Project myProject;

    public JavaeeRunConfigurationEditorContext(SettingsEditorGroup<CommonStrategy> compositeEditor, ConfigurationFactory configurationFactory, Project project) {
        this.myCompositeEditor = compositeEditor;
        this.myConfigurationFactory = configurationFactory;
        this.myProject = project;
    }

    public void addDeploymentSettingsListener(@NotNull JavaeeDeploymentSettingsEditorListener listener) {
        if (listener == null) {
            JavaeeRunConfigurationEditorContext.$$$reportNull$$$0(0);
        }
        this.myDeploymentSettingsListeners.add(listener);
    }

    public CommonStrategy getSnapshot() throws ConfigurationException {
        RunConfiguration configuration = this.myConfigurationFactory.createTemplateConfiguration(this.myProject);
        CommonStrategy commonModel = (CommonStrategy)configuration;
        for (Pair editorPair : this.myCompositeEditor.getEditors()) {
            ((SettingsEditor)editorPair.getSecond()).applyTo((Object)commonModel);
        }
        return commonModel;
    }

    public void fireDeploymentSettingsChanged() {
        try {
            CommonStrategy commonModel = this.getSnapshot();
            for (JavaeeDeploymentSettingsEditorListener listener : this.myDeploymentSettingsListeners) {
                listener.onDeploymentSettingsChanged(commonModel);
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/javaee/run/configuration/view/JavaeeRunConfigurationEditorContext", "addDeploymentSettingsListener"));
    }

    public static interface JavaeeDeploymentSettingsEditorListener {
        public void onDeploymentSettingsChanged(CommonModel var1);
    }
}

