/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution.update;

import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.update.RunningApplicationUpdater;
import com.intellij.execution.update.RunningApplicationUpdaterProvider;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JavaeeApplicationUpdaterProvider
implements RunningApplicationUpdaterProvider {
    public RunningApplicationUpdater createUpdater(@NotNull Project project, @NotNull ProcessHandler process) {
        CommonStrategy commonStrategy;
        J2EEProcess javaeeProcess;
        Executor executor;
        Collection<? extends UpdatingPolicy> policies;
        if (project == null) {
            JavaeeApplicationUpdaterProvider.$$$reportNull$$$0(0);
        }
        if (process == null) {
            JavaeeApplicationUpdaterProvider.$$$reportNull$$$0(1);
        }
        if (process instanceof J2EEProcess && !(policies = UpdatingRunningApplicationUtil.getAvailablePolicies(executor = UpdatingRunningApplicationUtil.getExecutor(javaeeProcess = (J2EEProcess)process), commonStrategy = javaeeProcess.getCommonStrategy(), false)).isEmpty()) {
            return new JavaeeApplicationUpdater(project, javaeeProcess, commonStrategy);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "process";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/run/execution/update/JavaeeApplicationUpdaterProvider";
        objectArray[2] = "createUpdater";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JavaeeApplicationUpdater
    implements RunningApplicationUpdater {
        private final Project myProject;
        private final J2EEProcess myProcess;
        private final CommonStrategy myCommonStrategy;

        public JavaeeApplicationUpdater(Project project, J2EEProcess process, CommonStrategy commonStrategy) {
            this.myProject = project;
            this.myProcess = process;
            this.myCommonStrategy = commonStrategy;
        }

        public String getDescription() {
            return "Update '" + this.myCommonStrategy.getName() + "' application";
        }

        public String getShortName() {
            return this.myCommonStrategy.getName();
        }

        public Icon getIcon() {
            return this.myCommonStrategy.getIntegration().getIcon();
        }

        public void performUpdate() {
            UpdatingPolicy policy = this.myCommonStrategy.selectUpdatingPolicy(UpdatingRunningApplicationUtil.getExecutor(this.myProcess));
            if (policy != null) {
                policy.runUpdate(this.myProject, null, this.myProcess.getServerInstance(), (ProcessHandler)this.myProcess, false);
            }
        }
    }
}

