/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.web.WebContextManager;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.jsp.WebDirectoryElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="WebContextManager", storages={@Storage(value="webContexts.xml")})
public class WebContextManagerImpl
extends WebContextManager
implements PersistentStateComponent<State> {
    private final VirtualFileManager myVirtualFileManager = VirtualFileManager.getInstance();
    private Map<String, String> myFileToContextFolder = new HashMap<String, String>();

    @Nullable
    public PsiFileSystemItem getContextFolder(@NotNull PsiFile file) {
        WebDirectoryElement webDir;
        WebFacet webFacet;
        VirtualFile folder;
        String folderUrl;
        VirtualFile virtualFile;
        if (file == null) {
            WebContextManagerImpl.$$$reportNull$$$0(0);
        }
        if ((virtualFile = WebContextManagerImpl.getVirtualFile(file)) != null && (folderUrl = this.getContextFolder(virtualFile)) != null && (folder = this.myVirtualFileManager.findFileByUrl(folderUrl)) != null && (webFacet = WebUtil.getWebFacet((VirtualFile)folder, (Project)file.getProject())) != null && (webDir = WebUtil.getWebUtil().findWebDirectoryByFile(folder, webFacet)) != null && webDir.isDirectory()) {
            return webDir;
        }
        return null;
    }

    @Nullable
    private String getContextFolder(VirtualFile file) {
        for (VirtualFile cur = file; cur != null; cur = cur.getParent()) {
            String s = this.myFileToContextFolder.get(cur.getUrl());
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public void setContextFolder(@NotNull PsiFileSystemItem target, @NotNull PsiFileSystemItem contextFolder) {
        if (target == null) {
            WebContextManagerImpl.$$$reportNull$$$0(1);
        }
        if (contextFolder == null) {
            WebContextManagerImpl.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile = target.getVirtualFile();
        VirtualFile folderFile = contextFolder.getVirtualFile();
        if (virtualFile != null && folderFile != null) {
            this.myFileToContextFolder.put(virtualFile.getUrl(), folderFile.getUrl());
            ((PsiModificationTrackerImpl)target.getManager().getModificationTracker()).incCounter();
        }
    }

    @Nullable
    private static VirtualFile getVirtualFile(PsiFile file) {
        return file.getOriginalFile().getVirtualFile();
    }

    public Map<VirtualFile, String> getMappings() {
        HashMap<VirtualFile, String> result = new HashMap<VirtualFile, String>();
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (Map.Entry<String, String> entry : this.myFileToContextFolder.entrySet()) {
            VirtualFile file = manager.findFileByUrl(entry.getKey());
            if (file == null) continue;
            result.put(file, entry.getValue());
        }
        return result;
    }

    public void setMappings(Map<VirtualFile, String> mappings) {
        this.myFileToContextFolder.clear();
        for (Map.Entry<VirtualFile, String> entry : mappings.entrySet()) {
            String url = entry.getKey().getUrl();
            this.myFileToContextFolder.put(url, entry.getValue());
        }
    }

    public State getState() {
        State state = new State();
        state.setState(this.myFileToContextFolder);
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            WebContextManagerImpl.$$$reportNull$$$0(3);
        }
        this.myFileToContextFolder = state.getState();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/web/WebContextManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextFolder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setContextFolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class State {
        private Map<String, String> myState = new HashMap<String, String>();

        public Map<String, String> getState() {
            return this.myState;
        }

        public void setState(Map<String, String> state) {
            this.myState = state;
        }
    }
}

