/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.validation;

import com.intellij.compiler.impl.ExitException;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.impl.GenericCompilerRunner;
import com.intellij.javaee.web.validation.JasperArtifactValidator;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;

public class JasperValidationTask
implements CompileTask {
    private final Project myProject;

    public JasperValidationTask(Project project) {
        this.myProject = project;
    }

    public boolean execute(CompileContext context) {
        JasperArtifactValidator compiler = JasperArtifactValidator.getInstance(this.myProject);
        GenericCompiler[] compilers = new GenericCompiler[]{compiler};
        GenericCompilerRunner runner = new GenericCompilerRunner(context, context.isRebuild(), false, compilers);
        try {
            runner.invokeCompilers(GenericCompiler.CompileOrderPlace.VALIDATING);
            return true;
        }
        catch (ExitException e) {
            ExitStatus status;
            block5: {
                status = e.getExitStatus();
                if (status == ExitStatus.ERRORS && context.isRebuildRequested()) {
                    File cacheDir = GenericCompilerRunner.getGenericCompilerCacheDir((Project)this.myProject, (GenericCompiler)compiler);
                    FileUtil.delete((File)cacheDir);
                    try {
                        runner.invokeCompilers(GenericCompiler.CompileOrderPlace.VALIDATING);
                        return true;
                    }
                    catch (ExitException e1) {
                        status = e1.getExitStatus();
                        if (status != ExitStatus.ERRORS || context.getRebuildReason() == null) break block5;
                        context.addMessage(CompilerMessageCategory.ERROR, context.getRebuildReason(), null, -1, -1);
                    }
                }
            }
            return status != ExitStatus.CANCELLED && status != ExitStatus.ERRORS;
        }
    }
}

