/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.facet.Facet;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.engine.JpaEngine;
import com.intellij.jpa.engine.JpaEngineBase;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.providers.EclipseLinkProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.File;
import java.util.ArrayList;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaConsoleRunContext
implements ConsoleRunConfiguration.RunContext {
    public static final String MAIN_CLASS = "com.intellij.jpa.console.RemoteJpaServer";
    private final PersistencePackagePointer myUnitFile;

    JpaConsoleRunContext(PersistencePackagePointer unitFile) {
        this.myUnitFile = unitFile;
    }

    public static PersistencePackagePointer[] getPossiblePersistenceUnits(Project project) {
        ArrayList model = ContainerUtil.newArrayList();
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets((Project)project)) {
            if (!(facet instanceof JpaFacet) || !JpaEngine.isAvailable(facet.getModule())) continue;
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                model.add(PersistencePackageAsVirtualFileImpl.findFile(unit, facet));
            }
        }
        return model.toArray(new PersistencePackagePointer[0]);
    }

    public static boolean shouldAddGroovy(@Nullable Module module) {
        if (module == null) {
            return true;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("groovy.lang.GroovyShell", GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false)) == null;
    }

    public static void addDataSourceJarsToClassPath(@NotNull PathsList cp, @NotNull PersistencePackage unit, @NotNull PersistenceFacet facet) {
        DatabaseSystem delegate;
        String dataSourceId;
        if (cp == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(0);
        }
        if (unit == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(2);
        }
        if ((dataSourceId = facet.getDataSourceId(unit)) == null) {
            return;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)facet.getModule().getProject()).findDataSource(dataSourceId);
        DatabaseSystem databaseSystem = delegate = dataSource == null ? null : dataSource.getDelegate();
        if (delegate instanceof LocalDataSource) {
            for (SimpleClasspathElement pathElement : ((LocalDataSource)delegate).getClasspathElements()) {
                for (String url : pathElement.getClassesRootUrls()) {
                    cp.add(PathUtil.toPresentableUrl((String)url));
                }
            }
        }
    }

    public static void addModuleClassPath(@NotNull PathsList cp, @Nullable Module module) {
        if (cp == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(3);
        }
        if (module == null) {
            return;
        }
        OrderEnumerator.orderEntries((Module)module).withoutSdk().recursively().classes().collectPaths(cp);
    }

    @Nullable
    public static Sdk getSdk(@NotNull PersistencePackagePointer unitFile) {
        String version;
        Facet facet;
        Module module;
        if (unitFile == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(4);
        }
        Module module2 = module = (facet = unitFile.getFacetPointer().getFacet()) == null ? null : facet.getModule();
        if (module == null || module.isDisposed()) {
            return null;
        }
        Project project = module.getProject();
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
        VirtualFile homeDirectory = moduleSdk == null ? null : moduleSdk.getHomeDirectory();
        Sdk contextSdk = homeDirectory == null || !homeDirectory.isValid() ? projectJdk : moduleSdk;
        String string = version = contextSdk == null ? null : JdkUtil.getJdkMainAttribute((Sdk)contextSdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (version != null && StringUtil.compareVersionNumbers((String)version, (String)"1.6") >= 0) {
            return contextSdk;
        }
        return null;
    }

    @Nullable
    public Sdk getSdk() {
        return JpaConsoleRunContext.getSdk(this.myUnitFile);
    }

    public String getMainClassName() {
        return MAIN_CLASS;
    }

    public void collectClassPath(PathsList cp) throws ExecutionException {
        PersistencePackage unit = this.myUnitFile.findElement();
        if (unit == null) {
            throw new ExecutionException(JpaMessages.message((String)"jpa.console.unit.not.found", (Object[])new Object[0]));
        }
        PersistenceFacet facet = this.myUnitFile.getPersistenceFacet();
        if (facet == null || facet.getModule().isDisposed()) {
            throw new ExecutionException(JpaMessages.message((String)"jpa.console.facet.not.found", (Object[])new Object[0]));
        }
        Module module = facet.getModule();
        JdbcConsoleRunContext.addUtilJars((PathsList)cp, (boolean)JpaConsoleRunContext.shouldAddGroovy(module));
        JdbcConsoleRunContext.addJdbcConsoleJars((PathsList)cp);
        JdbcConsoleRunContext.addClassJar((PathsList)cp, JpaEngine.class, (String)MAIN_CLASS);
        JpaConsoleRunContext.addDataSourceJarsToClassPath(cp, unit, facet);
        JpaConsoleRunContext.addModuleClassPath(cp, module);
    }

    public void tuneParams(@NotNull SimpleJavaParameters params) {
        File tempPURoot;
        if (params == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(5);
        }
        File genPath = JpaEngineBase.getTempDirectory(this.myUnitFile.getFacetPointer().getProject());
        PersistencePackage unit = this.myUnitFile.findElement();
        JpaImplementationProvider provider = JpaUtil.findJpaProvider(this.myUnitFile.getPersistenceFacet(), unit, true);
        String path = this.myUnitFile.getFacetPointer().getModuleName().replace(' ', '_') + "-PU-" + System.currentTimeMillis();
        if (provider instanceof EclipseLinkProvider) {
            tempPURoot = new File(genPath, path + File.separator + "gen");
            params.getVMParametersList().add("-Declipselink.persistencexml=" + tempPURoot.getName() + "/META-INF/persistence.xml");
            params.getClassPath().addFirst(tempPURoot.getParentFile().getAbsolutePath());
        } else {
            tempPURoot = new File(genPath, path);
            params.getClassPath().addFirst(tempPURoot.getAbsolutePath());
        }
        tempPURoot.mkdirs();
        params.getVMParametersList().add("-Dcom.jetbrains.jpa.root=" + tempPURoot.getAbsolutePath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleRunContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addDataSourceJarsToClassPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addModuleClassPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSdk";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tuneParams";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

