/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DataBus;
import com.intellij.database.console.AbstractEngine;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.RawStatementContext;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.remote.RemoteQuery;
import com.intellij.jpa.remote.RemoteQueryResult;
import com.intellij.jpa.remote.impl.QueryResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JpaEngineBase
extends AbstractEngine
implements DataProducer {
    protected final PersistencePackagePointer myUnitFile;
    protected final ConsoleRunConfiguration myConfiguration;

    protected static boolean isClassAvailable(Module module, String requiredClassName) {
        Project project = module.getProject();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(requiredClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        PsiFile containingFile = psiClass == null ? null : psiClass.getContainingFile();
        VirtualFile vFile = containingFile == null ? null : containingFile.getVirtualFile();
        return vFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(vFile);
    }

    public JpaEngineBase(DataBus.Producing messageBus, PersistencePackagePointer unitFile, ConsoleRunConfiguration configuration) {
        super(configuration.getProject(), messageBus);
        this.myUnitFile = unitFile;
        this.myConfiguration = configuration;
    }

    public PersistencePackagePointer getUnitFile() {
        return this.myUnitFile;
    }

    public void terminate() {
        super.terminate();
        this.releaseConnection();
    }

    protected abstract void releaseConnection();

    protected void setRunConfigurationOptionsForDataSource(@Nullable LocalDataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        if (StringUtil.isNotEmpty((String)this.myConfiguration.VM_PARAMETERS)) {
            return;
        }
        if (this.myConfiguration.VM_ENV != null && !this.myConfiguration.VM_ENV.isEmpty()) {
            return;
        }
        this.myConfiguration.setOptionsFromDataSource(dataSource);
    }

    public void visitQuery(DataRequest.QueryRequest r) {
        this.queryData(r);
    }

    public void visitRequest(DataRequest r) {
        if (r instanceof JpaConsoleBase.GenerateSql) {
            JpaConsoleBase.GenerateSql gen = (JpaConsoleBase.GenerateSql)r;
            switch (gen.command) {
                case QUERY: {
                    this.getGeneratedSql(gen);
                    break;
                }
                case DDL: {
                    this.getGeneratedDdl(gen);
                }
            }
        }
    }

    public void queryData(@NotNull DataRequest.QueryRequest request) {
        if (request == null) {
            JpaEngineBase.$$$reportNull$$$0(0);
        }
        this.submitRequest((DataRequest)request, () -> {
            if (request == null) {
                JpaEngineBase.$$$reportNull$$$0(12);
            }
            if (request instanceof JpaConsoleBase.LoadRequest) {
                JpaConsoleBase.LoadRequest r = (JpaConsoleBase.LoadRequest)request;
                return this.executeQueryInner(request, (Map)r.params, r.expectedColumns);
            }
            return this.executeQueryInner(request, Collections.emptyMap(), Collections.emptyList());
        });
    }

    public void getGeneratedSql(JpaConsoleBase.GenerateSql request) {
        this.submitRequest(request, () -> {
            this.getDataAuditor().print(this.getRequestContext(), this.getGenerateSqlInner(request.query));
            return true;
        });
    }

    @Nullable
    protected abstract String getGenerateSqlInner(String var1) throws Exception;

    public void getGeneratedDdl(JpaConsoleBase.GenerateSql request) {
        this.submitRequest(request, () -> {
            this.getDataAuditor().print(this.getRequestContext(), this.getGeneratedDdlInner());
            return true;
        });
    }

    @Nullable
    protected abstract String getGeneratedDdlInner() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeQueryInner(DataRequest.QueryRequest request, Map<Object, String> parameters, List<String> expectedColumns) {
        try {
            this.getRequestContext().statementContext.set(new RawStatementContext(request.query));
            this.getDataAuditor().beforeStatement(this.getRequestContext());
            RemoteQuery remoteQuery = this.createQuery(request.query);
            try {
                for (Object o : parameters.keySet()) {
                    if (o instanceof Number) {
                        remoteQuery.setParameter(((Number)o).intValue(), (Object)parameters.get(o));
                        continue;
                    }
                    remoteQuery.setParameter((String)o, (Object)parameters.get(o));
                }
                remoteQuery.execute();
                RemoteQueryResult result = remoteQuery.getQueryResult();
                if (result != null) {
                    int rowCount = 0;
                    try {
                        this.getDataAuditor().fetchStarted(this.getRequestContext(), 1);
                        rowCount = this.printResult(request, result, expectedColumns);
                    }
                    finally {
                        this.getDataAuditor().fetchFinished(this.getRequestContext(), 1, rowCount);
                    }
                } else {
                    this.getDataAuditor().updateCountReceived(this.getRequestContext(), remoteQuery.getUpdateCount());
                }
                boolean bl = true;
                this.closeQuery(remoteQuery);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.closeQuery(remoteQuery);
                    throw throwable;
                }
                catch (Exception e) {
                    this.getRequestContext().reportException((Throwable)e, (Object)request.query);
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.getDataAuditor().afterStatement(this.getRequestContext());
            this.getRequestContext().statementContext.set(null);
        }
    }

    protected abstract RemoteQuery createQuery(String var1) throws Exception;

    private void closeQuery(RemoteQuery remoteQuery) {
        if (remoteQuery != null) {
            try {
                remoteQuery.close();
            }
            catch (Exception e) {
                this.getRequestContext().reportException((Throwable)e, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int printResult(DataRequest.QueryRequest request, RemoteQueryResult result, List<String> expectedColumns) throws RemoteException {
        DataRequest.Constraints constraints = request.constraints;
        QueryResult.Column[] columnInfos = result.getColumnInfos(constraints.offset, constraints.limit, ArrayUtil.toStringArray(expectedColumns));
        DataConsumer.Column[] columnsDescr = new DataConsumer.Column[columnInfos.length];
        for (int i = 0; i < columnsDescr.length; ++i) {
            columnsDescr[i] = new DataConsumer.Column(i, columnInfos[i].name, 1111, columnInfos[i].type, columnInfos[i].clazz);
        }
        int total = result.getSize();
        int start = Math.max(1, constraints.offset + (constraints.offset < 0 ? total + 1 : 0));
        int pageSize = constraints.limit;
        ArrayList values = ContainerUtil.newArrayList();
        int rowCount = 0;
        int rowNum = start - 1;
        DataConsumer consumer = this.getDataConsumer();
        if (request instanceof DataConsumer) {
            consumer = new DataConsumer.Composite(new DataConsumer[]{consumer, (DataConsumer)request});
        }
        consumer.setColumns(this.getRequestContext(), 1, columnsDescr, start);
        int chunkSize = pageSize > 0 ? Math.max(pageSize / 10, 1) : 100;
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(chunkSize);
        try {
            while ((pageSize <= 0 || rowCount < pageSize) && result.next()) {
                if (++rowNum < start) continue;
                ++rowCount;
                for (int i = 1; i <= columnsDescr.length; ++i) {
                    values.add(result.getObject(i));
                }
                DataConsumer.Row row = DataConsumer.Row.create((int)(rowNum - 1), (Object[])ArrayUtil.toObjectArray((Collection)values));
                rows.add(row);
                if (rows.size() == chunkSize) {
                    consumer.addRows(this.getRequestContext(), rows);
                    rows = new ArrayList(chunkSize);
                }
                values.clear();
            }
            if (!rows.isEmpty()) {
                consumer.addRows(this.getRequestContext(), rows);
            }
        }
        finally {
            consumer.afterLastRowAdded(this.getRequestContext(), total);
        }
        return rowCount;
    }

    protected void handleException(@NotNull DataRequest.Context context, @NotNull Throwable e) {
        if (context == null) {
            JpaEngineBase.$$$reportNull$$$0(1);
        }
        if (e == null) {
            JpaEngineBase.$$$reportNull$$$0(2);
        }
        LinkedHashSet messages = ContainerUtil.newLinkedHashSet();
        Throwable t = e;
        while (t.getCause() != null) {
            ContainerUtil.addIfNotNull((Collection)messages, (Object)StringUtil.nullize((String)t.getLocalizedMessage()));
            t = t.getCause();
        }
        if (t instanceof SQLException) {
            String state = ((SQLException)t).getSQLState();
            this.getDataAuditor().error(context, (state != null ? "[" + state + "] " : "") + t.getLocalizedMessage(), null);
        } else if (t instanceof EOFException && e instanceof RemoteException) {
            this.getDataAuditor().error(context, "Process exited", null);
        } else if (t instanceof IOException || t instanceof UnsupportedOperationException) {
            this.getDataAuditor().error(context, t.getClass().getSimpleName() + ": " + t.getLocalizedMessage(), null);
        } else if (t instanceof ExecutionException) {
            this.getDataAuditor().error(context, t.getLocalizedMessage(), null);
        } else {
            ContainerUtil.addIfNotNull((Collection)messages, (Object)StringUtil.nullize((String)t.getLocalizedMessage()));
            for (String s : messages) {
                if (s.contains("QuerySyntaxException:")) {
                    s = s.substring(s.indexOf("QuerySyntaxException:") + "QuerySyntaxException:".length()).trim();
                    this.getDataAuditor().error(context, s, null);
                    return;
                }
                if (!s.contains("Syntax error")) continue;
                s = s.substring(s.indexOf("Syntax error")).trim();
                this.getDataAuditor().error(context, s, null);
                return;
            }
            messages.remove(t.getLocalizedMessage());
            for (String s : messages) {
                this.getDataAuditor().error(context, s, null);
            }
            this.getDataAuditor().error(context, null, t);
        }
    }

    @NotNull
    public static File getTempDirectory(@NotNull Project project) {
        if (project == null) {
            JpaEngineBase.$$$reportNull$$$0(3);
        }
        File file = new File(CompilerPaths.getGeneratedDataDirectory((Project)project), "Jpa_Console");
        if (file == null) {
            JpaEngineBase.$$$reportNull$$$0(4);
        }
        return file;
    }

    @Nullable
    protected static LocalDataSource findDataSource(Project project, PersistencePackagePointer unitFile) {
        DumbService service = DumbService.getInstance((Project)project);
        return (LocalDataSource)service.runReadActionInSmartMode(() -> {
            PersistenceFacet facet = unitFile.getPersistenceFacet();
            if (facet == null) {
                return null;
            }
            String dataSourceId = facet.getDataSourceId(unitFile);
            DbDataSource dbElement = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
            DatabaseSystem delegate = dbElement != null ? dbElement.getDelegate() : null;
            return delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
        });
    }

    protected void onTemporaryConfigGenerated(@NotNull GenerationInfo info, @NotNull File file) {
        DataRequest.Owner owner;
        if (info == null) {
            JpaEngineBase.$$$reportNull$$$0(5);
        }
        if (file == null) {
            JpaEngineBase.$$$reportNull$$$0(6);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && ApplicationManager.getApplication().isEAP()) {
            this.getDataAuditor().print(this.getRequestContext(), "using " + file.getPath());
        }
        if ((owner = this.getRequestContext().request.owner) instanceof JpaConsoleBase && info.dataSource != null) {
            ((JpaConsoleBase)owner).initHighlighter(info.dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTemporaryConfigText(@NotNull File file, @NotNull String text, @NotNull GenerationInfo info) {
        if (file == null) {
            JpaEngineBase.$$$reportNull$$$0(7);
        }
        if (text == null) {
            JpaEngineBase.$$$reportNull$$$0(8);
        }
        if (info == null) {
            JpaEngineBase.$$$reportNull$$$0(9);
        }
        try {
            file.getParentFile().mkdirs();
            FileUtil.writeToFile((File)file, (String)text);
        }
        catch (IOException e) {
            this.getRequestContext().reportException((Throwable)e, null);
        }
        finally {
            this.onTemporaryConfigGenerated(info, file);
        }
    }

    @NotNull
    protected DataRequest.Context createRequestContext(@NotNull DataRequest request) {
        if (request == null) {
            JpaEngineBase.$$$reportNull$$$0(10);
        }
        DataRequest.Context context = new DataRequest.Context(this, request, DataRequest.NONE){

            public void reportException(@NotNull Throwable th, Object parameter) {
                if (th == null) {
                    1.$$$reportNull$$$0(0);
                }
                JpaEngineBase.this.handleException(this, th);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/jpa/engine/JpaEngineBase$1", "reportException"));
            }
        };
        if (context == null) {
            JpaEngineBase.$$$reportNull$$$0(11);
        }
        return context;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/engine/JpaEngineBase";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/engine/JpaEngineBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "queryData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleException";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTempDirectory";
                break;
            }
            case 4: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onTemporaryConfigGenerated";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeTemporaryConfigText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRequestContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$queryData$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class GenerationInfo {
        public final Project project;
        public final PersistenceFacet facet;
        public final PersistencePackage unit;
        public final LocalDataSource dataSource;
        public final Credentials credentials;

        public GenerationInfo(Project project, PersistenceFacet facet, PersistencePackage unit, LocalDataSource dataSource, Credentials credentials) {
            this.project = project;
            this.facet = facet;
            this.unit = unit;
            this.dataSource = dataSource;
            this.credentials = credentials;
        }
    }
}

