/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import com.intellij.rt.execution.testFrameworks.ForkedDebuggerHelper;
import com.intellij.rt.execution.testFrameworks.ProcessBuilder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;

public abstract class ForkedByModuleSplitter {
    protected final ForkedDebuggerHelper myForkedDebuggerHelper = new ForkedDebuggerHelper();
    protected final String myWorkingDirsPath;
    protected final String myForkMode;
    protected final List myNewArgs;
    protected String myDynamicClasspath;
    protected List myVMParameters;

    public ForkedByModuleSplitter(String workingDirsPath, String forkMode, List newArgs) {
        this.myWorkingDirsPath = workingDirsPath;
        this.myForkMode = forkMode;
        this.myNewArgs = newArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startSplitting(String[] args, String configName, String commandLinePath, String repeatCount) throws Exception {
        args = this.myForkedDebuggerHelper.excludeDebugPortFromArgs(args);
        this.myVMParameters = new ArrayList();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(commandLinePath));
        this.myDynamicClasspath = bufferedReader.readLine();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                this.myVMParameters.add(line);
            }
        }
        finally {
            bufferedReader.close();
        }
        int result = this.startSplitting(args, configName, repeatCount);
        this.myForkedDebuggerHelper.closeDebugSocket();
        return result;
    }

    protected int startChildFork(List args, File workingDir, String classpath, String repeatCount) throws IOException, InterruptedException {
        ArrayList vmParameters = new ArrayList(this.myVMParameters);
        this.myForkedDebuggerHelper.setupDebugger(vmParameters);
        ProcessBuilder builder = new ProcessBuilder();
        builder.add(vmParameters);
        String encoding = System.getProperty("file.encoding");
        if (encoding != null) {
            builder.add("-Dfile.encoding=" + encoding);
        }
        builder.add("-classpath");
        if (this.myDynamicClasspath.length() > 0) {
            try {
                builder.add(ForkedByModuleSplitter.createClasspathJarFile(new Manifest(), classpath).getAbsolutePath());
            }
            catch (Throwable e) {
                builder.add(classpath);
            }
        } else {
            builder.add(classpath);
        }
        builder.add(this.getStarterName());
        builder.add(args);
        if (repeatCount != null) {
            builder.add(repeatCount);
        }
        builder.setWorkingDir(workingDir);
        Process exec = builder.createProcess();
        boolean[] stopped = new boolean[1];
        new Thread(ForkedByModuleSplitter.createInputReader(exec.getErrorStream(), System.err, stopped), "Read forked error output").start();
        new Thread(ForkedByModuleSplitter.createInputReader(exec.getInputStream(), System.out, stopped), "Read forked output").start();
        int i = exec.waitFor();
        stopped[0] = true;
        return i;
    }

    private static Runnable createInputReader(final InputStream inputStream, final PrintStream outputStream, final boolean[] stopped) {
        return new Runnable(){
            char[] buf = new char[8192];

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block15: {
                    InputStreamReader inputReader;
                    try {
                        inputReader = new InputStreamReader(inputStream, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        return;
                    }
                    block11: while (true) {
                        while (true) {
                            if (stopped[0]) {
                                break block15;
                            }
                            try {
                                while (true) {
                                    int n;
                                    if (!inputReader.ready() || (n = inputReader.read(this.buf)) <= 0) continue block11;
                                    outputStream.print(new String(this.buf, 0, n));
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                continue;
                            }
                            break;
                        }
                        break;
                    }
                    finally {
                        try {
                            inputReader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int splitPerModule(String repeatCount) throws IOException {
        int result = 0;
        BufferedReader perDirReader = new BufferedReader(new FileReader(this.myWorkingDirsPath));
        try {
            String workingDir;
            String packageName = perDirReader.readLine();
            while ((workingDir = perDirReader.readLine()) != null) {
                String moduleName = perDirReader.readLine();
                String classpath = perDirReader.readLine();
                try {
                    ArrayList<String> classNames = new ArrayList<String>();
                    int classNamesSize = Integer.parseInt(perDirReader.readLine());
                    for (int i = 0; i < classNamesSize; ++i) {
                        String className = perDirReader.readLine();
                        if (className == null) {
                            System.err.println("Class name is expected. Working dir: " + workingDir);
                            result = -1;
                            break;
                        }
                        classNames.add(className);
                    }
                    int childResult = this.startPerModuleFork(moduleName, classNames, packageName, workingDir, classpath, repeatCount, result);
                    result = Math.min(childResult, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            perDirReader.close();
        }
        return result;
    }

    protected abstract int startSplitting(String[] var1, String var2, String var3) throws Exception;

    protected abstract int startPerModuleFork(String var1, List var2, String var3, String var4, String var5, String var6, int var7) throws Exception;

    protected abstract String getStarterName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createClasspathJarFile(Manifest manifest, String classpath) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        String classpathForManifest = "";
        int idx = 0;
        int endIdx = 0;
        while (endIdx >= 0) {
            String path;
            endIdx = classpath.indexOf(File.pathSeparator, idx);
            String string = path = endIdx < 0 ? classpath.substring(idx) : classpath.substring(idx, endIdx);
            if (classpathForManifest.length() > 0) {
                classpathForManifest = classpathForManifest + " ";
            }
            try {
                classpathForManifest = classpathForManifest + new File(path).toURI().toURL().toString();
            }
            catch (NoSuchMethodError e) {
                classpathForManifest = classpathForManifest + new File(path).toURL().toString();
            }
            idx = endIdx + File.pathSeparator.length();
        }
        attributes.put(Attributes.Name.CLASS_PATH, classpathForManifest);
        File jarFile = File.createTempFile("classpath", ".jar");
        ZipOutputStream jarPlugin = null;
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jarFile));
            jarPlugin = new JarOutputStream((OutputStream)out, manifest);
        }
        finally {
            if (jarPlugin != null) {
                jarPlugin.close();
            }
        }
        jarFile.deleteOnExit();
        return jarFile;
    }
}

