/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle.css.language;

import com.intellij.gwt.clientBundle.css.language.GwtCssElementTypes;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.parsing.CssParser2;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class GwtCssParser
extends CssParser2 {
    protected boolean parseAtRule() {
        String ruleName = this.getAtName();
        if (ruleName.equals("def")) {
            this.parseDef();
        } else if (ruleName.equals("if")) {
            this.parseIf();
        } else if (ruleName.equals("eval")) {
            this.parseEval();
        } else if (ruleName.equals("external")) {
            this.parseExternal();
        } else if (ruleName.equals("noflip")) {
            this.parseNoflip();
        } else if (ruleName.equals("sprite")) {
            this.parseSprite();
        } else if (ruleName.equals("url")) {
            this.parseUrl();
        } else {
            return false;
        }
        return true;
    }

    private void parseDef() {
        PsiBuilder.Marker defElement = this.createNamedElement();
        this.parseTermList(false, new IElementType[0]);
        this.addSemicolonOrError();
        defElement.done(GwtCssElementTypes.CSS_DEF);
    }

    private void parseUrl() {
        PsiBuilder.Marker url = this.createNamedElement();
        this.addTokensUntilSemicolon();
        url.done(GwtCssElementTypes.CSS_URL_DECLARATION);
    }

    private void parseEval() {
        PsiBuilder.Marker eval = this.createNamedElement();
        this.addTokensUntilSemicolon();
        eval.done(GwtCssElementTypes.CSS_EVAL);
    }

    private void parseExternal() {
        PsiBuilder.Marker external = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.addTokensUntilSemicolon();
        external.done(GwtCssElementTypes.CSS_EXTERNAL);
    }

    private void parseIf() {
        PsiBuilder.Marker ifStatement = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.parseCondition();
        this.parseBody();
        while (this.isAtToken("elif")) {
            this.addTokenAndSkipWhitespace();
            this.parseCondition();
            this.parseBody();
        }
        if (this.isAtToken("else")) {
            this.addTokenAndSkipWhitespace();
            this.parseBody();
        }
        ifStatement.done(GwtCssElementTypes.CSS_IF_STATEMENT);
    }

    private void parseBody() {
        this.addTokenOrError(CssElementTypes.CSS_LBRACE, "{");
        this.parseRulesetList(true);
        this.addTokenOrError(CssElementTypes.CSS_RBRACE, "}");
    }

    private void parseCondition() {
        while (!this.isDone() && this.getTokenType() != CssElementTypes.CSS_LBRACE) {
            this.addToken();
        }
    }

    private void parseSprite() {
        PsiBuilder.Marker sprite = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        if (!this.parseRuleset()) {
            this.createErrorElement(CssBundle.message((String)"expected", (Object[])new Object[]{"rule"}));
        }
        sprite.done(GwtCssElementTypes.CSS_SPRITE);
    }

    private void parseNoflip() {
        PsiBuilder.Marker noFlip = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.parseBody();
        noFlip.done(GwtCssElementTypes.CSS_NO_FLIP);
    }

    private PsiBuilder.Marker createNamedElement() {
        PsiBuilder.Marker defElement = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.addIdentOrError();
        return defElement;
    }

    private void addTokensUntilSemicolon() {
        while (!this.isDone() && this.getTokenType() != CssElementTypes.CSS_SEMICOLON) {
            this.addToken();
        }
        this.addTokenAndSkipWhitespace();
    }

    private String getAtName() {
        String tokenText = this.getTokenText();
        return tokenText != null && tokenText.length() > 0 ? tokenText.substring(1) : "";
    }

    private boolean isAtToken(@NotNull String token) {
        if (token == null) {
            GwtCssParser.$$$reportNull$$$0(0);
        }
        if (this.getTokenType() != CssElementTypes.CSS_ATKEYWORD) {
            return false;
        }
        return token.equals(this.getAtName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/gwt/clientBundle/css/language/GwtCssParser", "isAtToken"));
    }
}

