/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.gradle;

import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.gwt.sdk.GwtSdkType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtGradleSdkPaths;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class GwtDependencyDataService
extends AbstractProjectDataService<LibraryDependencyData, Module> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.gradle.GwtDependencyDataService");

    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY_DEPENDENCY;
        if (key == null) {
            GwtDependencyDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryDependencyData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            GwtDependencyDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GwtDependencyDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            GwtDependencyDataService.$$$reportNull$$$0(3);
        }
        for (DataNode<LibraryDependencyData> node : toImport) {
            Module module;
            Set paths;
            String path;
            String externalName = ((LibraryDependencyData)node.getData()).getExternalName();
            if (!externalName.startsWith("com.google.gwt:gwt-servlet:") && !externalName.startsWith("com.google.gwt:gwt-user:") || (path = (String)ContainerUtil.getFirstItem((Collection)(paths = ((LibraryData)((LibraryDependencyData)node.getData()).getTarget()).getPaths(LibraryPathType.BINARY)))) == null || (module = modelsProvider.findIdeModule(((LibraryDependencyData)node.getData()).getOwnerModule())) == null) continue;
            GwtDependencyDataService.setupGwtFacet(module, path, modelsProvider);
        }
    }

    private static void setupGwtFacet(@NotNull Module module, @NotNull String pathToGwtJar, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String[] possibleUrls;
        ModifiableFacetModel facetModel;
        GwtFacet gwtFacet;
        if (module == null) {
            GwtDependencyDataService.$$$reportNull$$$0(4);
        }
        if (pathToGwtJar == null) {
            GwtDependencyDataService.$$$reportNull$$$0(5);
        }
        if (modelsProvider == null) {
            GwtDependencyDataService.$$$reportNull$$$0(6);
        }
        if ((gwtFacet = (GwtFacet)(facetModel = modelsProvider.getModifiableFacetModel(module)).getFacetByType(GwtFacetType.ID)) == null) {
            GwtFacetType facetType = GwtFacetType.getInstance();
            gwtFacet = facetType.createFacet(module, facetType.getDefaultFacetName(), facetType.createDefaultConfiguration(), (Facet)null);
            facetModel.addFacet((Facet)gwtFacet, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)GradleConstants.SYSTEM_ID));
        }
        GwtFacetConfiguration configuration = (GwtFacetConfiguration)gwtFacet.getConfiguration();
        for (String url : possibleUrls = new String[]{GwtGradleSdkPaths.getSdkUrl((String)pathToGwtJar, (boolean)false), GwtGradleSdkPaths.getSdkUrl((String)pathToGwtJar, (boolean)true)}) {
            GwtSdkType type = GwtSdkManager.getInstance().detectSdkType(url);
            if (type == null) continue;
            configuration.setGwtSdkType(type.getId());
            configuration.setGwtSdkUrl(url);
            break;
        }
        if (configuration.getGwtSdkUrl() == null) {
            LOG.info("Cannot detect GWT SDK location by " + pathToGwtJar);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/gradle/GwtDependencyDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToGwtJar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/gradle/GwtDependencyDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupGwtFacet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

