/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.maven;

import com.intellij.gwt.maven.GwtLtgtModuleImporter;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class GwtLtgtModuleWatcher {
    private final Project myProject;
    private final MavenProjectsManager myMavenProjectsManager;
    private final MergingUpdateQueue myUpdateQueue;
    private final GwtLtgtModuleImporter myMyLtgtModuleImporter = new GwtLtgtModuleImporter();

    public static GwtLtgtModuleWatcher getInstance(Project project) {
        return (GwtLtgtModuleWatcher)ServiceManager.getService((Project)project, GwtLtgtModuleWatcher.class);
    }

    protected GwtLtgtModuleWatcher(Project project) {
        this.myProject = project;
        this.myMavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
        this.myUpdateQueue = new MergingUpdateQueue("GwtLtgtModuleWatcher", 1000, true, null);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new GwtLtgtModulePsiTreeChangeListener());
    }

    public MergingUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    private void reimportModuleFile(final MavenProject mavenProject) {
        this.myUpdateQueue.queue(new Update(mavenProject){

            public void run() {
                if (GwtLtgtModuleWatcher.this.myProject.isDisposed()) {
                    return;
                }
                Module module = GwtLtgtModuleWatcher.this.myMavenProjectsManager.findModule(mavenProject);
                if (module == null) {
                    return;
                }
                GwtLtgtModuleWatcher.this.myMavenProjectsManager.forceUpdateProjects(Collections.singleton(mavenProject));
            }
        });
    }

    private class GwtLtgtModulePsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private GwtLtgtModulePsiTreeChangeListener() {
        }

        private void processEvent(@NotNull PsiTreeChangeEvent event) {
            PsiFile file;
            if (event == null) {
                GwtLtgtModulePsiTreeChangeListener.$$$reportNull$$$0(0);
            }
            if ((file = event.getFile()) == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)GwtLtgtModuleWatcher.this.myProject);
            if (module == null || !GwtLtgtModuleWatcher.this.myMavenProjectsManager.isMavenizedModule(module)) {
                return;
            }
            MavenProject mavenProject = GwtLtgtModuleWatcher.this.myMavenProjectsManager.findProject(module);
            if (mavenProject == null) {
                return;
            }
            if (!GwtLtgtModuleWatcher.this.myMyLtgtModuleImporter.isApplicable(mavenProject)) {
                return;
            }
            if (!GwtLtgtModuleWatcher.this.myMyLtgtModuleImporter.isModuleTemplate(mavenProject, virtualFile)) {
                return;
            }
            GwtLtgtModuleWatcher.this.reimportModuleFile(mavenProject);
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GwtLtgtModulePsiTreeChangeListener.$$$reportNull$$$0(1);
            }
            this.processEvent(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GwtLtgtModulePsiTreeChangeListener.$$$reportNull$$$0(2);
            }
            this.processEvent(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GwtLtgtModulePsiTreeChangeListener.$$$reportNull$$$0(3);
            }
            this.processEvent(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GwtLtgtModulePsiTreeChangeListener.$$$reportNull$$$0(4);
            }
            this.processEvent(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GwtLtgtModulePsiTreeChangeListener.$$$reportNull$$$0(5);
            }
            this.processEvent(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/gwt/maven/GwtLtgtModuleWatcher$GwtLtgtModulePsiTreeChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

