/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.module.index;

import com.intellij.lexer.HtmlLexer;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class GwtHtmlUtil {
    @NonNls
    private static final String META_TAG_NAME = "meta";
    @NonNls
    private static final String GWT_MODULE_META_NAME = "gwt:module";
    @NonNls
    private static final String JAVASCRIPT_LANGUAGE_NAME = "javascript";
    @NonNls
    private static final String JAVASCRIPT_TYPE = "text/javascript";
    @NonNls
    private static final String NO_CACHE_SUFFIX = ".nocache.js";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String CONTENT_ATTRIBUTE = "content";

    private GwtHtmlUtil() {
    }

    public static void collectGwtModules(CharSequence fileText, Map<String, Void> result) {
        IElementType tokenType;
        HtmlLexer lexer = new HtmlLexer();
        lexer.start(fileText);
        String currentTag = null;
        THashMap attributes = new THashMap();
        while ((tokenType = lexer.getTokenType()) != null) {
            if (tokenType == XmlTokenType.XML_START_TAG_START) {
                currentTag = null;
                lexer.advance();
                if (lexer.getTokenType() != XmlTokenType.XML_NAME) continue;
                currentTag = GwtHtmlUtil.getTokenText(lexer).toLowerCase();
                lexer.advance();
                continue;
            }
            if (tokenType == XmlTokenType.XML_NAME) {
                String attributeName = GwtHtmlUtil.getTokenText(lexer);
                GwtHtmlUtil.skipWhiteSpaces(lexer);
                if (lexer.getTokenType() != XmlTokenType.XML_EQ) continue;
                GwtHtmlUtil.skipWhiteSpaces(lexer);
                if (lexer.getTokenType() != XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) continue;
                lexer.advance();
                if (lexer.getTokenType() != XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) continue;
                String attributeValue = GwtHtmlUtil.getTokenText(lexer);
                lexer.advance();
                if (lexer.getTokenType() != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) continue;
                attributes.put(attributeName, attributeValue);
                lexer.advance();
                continue;
            }
            if (tokenType == XmlTokenType.XML_TAG_END) {
                String src;
                if (META_TAG_NAME.equals(currentTag) && GWT_MODULE_META_NAME.equals(attributes.get(NAME_ATTRIBUTE))) {
                    String content = (String)attributes.get(CONTENT_ATTRIBUTE);
                    if (content != null) {
                        result.put(content, null);
                    }
                } else if ("script".equals(currentTag) && (JAVASCRIPT_LANGUAGE_NAME.equalsIgnoreCase((String)attributes.get("language")) || JAVASCRIPT_TYPE.equalsIgnoreCase((String)attributes.get("type")) || null == attributes.get("language") && null == attributes.get("type")) && (src = (String)attributes.get("src")) != null && src.endsWith(NO_CACHE_SUFFIX)) {
                    int start = Math.max(src.lastIndexOf(47), src.lastIndexOf(92));
                    result.put(src.substring(start + 1, src.length() - NO_CACHE_SUFFIX.length()), null);
                }
                currentTag = null;
                attributes.clear();
                lexer.advance();
                continue;
            }
            lexer.advance();
        }
    }

    private static String getTokenText(HtmlLexer lexer) {
        return lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
    }

    private static void skipWhiteSpaces(HtmlLexer lexer) {
        lexer.advance();
        while (lexer.getTokenType() == XmlTokenType.XML_WHITE_SPACE) {
            lexer.advance();
        }
    }

    public static ElementPattern<? extends XmlAttributeValue> createMetaValuePattern() {
        return XmlPatterns.xmlAttributeValue((ElementPattern)XmlPatterns.xmlAttribute((String)CONTENT_ATTRIBUTE).withParent((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName(META_TAG_NAME)).withAttributeValue(NAME_ATTRIBUTE, GWT_MODULE_META_NAME)));
    }
}

