/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run.remoteUi;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.run.remoteUi.RemoteUiRequest;
import com.intellij.gwt.run.remoteUi.responses.CapabilityExchangeResponse;
import com.intellij.gwt.run.remoteUi.responses.InitializeResponse;
import com.intellij.gwt.run.remoteUi.responses.RemoteUiResponse;
import com.intellij.gwt.run.remoteUi.responses.RemoteUiResponseReader;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponseHandler;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.RequestWriter;
import com.intellij.util.io.socketConnection.ResponseReader;
import com.intellij.util.io.socketConnection.SocketConnection;
import com.intellij.util.io.socketConnection.SocketConnectionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteUiConnection {
    private final SocketConnection<RemoteUiRequest, RemoteUiResponse> myConnection;
    private final GwtRunConfiguration myConfiguration;
    private final GwtVersion mySdkVersion;
    private final boolean myOpenInBrowser;
    private final boolean myStartJavaScriptDebugger;
    private final WebBrowser myBrowser;

    public RemoteUiConnection(GwtRunConfiguration configuration, @NotNull GwtVersion sdkVersion, boolean openInBrowser, boolean startJavaScriptDebugger, @Nullable WebBrowser browser) {
        if (sdkVersion == null) {
            RemoteUiConnection.$$$reportNull$$$0(0);
        }
        this.myConfiguration = configuration;
        this.mySdkVersion = sdkVersion;
        this.myOpenInBrowser = openInBrowser;
        this.myStartJavaScriptDebugger = startJavaScriptDebugger;
        this.myBrowser = browser;
        this.myConnection = SocketConnectionFactory.createServerConnection((int)7901, (int)20, (RequestResponseExternalizerFactory)new RemoteUiRequestExternalizer());
        this.myConnection.registerHandler(CapabilityExchangeResponse.class, (AbstractResponseHandler)new AbstractResponseHandler<CapabilityExchangeResponse>(){

            public void processResponse(CapabilityExchangeResponse response) {
                RemoteUiConnection.this.myConnection.sendRequest((AbstractRequest)RemoteUiRequest.createCapabilitiesResponse(response.getMessageId()));
            }
        });
        this.myConnection.registerHandler(InitializeResponse.class, (AbstractResponseHandler)new AbstractResponseHandler<InitializeResponse>(){

            public void processResponse(InitializeResponse response) {
                List<String> urls = response.getStartupUrlsList();
                if (!urls.isEmpty()) {
                    String url = urls.get(0);
                    SwingUtilities.invokeLater(() -> RemoteUiConnection.this.onInitialized(url));
                }
                RemoteUiConnection.this.myConnection.sendRequest((AbstractRequest)RemoteUiRequest.createDummyResponseRequest(response.getMessageId()));
            }
        });
    }

    public void sendRestartServerRequest() {
        this.myConnection.sendRequest((AbstractRequest)RemoteUiRequest.createRestartServerRequest());
    }

    @NotNull
    public GwtVersion getSdkVersion() {
        GwtVersion gwtVersion = this.mySdkVersion;
        if (gwtVersion == null) {
            RemoteUiConnection.$$$reportNull$$$0(1);
        }
        return gwtVersion;
    }

    private void onInitialized(String url) {
        if (this.myOpenInBrowser) {
            JavaScriptDebuggerStarter.Util.startDebugOrLaunchBrowser((RunConfiguration)this.myConfiguration, (String)url, (WebBrowser)this.myBrowser, (boolean)this.myStartJavaScriptDebugger);
        }
    }

    public int open() throws IOException {
        this.myConnection.open();
        return this.myConnection.getPort();
    }

    public SocketConnection<RemoteUiRequest, RemoteUiResponse> getConnection() {
        return this.myConnection;
    }

    public void close() {
        this.myConnection.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkVersion";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/run/remoteUi/RemoteUiConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/run/remoteUi/RemoteUiConnection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoteUiRequestExternalizer
    extends RequestResponseExternalizerFactory<RemoteUiRequest, RemoteUiResponse> {
        private RemoteUiRequestExternalizer() {
        }

        @NotNull
        public RequestWriter<RemoteUiRequest> createRequestWriter(final @NotNull OutputStream output) throws IOException {
            if (output == null) {
                RemoteUiRequestExternalizer.$$$reportNull$$$0(0);
            }
            RequestWriter<RemoteUiRequest> requestWriter = new RequestWriter<RemoteUiRequest>(){

                public void writeRequest(RemoteUiRequest request) throws IOException {
                    request.sendMessage(output);
                }
            };
            if (requestWriter == null) {
                RemoteUiRequestExternalizer.$$$reportNull$$$0(1);
            }
            return requestWriter;
        }

        @NotNull
        public ResponseReader<RemoteUiResponse> createResponseReader(@NotNull InputStream input) throws IOException {
            if (input == null) {
                RemoteUiRequestExternalizer.$$$reportNull$$$0(2);
            }
            RemoteUiResponseReader remoteUiResponseReader = new RemoteUiResponseReader(input);
            if (remoteUiResponseReader == null) {
                RemoteUiRequestExternalizer.$$$reportNull$$$0(3);
            }
            return remoteUiResponseReader;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/run/remoteUi/RemoteUiConnection$RemoteUiRequestExternalizer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/run/remoteUi/RemoteUiConnection$RemoteUiRequestExternalizer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRequestWriter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createResponseReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createRequestWriter";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createResponseReader";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

