/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.superSource;

import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.psi.GwtSourcePathsRefresher;
import com.intellij.gwt.superSource.GwtSuperSourceClassCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.impl.GwtSourcePath;

public class GwtSuperSourceClassCacheImpl
extends GwtSuperSourceClassCache {
    private final Project myProject;
    private final Map<String, Boolean> myCachedSuperSourceClasses = ContainerUtil.newConcurrentMap();

    public GwtSuperSourceClassCacheImpl(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public List<PsiClass> findClassesByQualifiedName(@NotNull String qualifiedName, @NotNull VirtualFile root) {
        if (qualifiedName == null) {
            GwtSuperSourceClassCacheImpl.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GwtSuperSourceClassCacheImpl.$$$reportNull$$$0(1);
        }
        SmartList result = new SmartList();
        SmartList innerClassNames = new SmartList();
        String currentName = qualifiedName;
        do {
            PsiFile psiFile;
            VirtualFile file;
            if ((file = root.findFileByRelativePath(currentName.replace('.', '/') + ".java")) != null && (psiFile = this.getCachedPsiFile(file)) instanceof PsiJavaFile) {
                for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                    if (!currentName.equals(aClass.getQualifiedName())) continue;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)GwtSuperSourceClassCacheImpl.findInnerClass(aClass, (List<String>)innerClassNames));
                }
            }
            innerClassNames.add(StringUtil.getShortName((String)currentName));
        } while ((currentName = StringUtil.getPackageName((String)currentName)).length() > 0);
        SmartList smartList = result;
        if (smartList == null) {
            GwtSuperSourceClassCacheImpl.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(VirtualFile file) {
        return PsiManager.getInstance((Project)this.myProject).findFile(file);
    }

    @Override
    public boolean containsJreEmulationClass(@NotNull List<GwtModule> gwtModules, @NotNull String className) {
        Boolean result;
        if (gwtModules == null) {
            GwtSuperSourceClassCacheImpl.$$$reportNull$$$0(3);
        }
        if (className == null) {
            GwtSuperSourceClassCacheImpl.$$$reportNull$$$0(4);
        }
        if ((result = this.myCachedSuperSourceClasses.get(className)) != null) {
            return result;
        }
        result = Boolean.FALSE;
        GwtSourcePathsRefresher sourcePathsRefresher = GwtSourcePathsRefresher.getInstance(this.myProject);
        for (GwtSourcePath superSourcePath : sourcePathsRefresher.getSuperSourcePaths(gwtModules)) {
            String filePath;
            PsiClass psiClass;
            VirtualFile superSourceRoot = LocalFileSystem.getInstance().findFileByPath(superSourcePath.myFullPath);
            if (superSourceRoot == null || (psiClass = (PsiClass)ContainerUtil.getFirstItem(this.findClassesByQualifiedName(className, superSourceRoot))) == null || !sourcePathsRefresher.isIncluded(filePath = psiClass.getContainingFile().getVirtualFile().getPath(), superSourcePath)) continue;
            result = Boolean.TRUE;
            break;
        }
        this.myCachedSuperSourceClasses.put(className, result);
        return result;
    }

    @Override
    public void invalidateSuperSourceCache() {
        this.myCachedSuperSourceClasses.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/superSource/GwtSuperSourceClassCacheImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModules";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/superSource/GwtSuperSourceClassCacheImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesByQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByQualifiedName";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsJreEmulationClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

