/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.gwt.uiBinder.GwtUiXmlFileUtil;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GwtUiFieldNameCompletionContributor
extends CompletionContributor {
    public GwtUiFieldNameCompletionContributor() {
        PsiElementPattern.Capture uiFieldPattern = (PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiIdentifier.class).withParent(PsiField.class);
        this.extend(CompletionType.BASIC, (ElementPattern)uiFieldPattern, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiField psiField;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!UiBinderUtil.isUiField(psiField = (PsiField)parameters.getPosition().getParent())) {
                    return;
                }
                PsiClass psiClass = psiField.getContainingClass();
                if (psiClass == null) {
                    return;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
                if (module == null) {
                    return;
                }
                UiBinderMappingService mappingService = UiBinderMappingService.getInstance(module);
                List<XmlFile> uiXmlFiles = mappingService.getUiXmlFiles(psiClass);
                if (uiXmlFiles.isEmpty()) {
                    return;
                }
                for (XmlFile uiXmlFile : uiXmlFiles) {
                    MultiValuesMap<String, XmlAttributeValue> fieldNameToAttributeMap = GwtUiXmlFileUtil.getFieldNameToAttributeMap(uiXmlFile);
                    if (fieldNameToAttributeMap == null) continue;
                    for (Map.Entry entry : fieldNameToAttributeMap.entrySet()) {
                        String fieldName = (String)entry.getKey();
                        for (XmlAttributeValue attribute : (Collection)entry.getValue()) {
                            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)attribute, XmlTag.class);
                            if (tag == null || !tag.isValid()) continue;
                            String className = UiBinderUtil.getComponentClassName(tag);
                            PsiClassType tagType = JavaPsiFacade.getElementFactory((Project)psiField.getProject()).createTypeByFQClassName(className, psiField.getResolveScope());
                            PsiType psiFieldType = UiBinderUtil.getUnwrappedUiFieldType(psiField);
                            if (!TypeConversionUtil.isAssignable((PsiType)psiFieldType, (PsiType)tagType)) continue;
                            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)fieldName).withAutoCompletionPolicy(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE), (double)100.0));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/gwt/uiBinder/GwtUiFieldNameCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

