/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.annotations;

import com.android.tools.idea.actions.annotations.InferSupportAnnotations;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.SupportLibrary;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferSupportAnnotationsAction
extends BaseAnalysisAction {
    static final boolean ENABLED = Boolean.valueOf(System.getProperty("studio.infer.annotations"));
    static final int MAX_PASSES = 3;
    @NonNls
    private static final String INFER_SUPPORT_ANNOTATIONS = "Infer Support Annotations";
    private static final int MAX_ANNOTATIONS_WITHOUT_PREVIEW = 5;
    private static final String ADD_DEPENDENCY = "Add Support Dependency";
    private static final int MIN_SDK_WITH_NULLABLE = 19;

    public InferSupportAnnotationsAction() {
        super(INFER_SUPPORT_ANNOTATIONS, INFER_SUPPORT_ANNOTATIONS);
        if (!ENABLED) {
            this.getTemplatePresentation().setVisible(false);
        }
    }

    public void update(AnActionEvent event) {
        if (!ENABLED) {
            return;
        }
        super.update(event);
        Project project = event.getProject();
        if (project == null || !GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(false);
        }
    }

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(1);
        }
        if (!GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            return;
        }
        int[] fileCount = new int[]{0};
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UsageInfo[] usageInfos = InferSupportAnnotationsAction.findUsages(project, scope, fileCount[0]);
        if (usageInfos == null) {
            return;
        }
        Map<Module, PsiFile> modules = InferSupportAnnotationsAction.findModulesFromUsage(usageInfos);
        if (!this.checkModules(project, scope, modules)) {
            return;
        }
        if (usageInfos.length < 5) {
            ApplicationManager.getApplication().invokeLater(InferSupportAnnotationsAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> usageInfos)));
        } else {
            InferSupportAnnotationsAction.showUsageView(project, usageInfos, scope);
        }
    }

    private static Map<Module, PsiFile> findModulesFromUsage(UsageInfo[] infos) {
        HashMap<Module, PsiFile> modules = new HashMap<Module, PsiFile>();
        for (UsageInfo info : infos) {
            PsiElement element = info.getElement();
            assert (element != null);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null) continue;
            PsiFile file = element.getContainingFile();
            modules.put(module, file);
        }
        return modules;
    }

    private static UsageInfo[] findUsages(final @NotNull Project project, @NotNull AnalysisScope scope, final int fileCount) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(3);
        }
        final InferSupportAnnotations inferrer = new InferSupportAnnotations(false, project);
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        Runnable searchForUsages = () -> {
            if (scope == null) {
                InferSupportAnnotationsAction.$$$reportNull$$$0(16);
            }
            if (project == null) {
                InferSupportAnnotationsAction.$$$reportNull$$$0(17);
            }
            scope.accept(new PsiElementVisitor(){
                int myFileCount = 0;

                public void visitFile(PsiFile file) {
                    Document document;
                    ++this.myFileCount;
                    VirtualFile virtualFile = file.getVirtualFile();
                    FileViewProvider viewProvider = psiManager.findViewProvider(virtualFile);
                    Document document2 = document = viewProvider == null ? null : viewProvider.getDocument();
                    if (document == null || virtualFile.getFileType().isBinary()) {
                        return;
                    }
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    if (progressIndicator != null) {
                        progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                        progressIndicator.setFraction((double)this.myFileCount / (double)(3 * fileCount));
                    }
                    if (file instanceof PsiJavaFile) {
                        inferrer.collect(file);
                    }
                }
            });
        };
        Runnable multipass = () -> {
            for (int i = 0; i < 3; ++i) {
                searchForUsages.run();
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(multipass, INFER_SUPPORT_ANNOTATIONS, true, project)) {
                return null;
            }
        } else {
            multipass.run();
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        inferrer.collect(usages, scope);
        return usages.toArray(new UsageInfo[usages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkModules(final @NotNull Project project, final @NotNull AnalysisScope scope, @NotNull Map<Module, PsiFile> modules) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(5);
        }
        if (modules == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(6);
        }
        final HashSet<Module> modulesWithoutAnnotations = new HashSet<Module>();
        HashSet<Module> modulesWithLowVersion = new HashSet<Module>();
        for (Module module : modules.keySet()) {
            GradleBuildModel buildModel;
            AndroidModuleInfo info = AndroidModuleInfo.getInstance(module);
            if (info != null && info.getBuildSdkVersion() != null && info.getBuildSdkVersion().getFeatureLevel() < 19) {
                modulesWithLowVersion.add(module);
            }
            if ((buildModel = GradleBuildModel.get(module)) == null) {
                Logger.getInstance(InferSupportAnnotationsAction.class).warn("Unable to find Gradle build model for module " + module.getModuleFilePath());
                continue;
            }
            boolean dependencyFound = false;
            DependenciesModel dependenciesModel = buildModel.dependencies();
            if (dependenciesModel != null) {
                String configurationName = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                for (ArtifactDependencyModel dependency : dependenciesModel.artifacts(configurationName)) {
                    String notation = dependency.compactNotation().value();
                    if (!notation.startsWith("com.android.support:appcompat-v7") && !notation.startsWith("com.android.support:support-v4") && !notation.startsWith("com.android.support:support-annotations")) continue;
                    dependencyFound = true;
                    break;
                }
            }
            if (dependencyFound) continue;
            modulesWithoutAnnotations.add(module);
        }
        if (!modulesWithLowVersion.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)String.format("Infer Support Annotations requires the project sdk level be set to %1$d or greater.", 19), (String)INFER_SUPPORT_ANNOTATIONS);
            return false;
        }
        if (modulesWithoutAnnotations.isEmpty()) {
            return true;
        }
        String moduleNames = StringUtil.join(modulesWithoutAnnotations, Module::getName, (String)", ");
        int count = modulesWithoutAnnotations.size();
        String message = String.format("The %1$s %2$s %3$sn't refer to the existing '%4$s' library with Android nullity annotations. \n\nWould you like to add the %5$s now?", StringUtil.pluralize((String)"module", (int)count), moduleNames, count > 1 ? "do" : "does", SupportLibrary.SUPPORT_ANNOTATIONS.getArtifactId(), StringUtil.pluralize((String)"dependency", (int)count));
        if (Messages.showOkCancelDialog((Project)project, (String)message, (String)"Infer Nullity Annotations", (Icon)Messages.getErrorIcon()) == 0) {
            LocalHistoryAction action = LocalHistory.getInstance().startAction(ADD_DEPENDENCY);
            try {
                new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        RepositoryUrlManager manager = RepositoryUrlManager.get();
                        String annotationsLibraryCoordinate = manager.getLibraryStringCoordinate(SupportLibrary.SUPPORT_ANNOTATIONS, true);
                        for (Module module : modulesWithoutAnnotations) {
                            InferSupportAnnotationsAction.addDependency(module, annotationsLibraryCoordinate);
                        }
                        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setGenerateSourcesOnSuccess(false).setTrigger(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
                        GradleSyncInvoker.getInstance().requestProjectSync(project, request, new GradleSyncListener.Adapter(){

                            @Override
                            public void syncSucceeded(@NotNull Project project) {
                                if (project == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                InferSupportAnnotationsAction.this.restartAnalysis(project, scope);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction$2$1", "syncSucceeded"));
                            }
                        });
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction$2", "run"));
                    }
                }.execute();
            }
            finally {
                action.finish();
            }
        }
        return false;
    }

    private static Runnable applyRunnable(final Project project, final Computable<UsageInfo[]> computable) {
        return () -> {
            LocalHistoryAction action = LocalHistory.getInstance().startAction(INFER_SUPPORT_ANNOTATIONS);
            try {
                new WriteCommandAction(project, INFER_SUPPORT_ANNOTATIONS, new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        UsageInfo[] infos;
                        if (result == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if ((infos = (UsageInfo[])computable.compute()).length > 0) {
                            LinkedHashSet elements = new LinkedHashSet();
                            for (UsageInfo info : infos) {
                                PsiFile containingFile;
                                VirtualFile virtualFile;
                                PsiElement element = info.getElement();
                                if (element == null || (virtualFile = (containingFile = element.getContainingFile()).getVirtualFile()).getFileType().isBinary()) continue;
                                ContainerUtil.addIfNotNull(elements, (Object)containingFile);
                            }
                            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                                return;
                            }
                            SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, InferSupportAnnotationsAction.INFER_SUPPORT_ANNOTATIONS, false);
                            progressTask.setMinIterationTime(200L);
                            progressTask.setTask((SequentialTask)new AnnotateTask(project, progressTask, infos));
                            ProgressManager.getInstance().run((Task)progressTask);
                        } else {
                            InferSupportAnnotations.nothingFoundMessage(project);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction$3", "run"));
                    }
                }.execute();
            }
            finally {
                action.finish();
            }
        };
    }

    private void restartAnalysis(Project project, AnalysisScope scope) {
        ApplicationManager.getApplication().invokeLater(() -> this.analyze(project, scope));
    }

    private static void showUsageView(@NotNull Project project, UsageInfo[] usageInfos, @NotNull AnalysisScope scope) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(8);
        }
        UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), "Preprocess Usages", true, project)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText("Infer Nullity Preview");
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        UsageView usageView = UsageViewManager.getInstance((Project)project).showUsages(targets, usages, presentation, InferSupportAnnotationsAction.rerunFactory(project, scope));
        Runnable refactoringRunnable = InferSupportAnnotationsAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> {
            Set infos = UsageViewUtil.getNotExcludedUsageInfos((UsageView)usageView);
            return infos.toArray(new UsageInfo[infos.size()]);
        }));
        String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
        usageView.addPerformOperationAction(refactoringRunnable, INFER_SUPPORT_ANNOTATIONS, canNotMakeString, INFER_SUPPORT_ANNOTATIONS, false);
    }

    @NotNull
    private static Factory<UsageSearcher> rerunFactory(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(10);
        }
        Factory factory = () -> {
            if (project == null) {
                InferSupportAnnotationsAction.$$$reportNull$$$0(14);
            }
            if (scope == null) {
                InferSupportAnnotationsAction.$$$reportNull$$$0(15);
            }
            return new UsageInfoSearcherAdapter(){

                @NotNull
                protected UsageInfo[] findUsages() {
                    UsageInfo[] usageInfoArray = (UsageInfo[])ObjectUtils.notNull((Object)InferSupportAnnotationsAction.findUsages(project, scope, scope.getFileCount()), (Object)UsageInfo.EMPTY_ARRAY);
                    if (usageInfoArray == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return usageInfoArray;
                }

                public void generate(@NotNull Processor<Usage> processor) {
                    if (processor == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    this.processUsages(processor, project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction$4";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "processor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "findUsages";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "generate";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        };
        if (factory == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(11);
        }
        return factory;
    }

    private static void addDependency(@NotNull Module module, @Nullable String libraryCoordinate) {
        if (module == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(12);
        }
        if (StringUtil.isNotEmpty((String)libraryCoordinate)) {
            ModuleRootModificationUtil.updateModel((Module)module, model -> {
                GradleBuildModel buildModel;
                if (module == null) {
                    InferSupportAnnotationsAction.$$$reportNull$$$0(13);
                }
                if ((buildModel = GradleBuildModel.get(module)) != null) {
                    String name = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                    buildModel.dependencies().addArtifact(name, libraryCoordinate);
                    buildModel.applyChanges();
                }
            });
        }
    }

    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        if (!GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            return super.getAdditionalActionSettings(project, dialog);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "rerunFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkModules";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showUsageView";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rerunFactory";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addDependency$9";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$rerunFactory$8";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findUsages$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AnnotateTask
    implements SequentialTask {
        private final Project myProject;
        private UsageInfo[] myInfos;
        private final SequentialModalProgressTask myTask;
        private int myCount = 0;
        private final int myTotal;

        public AnnotateTask(Project project, SequentialModalProgressTask progressTask, UsageInfo[] infos) {
            this.myProject = project;
            this.myInfos = infos;
            this.myTask = progressTask;
            this.myTotal = infos.length;
        }

        public void prepare() {
        }

        public boolean isDone() {
            return this.myCount > this.myTotal - 1;
        }

        public boolean iteration() {
            ProgressIndicator indicator = this.myTask.getIndicator();
            if (indicator != null) {
                indicator.setFraction((double)this.myCount / (double)this.myTotal);
            }
            InferSupportAnnotations.apply(this.myProject, this.myInfos[this.myCount++]);
            boolean done = this.isDone();
            if (this.isDone()) {
                try {
                    this.showReport();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return done;
        }

        public void stop() {
        }

        public void showReport() {
            String report = InferSupportAnnotations.generateReport(this.myInfos);
            String fileName = "Annotation Inference Report";
            ScratchFileService.Option option = ScratchFileService.Option.create_new_always;
            VirtualFile f = ScratchRootType.getInstance().createScratchFile(this.myProject, fileName, StdLanguages.TEXT, report, option);
            if (f != null) {
                FileEditorManager.getInstance((Project)this.myProject).openFile(f, true);
            }
        }
    }
}

