/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.utils.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Comparator;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class ClientCellRenderer
extends ColoredListCellRenderer {
    @NotNull
    private final String myEmptyText;

    public ClientCellRenderer() {
        this("");
    }

    public ClientCellRenderer(@NotNull String emptyText) {
        if (emptyText == null) {
            ClientCellRenderer.$$$reportNull$$$0(0);
        }
        this.myEmptyText = emptyText;
    }

    static Pair<String, String> splitApplicationName(String name) {
        int index = name.lastIndexOf(46);
        return Pair.of((Object)name.substring(0, index + 1), (Object)name.substring(index + 1));
    }

    private static void renderClient(@NotNull Client c, ColoredTextContainer container) {
        ClientData cd;
        String name;
        if (c == null) {
            ClientCellRenderer.$$$reportNull$$$0(1);
        }
        if ((name = (cd = c.getClientData()).getClientDescription()) == null) {
            return;
        }
        Pair<String, String> app = ClientCellRenderer.splitApplicationName(name);
        container.append((String)app.getFirst(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        container.append((String)app.getSecond(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (cd.isValidUserId() && cd.getUserId() != 0) {
            container.append(String.format(" (user %1$d)", cd.getUserId()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        container.append(String.format(" (%1$d)", cd.getPid()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        if (!c.isValid()) {
            container.append(" [DEAD]", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
    }

    protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (list == null) {
            ClientCellRenderer.$$$reportNull$$$0(2);
        }
        if (value instanceof Client) {
            ClientCellRenderer.renderClient((Client)value, (ColoredTextContainer)this);
        } else if (value == null) {
            this.append(this.myEmptyText, SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/ClientCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "renderClient";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ClientComparator
    implements Comparator<Client> {
        @Override
        public int compare(Client a, Client b) {
            ClientData ad = a.getClientData();
            ClientData bd = b.getClientData();
            String as = ad.getClientDescription() != null ? ad.getClientDescription() : String.valueOf(ad.getPid());
            String bs = bd.getClientDescription() != null ? bd.getClientDescription() : String.valueOf(bd.getPid());
            return as.compareTo(bs);
        }
    }
}

