/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views.nodedata;

import com.android.tools.idea.editors.hprof.views.nodedata.HeapClassObjNode;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapNode;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapPackageNode
implements HeapNode {
    @Nullable
    private HeapNode myParent;
    @NotNull
    private List<HeapNode> myChildren;
    @NotNull
    private HashMap<String, HeapPackageNode> mySubPackages;
    @NotNull
    private Set<HeapClassObjNode> myClasses;
    @NotNull
    private String myFullPackageName;
    @NotNull
    private String myPackageName;
    private int myTotalCount;
    private int myHeapInstanceCount;
    private int myShallowSize;
    private long myRetainedSize;

    public HeapPackageNode(@Nullable HeapPackageNode parent, @NotNull String packageName) {
        if (packageName == null) {
            HeapPackageNode.$$$reportNull$$$0(0);
        }
        this.myChildren = new ArrayList<HeapNode>();
        this.mySubPackages = new HashMap();
        this.myClasses = new HashSet();
        this.myPackageName = packageName;
        this.setParent(parent);
    }

    public void update(int currentHeapId) {
        this.myRetainedSize = 0L;
        for (HeapPackageNode heapPackageNode : this.mySubPackages.values()) {
            heapPackageNode.update(currentHeapId);
            this.updateCounts(heapPackageNode, currentHeapId);
        }
        for (HeapClassObjNode heapClassObjNode : this.myClasses) {
            this.updateCounts(heapClassObjNode, currentHeapId);
        }
    }

    private void updateCounts(@NotNull HeapNode heapNode, int currentHeapId) {
        if (heapNode == null) {
            HeapPackageNode.$$$reportNull$$$0(1);
        }
        this.myTotalCount += heapNode.getTotalCount();
        this.myHeapInstanceCount += heapNode.getHeapInstancesCount(currentHeapId);
        this.myShallowSize += heapNode.getShallowSize(currentHeapId);
        this.myRetainedSize += heapNode.getRetainedSize();
    }

    public void classifyClassObj(@NotNull HeapClassObjNode heapClassObjNode) {
        if (heapClassObjNode == null) {
            HeapPackageNode.$$$reportNull$$$0(2);
        }
        String className = heapClassObjNode.getClassObj().getClassName();
        assert (className.startsWith(this.myFullPackageName) && className.length() > this.myFullPackageName.length() + 1);
        String remainder = this.myFullPackageName.isEmpty() ? className : className.substring(this.myFullPackageName.length() + 1);
        int dotIndex = remainder.indexOf(46);
        if (dotIndex > 0) {
            assert (!remainder.isEmpty());
            String subPackageName = remainder.substring(0, dotIndex);
            HeapPackageNode heapPackageNode = this.mySubPackages.get(subPackageName);
            if (heapPackageNode == null) {
                heapPackageNode = new HeapPackageNode(this, subPackageName);
                this.mySubPackages.put(subPackageName, heapPackageNode);
            }
            heapPackageNode.classifyClassObj(heapClassObjNode);
        } else {
            this.myClasses.add(heapClassObjNode);
        }
    }

    public void clear() {
        this.removeAllChildren();
        this.mySubPackages.clear();
        this.myClasses.clear();
        this.myTotalCount = 0;
        this.myHeapInstanceCount = 0;
        this.myShallowSize = 0;
        this.myRetainedSize = 0L;
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = this.myFullPackageName;
        if (string == null) {
            HeapPackageNode.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSimpleName() {
        String string = this.myPackageName;
        if (string == null) {
            HeapPackageNode.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public int getTotalCount() {
        return this.myTotalCount;
    }

    @Override
    public int getHeapInstancesCount(int heapId) {
        return this.myHeapInstanceCount;
    }

    @Override
    public int getInstanceSize() {
        return -1;
    }

    @Override
    public int getShallowSize(int heapId) {
        return this.myShallowSize;
    }

    @Override
    public long getRetainedSize() {
        return this.myRetainedSize;
    }

    @Override
    public void add(@NotNull HeapNode heapNode) {
        if (heapNode == null) {
            HeapPackageNode.$$$reportNull$$$0(5);
        }
        heapNode.removeFromParent();
        heapNode.setParent(this);
        this.myChildren.add(heapNode);
    }

    @Override
    @NotNull
    public List<HeapNode> getChildren() {
        List<HeapNode> list = this.myChildren;
        if (list == null) {
            HeapPackageNode.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public void removeAllChildren() {
        for (HeapNode child : this.myChildren) {
            child.setParent(null);
        }
        this.myChildren.clear();
    }

    @NotNull
    public HashMap<String, HeapPackageNode> getSubPackages() {
        HashMap<String, HeapPackageNode> hashMap = this.mySubPackages;
        if (hashMap == null) {
            HeapPackageNode.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    public void buildTree() {
        for (HeapPackageNode heapPackageNode : this.mySubPackages.values()) {
            this.add(heapPackageNode);
            heapPackageNode.buildTree();
        }
        for (HeapClassObjNode heapClassObjNode : this.myClasses) {
            this.add(heapClassObjNode);
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.myChildren.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode node) {
        assert (node instanceof HeapNode);
        return this.myChildren.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.myChildren);
    }

    public void remove(@NotNull HeapNode node) {
        if (node == null) {
            HeapPackageNode.$$$reportNull$$$0(8);
        }
        this.myChildren.remove(node);
    }

    @Override
    public void removeFromParent() {
        if (this.myParent != null) {
            assert (this.myParent instanceof HeapPackageNode);
            ((HeapPackageNode)this.myParent).remove(this);
            this.setParent(null);
        }
    }

    @Override
    public void setParent(@Nullable HeapNode newParent) {
        assert (newParent == null || newParent instanceof HeapPackageNode);
        this.myParent = newParent;
        this.myFullPackageName = this.myParent == null || this.myParent.getFullName().isEmpty() ? this.myPackageName : this.myParent.getFullName() + "." + this.myPackageName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapClassObjNode";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateCounts";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "classifyClassObj";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

