/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.HandleViewDebug;
import com.android.ddmlib.IDevice;
import com.android.layoutinspector.model.ClientWindow;
import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellRendererProvider;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.adtui.ptable.PTableModel;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.editors.layoutInspector.LayoutFileData;
import com.android.tools.idea.editors.layoutInspector.ptable.LITableGroupItem;
import com.android.tools.idea.editors.layoutInspector.ptable.LITableRendererProvider;
import com.android.tools.idea.editors.layoutInspector.ui.RollOverTree;
import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeActiveDisplay;
import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeTreeRenderer;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutInspectorEvent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.JBCheckboxMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Key;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutInspectorContext
implements Disposable,
DataProvider,
ViewNodeActiveDisplay.ViewNodeActiveDisplayListener,
TreeSelectionListener,
RollOverTree.TreeHoverListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final Key<ViewNode> KEY_VIEW_NODE = Key.create((String)ViewNode.class.getName());
    private static final boolean DUMP_DISPLAYLIST_ENABLED = Boolean.getBoolean("dump.displaylist.enabled");
    @Nullable
    private Client myClient;
    @Nullable
    private ClientWindow myWindow;
    private ViewNode myRoot;
    private BufferedImage myBufferedImage;
    private ViewNodeActiveDisplay myPreview;
    private final RollOverTree myNodeTree;
    private final PTableModel myTableModel;
    private final PTable myPropertiesTable;
    private final JBPopupMenu myNodePopup;
    private final JBCheckboxMenuItem myNodeVisibleMenuItem;
    private final JMenuItem myDumpDisplayListMenuItem;

    public LayoutInspectorContext(@NotNull LayoutFileData layoutParser) {
        if (layoutParser == null) {
            LayoutInspectorContext.$$$reportNull$$$0(0);
        }
        this.myRoot = layoutParser.myNode;
        this.myBufferedImage = layoutParser.myBufferedImage;
        this.myNodeTree = new RollOverTree((TreeNode)this.getRoot());
        this.myNodeTree.setCellRenderer((TreeCellRenderer)((Object)new ViewNodeTreeRenderer()));
        this.myNodeTree.addTreeSelectionListener(this);
        this.myNodeTree.addTreeHoverListener(this);
        this.myTableModel = new PTableModel();
        this.myPropertiesTable = new PTable(this.myTableModel);
        this.myPropertiesTable.getColumnModel().getColumn(0).setMinWidth((int)((double)ToolWindowDefinition.DEFAULT_SIDE_WIDTH * 0.6));
        this.myPropertiesTable.setRendererProvider((PTableCellRendererProvider)LITableRendererProvider.getInstance());
        this.myPropertiesTable.setFillsViewportHeight(true);
        this.myPropertiesTable.getTableHeader().setReorderingAllowed(false);
        TableSpeedSearch propertiesSpeedSearch = new TableSpeedSearch((JTable)this.myPropertiesTable, (object, cell) -> {
            if (object == null) {
                return null;
            }
            assert (object instanceof PTableItem) : "Items in inspector properties table expected to be a PTableItem";
            return ((PTableItem)object).getName();
        });
        propertiesSpeedSearch.setComparator(new SpeedSearchComparator(false, false));
        for (int i = 0; i < this.myNodeTree.getRowCount(); ++i) {
            TreePath path = this.myNodeTree.getPathForRow(i);
            ViewNode n = (ViewNode)path.getLastPathComponent();
            if (!n.isDrawn()) continue;
            this.myNodeTree.expandPath(path);
        }
        this.myNodeTree.setSelectionRow(0);
        this.myNodePopup = new JBPopupMenu();
        this.myNodeVisibleMenuItem = new JBCheckboxMenuItem("Show in preview");
        this.myNodeVisibleMenuItem.addActionListener((ActionListener)new ShowHidePreviewActionListener());
        this.myNodePopup.add((JMenuItem)this.myNodeVisibleMenuItem);
        if (LayoutInspectorContext.isDumpDisplayListEnabled()) {
            this.myDumpDisplayListMenuItem = new JMenuItem("Dump DisplayList");
            this.myDumpDisplayListMenuItem.addActionListener(new DumpDisplayListActionListener());
            this.myDumpDisplayListMenuItem.setEnabled(this.myClient != null && this.myWindow != null);
            this.myNodePopup.add(this.myDumpDisplayListMenuItem);
            AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        } else {
            this.myDumpDisplayListMenuItem = null;
        }
        this.myNodeTree.addMouseListener(new NodeRightClickAdapter());
    }

    @NotNull
    public RollOverTree getNodeTree() {
        RollOverTree rollOverTree = this.myNodeTree;
        if (rollOverTree == null) {
            LayoutInspectorContext.$$$reportNull$$$0(1);
        }
        return rollOverTree;
    }

    @NotNull
    public PTable getPropertiesTable() {
        PTable pTable = this.myPropertiesTable;
        if (pTable == null) {
            LayoutInspectorContext.$$$reportNull$$$0(2);
        }
        return pTable;
    }

    @NotNull
    public PTableModel getTableModel() {
        PTableModel pTableModel = this.myTableModel;
        if (pTableModel == null) {
            LayoutInspectorContext.$$$reportNull$$$0(3);
        }
        return pTableModel;
    }

    @Override
    public void onViewNodeOver(@Nullable ViewNode node) {
        if (node == null) {
            this.myNodeTree.updateHoverPath(null);
        } else {
            TreePath path = ViewNode.getPath((ViewNode)node);
            this.myNodeTree.updateHoverPath(path);
        }
    }

    @Override
    public void onNodeSelected(@NotNull ViewNode node) {
        if (node == null) {
            LayoutInspectorContext.$$$reportNull$$$0(4);
        }
        TreePath path = ViewNode.getPath((ViewNode)node);
        this.myNodeTree.scrollPathToVisible(path);
        this.myNodeTree.setSelectionPath(path);
    }

    @Override
    public void valueChanged(@NotNull TreeSelectionEvent event) {
        ViewNode selection;
        if (event == null) {
            LayoutInspectorContext.$$$reportNull$$$0(5);
        }
        if ((selection = (ViewNode)this.myNodeTree.getLastSelectedPathComponent()) != null) {
            this.myTableModel.setItems(LayoutInspectorContext.convertToItems(selection.groupedProperties));
            if (this.myPreview != null) {
                this.myPreview.setSelectedNode(selection);
            }
        }
    }

    @NotNull
    public static List<PTableItem> convertToItems(@NotNull Map<String, List<ViewProperty>> properties) {
        if (properties == null) {
            LayoutInspectorContext.$$$reportNull$$$0(6);
        }
        ArrayList<PTableItem> items = new ArrayList<PTableItem>();
        ArrayList<String> sortedKeys = new ArrayList<String>(properties.keySet());
        Collections.sort(sortedKeys, String::compareToIgnoreCase);
        for (String key : sortedKeys) {
            items.add((PTableItem)new LITableGroupItem(key, properties.get(key)));
        }
        ArrayList<PTableItem> arrayList = items;
        if (arrayList == null) {
            LayoutInspectorContext.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    public void onTreeCellHover(@Nullable TreePath path) {
        if (this.myPreview != null) {
            this.myPreview.setHoverNode(path == null ? null : (ViewNode)path.getLastPathComponent());
        }
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return null;
    }

    public ViewNode getRoot() {
        return this.myRoot;
    }

    public BufferedImage getBufferedImage() {
        return this.myBufferedImage;
    }

    public void setPreview(ViewNodeActiveDisplay preview) {
        this.myPreview = preview;
    }

    public void setSources(@Nullable Client client, @Nullable ClientWindow window) {
        this.myClient = client;
        this.myWindow = window;
        this.myDumpDisplayListMenuItem.setEnabled(this.myClient != null && this.myWindow != null);
    }

    public static boolean isDumpDisplayListEnabled() {
        return DUMP_DISPLAYLIST_ENABLED;
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
        if (this.myClient == null) {
            return;
        }
        IDevice currentDevice = this.myClient.getDevice();
        if (device.equals(currentDevice)) {
            this.setSources(null, null);
        }
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }

    private void createNotification(@NotNull String message, @NotNull NotificationType type) {
        if (message == null) {
            LayoutInspectorContext.$$$reportNull$$$0(8);
        }
        if (type == null) {
            LayoutInspectorContext.$$$reportNull$$$0(9);
        }
        Notifications.Bus.notify((Notification)new Notification(AndroidBundle.message("android.ddms.actions.layoutinspector.notification.group", new Object[0]), AndroidBundle.message("android.ddms.actions.layoutinspector.notification.title", new Object[0]), message, type, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onNodeSelected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "valueChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToItems";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DumpDisplayListActionListener
    implements ActionListener {
        private DumpDisplayListActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewNode node = (ViewNode)LayoutInspectorContext.this.myNodePopup.getClientProperty((Object)KEY_VIEW_NODE);
            if (node == null) {
                LayoutInspectorContext.this.createNotification(AndroidBundle.message("android.ddms.actions.layoutinspector.dumpdisplay.notification.nonode", new Object[0]), NotificationType.ERROR);
                return;
            }
            try {
                HandleViewDebug.dumpDisplayList((Client)LayoutInspectorContext.this.myClient, (String)((LayoutInspectorContext)LayoutInspectorContext.this).myWindow.title, (String)node.toString());
            }
            catch (IOException e1) {
                LayoutInspectorContext.this.createNotification(AndroidBundle.message("android.ddms.actions.layoutinspector.dumpdisplay.notification.failure", e1.getMessage()), NotificationType.ERROR);
                return;
            }
            LayoutInspectorContext.this.createNotification(AndroidBundle.message("android.ddms.actions.layoutinspector.dumpdisplay.notification.success", new Object[0]), NotificationType.INFORMATION);
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.LAYOUT_INSPECTOR_EVENT).setLayoutInspectorEvent(LayoutInspectorEvent.newBuilder().setType(LayoutInspectorEvent.LayoutInspectorEventType.DUMP_DISPLAYLIST)));
        }
    }

    private class ShowHidePreviewActionListener
    implements ActionListener {
        private ShowHidePreviewActionListener() {
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent event) {
            ViewNode node;
            if (event == null) {
                ShowHidePreviewActionListener.$$$reportNull$$$0(0);
            }
            if ((node = (ViewNode)LayoutInspectorContext.this.myNodePopup.getClientProperty((Object)KEY_VIEW_NODE)) == null) {
                return;
            }
            node.setForcedState(LayoutInspectorContext.this.myNodeVisibleMenuItem.getState() ? ViewNode.ForcedState.VISIBLE : ViewNode.ForcedState.INVISIBLE);
            LayoutInspectorContext.this.getRoot().updateNodeDrawn();
            if (LayoutInspectorContext.this.myPreview != null) {
                LayoutInspectorContext.this.myPreview.repaint();
            }
            LayoutInspectorContext.this.myNodeTree.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext$ShowHidePreviewActionListener", "actionPerformed"));
        }
    }

    private class NodeRightClickAdapter
    extends MouseAdapter {
        private NodeRightClickAdapter() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event == null) {
                NodeRightClickAdapter.$$$reportNull$$$0(0);
            }
            if (event.isPopupTrigger()) {
                TreePath path = LayoutInspectorContext.this.myNodeTree.getPathForEvent(event);
                if (path == null) {
                    return;
                }
                ViewNode node = (ViewNode)path.getLastPathComponent();
                if (node.isParentVisible()) {
                    LayoutInspectorContext.this.myNodeVisibleMenuItem.setEnabled(true);
                    if (node.getForcedState() == ViewNode.ForcedState.NONE) {
                        LayoutInspectorContext.this.myNodeVisibleMenuItem.setState(node.isDrawn());
                    } else {
                        LayoutInspectorContext.this.myNodeVisibleMenuItem.setState(node.getForcedState() == ViewNode.ForcedState.VISIBLE);
                    }
                } else {
                    LayoutInspectorContext.this.myNodeVisibleMenuItem.setEnabled(false);
                    LayoutInspectorContext.this.myNodeVisibleMenuItem.setState(false);
                }
                LayoutInspectorContext.this.myNodePopup.putClientProperty((Object)KEY_VIEW_NODE, (Object)node);
                LayoutInspectorContext.this.myNodePopup.show((Component)((Object)LayoutInspectorContext.this.myNodeTree), event.getX(), event.getY());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext$NodeRightClickAdapter", "mousePressed"));
        }
    }
}

