/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToDeclarationAction
extends AbstractAction {
    private final StringResourceViewPanel myPanel;
    @Nullable
    private ResourceItem myItemAtMouseClickLocation;

    public GoToDeclarationAction(@NotNull StringResourceViewPanel panel) {
        if (panel == null) {
            GoToDeclarationAction.$$$reportNull$$$0(0);
        }
        super("Go to Declaration");
        this.myPanel = panel;
    }

    public void update(@NotNull JMenuItem goTo, @NotNull MouseEvent e) {
        if (goTo == null) {
            GoToDeclarationAction.$$$reportNull$$$0(1);
        }
        if (e == null) {
            GoToDeclarationAction.$$$reportNull$$$0(2);
        }
        StringResourceTable table = this.myPanel.getTable();
        int tableRow = table.rowAtPoint(e.getPoint());
        int tableColumn = table.columnAtPoint(e.getPoint());
        if (tableRow < 0 || tableColumn < 0) {
            goTo.setVisible(false);
            return;
        }
        int row = table.convertRowIndexToModel(tableRow);
        int column = table.convertColumnIndexToModel(tableColumn);
        StringResourceTableModel model = table.getModel();
        Locale locale = model.getLocale(column);
        StringResource resource = model.getStringResourceAt(row);
        this.myItemAtMouseClickLocation = locale == null ? resource.getDefaultValueAsResourceItem() : resource.getTranslationAsResourceItem(locale);
        goTo.setVisible(this.myItemAtMouseClickLocation != null);
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        Project project = this.myPanel.getFacet().getModule().getProject();
        assert (this.myItemAtMouseClickLocation != null);
        XmlTag tag = LocalResourceRepository.getItemTag(project, this.myItemAtMouseClickLocation);
        if (tag == null) {
            return;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, tag.getContainingFile().getVirtualFile(), tag.getTextOffset());
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goTo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/strings/GoToDeclarationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

