/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceData {
    private final AndroidFacet myFacet;
    private final Map<StringResourceKey, StringResource> myKeyToResourceMap;

    public StringResourceData(@NotNull AndroidFacet facet, @NotNull Map<StringResourceKey, StringResource> keyToResourceMap) {
        if (facet == null) {
            StringResourceData.$$$reportNull$$$0(0);
        }
        if (keyToResourceMap == null) {
            StringResourceData.$$$reportNull$$$0(1);
        }
        this.myFacet = facet;
        this.myKeyToResourceMap = keyToResourceMap;
    }

    public void changeKeyName(@NotNull StringResourceKey key, @NotNull String newName) {
        ResourceItem res;
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            StringResourceData.$$$reportNull$$$0(3);
        }
        if ((res = this.getStringResource(key).getDefaultValueAsResourceItem()) == null) {
            return;
        }
        XmlTag tag = LocalResourceRepository.getItemTag(this.myFacet.getModule().getProject(), res);
        assert (tag != null);
        XmlAttribute name = tag.getAttribute("name");
        assert (name != null);
        XmlAttributeValue nameValue = name.getValueElement();
        assert (nameValue != null);
        RenameProcessor rename = new RenameProcessor(this.myFacet.getModule().getProject(), (PsiElement)nameValue, newName, false, false);
        ApplicationManager.getApplication().invokeLater((Runnable)rename);
    }

    public boolean setTranslatable(@NotNull StringResourceKey key, boolean translatable) {
        StringResource stringResource;
        ResourceItem item;
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(4);
        }
        if ((item = (stringResource = this.getStringResource(key)).getDefaultValueAsResourceItem()) != null) {
            String translatableAsString;
            if (translatable) {
                translatableAsString = null;
                stringResource.setTranslatable(true);
            } else {
                translatableAsString = "false";
                stringResource.setTranslatable(false);
            }
            return StringsWriteUtils.setAttributeForItems(this.myFacet.getModule().getProject(), "translatable", translatableAsString, Collections.singletonList(item));
        }
        return false;
    }

    @Nullable
    public String validateKey(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(5);
        }
        if (!this.myKeyToResourceMap.keySet().contains(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        StringResource stringResource = this.getStringResource(key);
        if (!stringResource.isTranslatable()) {
            Collection<Locale> localesWithTranslation = stringResource.getTranslatedLocales();
            if (!localesWithTranslation.isEmpty()) {
                return String.format("Key '%1$s' is marked as non translatable, but is translated in %2$s %3$s", key.getName(), StringUtil.pluralize((String)"locale", (int)localesWithTranslation.size()), StringResourceData.summarizeLocales(localesWithTranslation));
            }
        } else {
            if (stringResource.getDefaultValueAsResourceItem() == null) {
                return "Key '" + key.getName() + "' missing default value";
            }
            Collection<Locale> missingTranslations = this.getMissingTranslations(key);
            if (!missingTranslations.isEmpty()) {
                return String.format("Key '%1$s' has translations missing for %2$s %3$s", key.getName(), StringUtil.pluralize((String)"locale", (int)missingTranslations.size()), StringResourceData.summarizeLocales(missingTranslations));
            }
        }
        return null;
    }

    @NotNull
    Collection<Locale> getMissingTranslations(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(6);
        }
        HashSet missingTranslations = Sets.newHashSet();
        for (Locale locale : this.getLocaleSet()) {
            StringResource stringResource = this.getStringResource(key);
            if (!stringResource.isTranslationMissing(locale)) continue;
            missingTranslations.add(locale);
        }
        HashSet hashSet = missingTranslations;
        if (hashSet == null) {
            StringResourceData.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    static String summarizeLocales(@NotNull Collection<Locale> locales) {
        if (locales == null) {
            StringResourceData.$$$reportNull$$$0(8);
        }
        if (locales.isEmpty()) {
            if ("" == null) {
                StringResourceData.$$$reportNull$$$0(9);
            }
            return "";
        }
        int size = locales.size();
        if (size == 1) {
            String string = StringResourceData.getLabel((Locale)Iterables.getFirst(locales, null));
            if (string == null) {
                StringResourceData.$$$reportNull$$$0(10);
            }
            return string;
        }
        int max = 3;
        List<Locale> sorted = StringResourceData.getLowest(locales, 3);
        if (size <= 3) {
            String string = StringResourceData.getLabels(sorted.subList(0, size - 1)) + " and " + StringResourceData.getLabel(sorted.get(size - 1));
            if (string == null) {
                StringResourceData.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = String.format("%1$s and %2$d more", StringResourceData.getLabels(sorted), size - 3);
        if (string == null) {
            StringResourceData.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static List<Locale> getLowest(Collection<Locale> locales, int n) {
        return locales.stream().limit(n).sorted(Comparator.comparing(StringResourceData::getLabel)).collect(Collectors.toList());
    }

    private static String getLabels(Collection<Locale> locales) {
        return locales.stream().map(StringResourceData::getLabel).collect(Collectors.joining(", "));
    }

    private static String getLabel(@Nullable Locale locale) {
        return locale == null ? "" : LocaleMenuAction.getLocaleLabel(locale, false);
    }

    boolean containsKey(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(13);
        }
        return this.myKeyToResourceMap.containsKey(key);
    }

    @NotNull
    public StringResource getStringResource(@NotNull StringResourceKey key) {
        StringResource resource;
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(14);
        }
        if ((resource = this.myKeyToResourceMap.get(key)) == null) {
            throw new IllegalArgumentException(key.toString());
        }
        StringResource stringResource = resource;
        if (stringResource == null) {
            StringResourceData.$$$reportNull$$$0(15);
        }
        return stringResource;
    }

    @NotNull
    public Collection<StringResource> getResources() {
        Collection<StringResource> collection = this.myKeyToResourceMap.values();
        if (collection == null) {
            StringResourceData.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public List<StringResourceKey> getKeys() {
        ArrayList<StringResourceKey> arrayList = new ArrayList<StringResourceKey>(this.myKeyToResourceMap.keySet());
        if (arrayList == null) {
            StringResourceData.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public List<Locale> getLocaleList() {
        List<Locale> list = this.getTranslatedLocaleStream().distinct().sorted(Locale.LANGUAGE_NAME_COMPARATOR).collect(Collectors.toList());
        if (list == null) {
            StringResourceData.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    Set<Locale> getLocaleSet() {
        Set<Locale> set = this.getTranslatedLocaleStream().collect(Collectors.toSet());
        if (set == null) {
            StringResourceData.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    private Stream<Locale> getTranslatedLocaleStream() {
        Stream<Locale> stream = this.myKeyToResourceMap.values().stream().flatMap(resource -> resource.getTranslatedLocales().stream());
        if (stream == null) {
            StringResourceData.$$$reportNull$$$0(20);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyToResourceMap";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locales";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingTranslations";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "summarizeLocales";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringResource";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocaleList";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocaleSet";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTranslatedLocaleStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changeKeyName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTranslatable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMissingTranslations";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "summarizeLocales";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStringResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

