/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import spantable.CellSpanModel;

public class DelegatingCellEditor
implements TableCellEditor {
    private final TableCellEditor myDelegate;
    private final boolean myConvertValueToString;

    public DelegatingCellEditor(boolean convertValueToString, TableCellEditor delegate) {
        this.myConvertValueToString = convertValueToString;
        this.myDelegate = delegate;
    }

    public DelegatingCellEditor(TableCellEditor delegate) {
        this(true, delegate);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Object stringValue;
        CellSpanModel model = (CellSpanModel)table.getModel();
        boolean boldFont = false;
        if (value instanceof EditedStyleItem) {
            EditedStyleItem item = (EditedStyleItem)value;
            stringValue = ThemeEditorUtils.extractRealValue(item, model.getCellClass(row, column));
            ConfiguredThemeEditorStyle selectedStyle = ((AttributesTableModel)table.getModel()).getSelectedStyle();
            boldFont = selectedStyle.hasItem(item);
        } else {
            stringValue = value;
        }
        Component returnedComponent = this.myDelegate.getTableCellEditorComponent(table, this.myConvertValueToString ? stringValue : value, isSelected, row, column);
        returnedComponent.setFont(boldFont ? returnedComponent.getFont().deriveFont(1) : returnedComponent.getFont().deriveFont(0));
        return returnedComponent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.myDelegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.myDelegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.myDelegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.myDelegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.myDelegate.cancelCellEditing();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.myDelegate.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.myDelegate.removeCellEditorListener(l);
    }
}

