/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;

public class EditedStyleItem
implements Comparable<EditedStyleItem> {
    private static final Logger LOG = Logger.getInstance(EditedStyleItem.class);
    private static final String DEPRECATED = "deprecated";
    private final ConfiguredThemeEditorStyle mySourceTheme;
    private final ConfiguredElement<ItemResourceValue> mySelectedValue;
    private final Collection<ConfiguredElement<ItemResourceValue>> myNonSelectedValues;
    private final String myAttrGroup;

    public EditedStyleItem(@NotNull ConfiguredElement<ItemResourceValue> selectedValue, @NotNull Iterable<ConfiguredElement<ItemResourceValue>> nonSelectedValues, @NotNull ConfiguredThemeEditorStyle sourceTheme) {
        if (selectedValue == null) {
            EditedStyleItem.$$$reportNull$$$0(0);
        }
        if (nonSelectedValues == null) {
            EditedStyleItem.$$$reportNull$$$0(1);
        }
        if (sourceTheme == null) {
            EditedStyleItem.$$$reportNull$$$0(2);
        }
        this.mySourceTheme = sourceTheme;
        this.myNonSelectedValues = ImmutableList.copyOf(nonSelectedValues);
        this.mySelectedValue = selectedValue;
        AttributeDefinition attrDef = ResolutionUtils.getAttributeDefinition(sourceTheme.getConfiguration(), (ItemResourceValue)this.mySelectedValue.myValue);
        String attrGroup = attrDef == null ? null : attrDef.getAttrGroup();
        this.myAttrGroup = attrGroup == null ? "Other non-theme attributes." : attrGroup;
    }

    public EditedStyleItem(@NotNull ConfiguredElement<ItemResourceValue> selectedValue, @NotNull ConfiguredThemeEditorStyle sourceTheme) {
        if (selectedValue == null) {
            EditedStyleItem.$$$reportNull$$$0(3);
        }
        if (sourceTheme == null) {
            EditedStyleItem.$$$reportNull$$$0(4);
        }
        this(selectedValue, Collections.emptyList(), sourceTheme);
    }

    public ItemResourceValue getSelectedValue() {
        return (ItemResourceValue)this.mySelectedValue.myValue;
    }

    @NotNull
    public String getAttrGroup() {
        String string = this.myAttrGroup;
        if (string == null) {
            EditedStyleItem.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getValue() {
        String string = ResolutionUtils.getQualifiedValue(this.getSelectedValue());
        if (string == null) {
            EditedStyleItem.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getSelectedValue().getName();
        if (string == null) {
            EditedStyleItem.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isFrameworkAttr() {
        return this.getSelectedValue().isFrameworkAttr();
    }

    @NotNull
    public ConfiguredThemeEditorStyle getSourceStyle() {
        ConfiguredThemeEditorStyle configuredThemeEditorStyle = this.mySourceTheme;
        if (configuredThemeEditorStyle == null) {
            EditedStyleItem.$$$reportNull$$$0(8);
        }
        return configuredThemeEditorStyle;
    }

    @NotNull
    public FolderConfiguration getSelectedValueConfiguration() {
        FolderConfiguration folderConfiguration = this.mySelectedValue.getConfiguration();
        if (folderConfiguration == null) {
            EditedStyleItem.$$$reportNull$$$0(9);
        }
        return folderConfiguration;
    }

    @NotNull
    public ConfiguredElement<ItemResourceValue> getSelectedItemResourceValue() {
        ConfiguredElement<ItemResourceValue> configuredElement = this.mySelectedValue;
        if (configuredElement == null) {
            EditedStyleItem.$$$reportNull$$$0(10);
        }
        return configuredElement;
    }

    @NotNull
    public Collection<ConfiguredElement<ItemResourceValue>> getAllConfiguredItems() {
        ImmutableList immutableList = ImmutableList.builder().add(this.mySelectedValue).addAll(this.getNonSelectedItemResourceValues()).build();
        if (immutableList == null) {
            EditedStyleItem.$$$reportNull$$$0(11);
        }
        return immutableList;
    }

    @NotNull
    public Collection<ConfiguredElement<ItemResourceValue>> getNonSelectedItemResourceValues() {
        Collection<ConfiguredElement<ItemResourceValue>> collection = this.myNonSelectedValues;
        if (collection == null) {
            EditedStyleItem.$$$reportNull$$$0(12);
        }
        return collection;
    }

    public boolean isAttr() {
        ResourceUrl url = ResourceUrl.parse((String)this.getSelectedValue().getRawXmlValue(), (boolean)this.getSelectedValue().isFramework());
        return url != null && url.type == ResourceType.ATTR;
    }

    public String toString() {
        StringBuilder output = new StringBuilder(String.format("[%1$s] %2$s = %3$s (%4$s)", this.mySourceTheme, this.getName(), this.getValue(), this.mySelectedValue.myFolderConfiguration));
        for (ConfiguredElement<ItemResourceValue> item : this.myNonSelectedValues) {
            output.append('\n').append(String.format("   %1$s = %2$s (%3$s)", ((ItemResourceValue)item.myValue).getName(), ((ItemResourceValue)item.myValue).getValue(), item.getConfiguration()));
        }
        return output.toString();
    }

    @NotNull
    public String getQualifiedName() {
        String string = ResolutionUtils.getQualifiedItemName(this.getSelectedValue());
        if (string == null) {
            EditedStyleItem.$$$reportNull$$$0(13);
        }
        return string;
    }

    public String getAttrPropertyName() {
        if (!this.isAttr()) {
            return "";
        }
        String propertyName = (String)Splitter.on((char)'/').limit(2).splitToList((CharSequence)this.getValue()).get(1);
        return (this.getValue().startsWith("?android:") ? "android:" : "") + propertyName;
    }

    public boolean isDeprecated() {
        AttributeDefinition def = ResolutionUtils.getAttributeDefinition(this.mySourceTheme.getConfiguration(), this.getSelectedValue());
        String doc = def == null ? null : def.getDocValue(null);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)DEPRECATED);
    }

    public boolean isPublicAttribute() {
        if (!this.getSelectedValue().isFrameworkAttr()) {
            return true;
        }
        Configuration configuration = this.mySourceTheme.getConfiguration();
        IAndroidTarget target = configuration.getRealTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, configuration.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.ATTR.getName(), this.getName());
    }

    @Override
    public int compareTo(EditedStyleItem that) {
        return this.getName().compareTo(that.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonSelectedValues";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTheme";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttrGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceStyle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedValueConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItemResourceValue";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConfiguredItems";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonSelectedItemResourceValues";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

