/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.explorer.DeviceExplorerView;
import com.android.tools.idea.explorer.DeviceExplorerViewProgressListener;
import com.intellij.openapi.Disposable;
import org.jetbrains.annotations.NotNull;

abstract class LongRunningOperationTracker
implements Disposable {
    @NotNull
    private DeviceExplorerView myView;
    @NotNull
    private final DeviceExplorerViewProgressListener myProgressListener;
    private boolean myIsCancelled;
    private long myStartNanoTime;

    public LongRunningOperationTracker(@NotNull DeviceExplorerView view) {
        if (view == null) {
            LongRunningOperationTracker.$$$reportNull$$$0(0);
        }
        this.myView = view;
        this.myProgressListener = () -> {
            this.myIsCancelled = true;
        };
    }

    public void cancel() {
        this.myIsCancelled = true;
    }

    public boolean isCancelled() {
        return this.myIsCancelled;
    }

    public long getDurationMillis() {
        return (System.nanoTime() - this.myStartNanoTime) / 1000000L;
    }

    public void start() {
        this.myView.addProgressListener(this.myProgressListener);
        this.myView.startProgress();
        this.myStartNanoTime = System.nanoTime();
        this.myIsCancelled = false;
    }

    public void stop() {
        this.myView.removeProgressListener(this.myProgressListener);
        this.myView.stopProgress();
    }

    public void dispose() {
        this.stop();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.myView.setProgressIndeterminate(indeterminate);
    }

    public void setProgress(double fraction) {
        this.myView.setProgressValue(fraction);
    }

    public void setStatusText(@NotNull String text) {
        if (text == null) {
            LongRunningOperationTracker.$$$reportNull$$$0(1);
        }
        this.myView.setProgressText(text);
    }

    public void setWarningColor() {
        this.myView.setProgressWarningColor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/explorer/LongRunningOperationTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setStatusText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

