/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.values;

import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.GradleResolvedVariable;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public abstract class GradleValue<T> {
    @Nullable
    private final GradleDslElement myDslElement;
    @Nullable
    private final T myValue;

    protected GradleValue(@Nullable GradleDslElement dslElement, @Nullable T value) {
        this.myDslElement = dslElement;
        this.myValue = value;
    }

    @Nullable
    public T value() {
        return this.myValue;
    }

    @Nullable
    public GroovyPsiElement getPsiElement() {
        if (this.myDslElement == null) {
            return null;
        }
        return this.myDslElement instanceof GradleDslExpression ? ((GradleDslExpression)this.myDslElement).getExpression() : this.myDslElement.getPsiElement();
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myDslElement != null ? this.myDslElement.getDslFile().getFile() : null;
    }

    @Nullable
    public String getPropertyName() {
        return this.myDslElement != null ? this.myDslElement.getQualifiedName() : null;
    }

    @Nullable
    public String getDslText() {
        GroovyPsiElement psiElement = this.getPsiElement();
        return psiElement != null ? psiElement.getText() : null;
    }

    @NotNull
    public Map<String, GradleNotNullValue<Object>> getResolvedVariables() {
        if (this.myDslElement == null) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                GradleValue.$$$reportNull$$$0(0);
            }
            return immutableMap;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (GradleResolvedVariable variable : this.myDslElement.getResolvedVariables()) {
            String variableName = variable.getVariableName();
            Object resolvedValue = variable.getValue();
            GradleDslElement element = variable.getElement();
            builder.put((Object)variableName, new GradleNotNullValue<Object>(element, resolvedValue));
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            GradleValue.$$$reportNull$$$0(1);
        }
        return immutableMap;
    }

    @NotNull
    public static <E> List<E> getValues(@Nullable List<? extends GradleValue<E>> gradleValues) {
        if (gradleValues == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradleValue.$$$reportNull$$$0(2);
            }
            return immutableList;
        }
        ArrayList<E> values = new ArrayList<E>(gradleValues.size());
        for (GradleValue<E> gradleValue : gradleValues) {
            E value = gradleValue.value();
            if (value == null) continue;
            values.add(value);
        }
        ArrayList<E> arrayList = values;
        if (arrayList == null) {
            GradleValue.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static <V> Map<String, V> getValues(@Nullable Map<String, ? extends GradleValue<V>> gradleValues) {
        if (gradleValues == null) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                GradleValue.$$$reportNull$$$0(4);
            }
            return immutableMap;
        }
        LinkedHashMap values = new LinkedHashMap();
        for (Map.Entry<String, GradleValue<V>> gradleValueEntry : gradleValues.entrySet()) {
            V value = gradleValueEntry.getValue().value();
            if (value == null) continue;
            values.put(gradleValueEntry.getKey(), value);
        }
        LinkedHashMap linkedHashMap = values;
        if (linkedHashMap == null) {
            GradleValue.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/gradle/dsl/model/values/GradleValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedVariables";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

