/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.tools.idea.gradle.project.model.ide.android.IdeFilterData;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeOutputFile
extends IdeModel
implements OutputFile {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myOutputType;
    @NotNull
    private final Collection<String> myFilterTypes;
    @NotNull
    private final Collection<FilterData> myFilters;
    @NotNull
    private final File myOutputFile;
    @NotNull
    private final Collection<? extends OutputFile> myOutputs;
    @Nullable
    private final OutputFile myMainOutputFile;
    @Nullable
    final Integer myVersionCode;
    private final int myHashCode;

    public IdeOutputFile(@NotNull OutputFile file, @NotNull ModelCache modelCache) {
        if (file == null) {
            IdeOutputFile.$$$reportNull$$$0(0);
        }
        if (modelCache == null) {
            IdeOutputFile.$$$reportNull$$$0(1);
        }
        super(file, modelCache);
        this.myOutputType = file.getOutputType();
        this.myFilterTypes = ImmutableList.copyOf((Collection)file.getFilterTypes());
        this.myFilters = IdeOutputFile.copy(file.getFilters(), modelCache, (K data) -> {
            if (modelCache == null) {
                IdeOutputFile.$$$reportNull$$$0(21);
            }
            return new IdeFilterData((FilterData)data, modelCache);
        });
        this.myOutputFile = file.getOutputFile();
        this.myMainOutputFile = IdeOutputFile.copyNewProperty(modelCache, () -> ((OutputFile)file).getMainOutputFile(), outputFile -> {
            if (modelCache == null) {
                IdeOutputFile.$$$reportNull$$$0(20);
            }
            return new IdeOutputFile((OutputFile)outputFile, modelCache);
        }, null);
        this.myOutputs = IdeOutputFile.copyOutputs(file, modelCache);
        this.myVersionCode = IdeOutputFile.copyNewProperty(() -> ((OutputFile)file).getVersionCode(), null);
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    private static Collection<? extends OutputFile> copyOutputs(@NotNull OutputFile file, @NotNull ModelCache modelCache) {
        List<OutputFile> list;
        if (file == null) {
            IdeOutputFile.$$$reportNull$$$0(2);
        }
        if (modelCache == null) {
            IdeOutputFile.$$$reportNull$$$0(3);
        }
        try {
            Collection key = file.getOutputs();
            list = IdeOutputFile.copy(key, modelCache, (K outputFile) -> {
                if (modelCache == null) {
                    IdeOutputFile.$$$reportNull$$$0(19);
                }
                return new IdeOutputFile((OutputFile)outputFile, modelCache);
            });
        }
        catch (UnsupportedMethodException ignored) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                IdeOutputFile.$$$reportNull$$$0(5);
            }
            return list2;
        }
        if (list == null) {
            IdeOutputFile.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public String getOutputType() {
        String string = this.myOutputType;
        if (string == null) {
            IdeOutputFile.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public Collection<String> getFilterTypes() {
        Collection<String> collection = this.myFilterTypes;
        if (collection == null) {
            IdeOutputFile.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public Collection<FilterData> getFilters() {
        Collection<FilterData> collection = this.myFilters;
        if (collection == null) {
            IdeOutputFile.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public File getOutputFile() {
        File file = this.myOutputFile;
        if (file == null) {
            IdeOutputFile.$$$reportNull$$$0(9);
        }
        return file;
    }

    @NotNull
    public OutputFile getMainOutputFile() {
        if (this.myMainOutputFile != null) {
            OutputFile outputFile = this.myMainOutputFile;
            if (outputFile == null) {
                IdeOutputFile.$$$reportNull$$$0(10);
            }
            return outputFile;
        }
        throw new UnsupportedMethodException("getMainOutputFile()");
    }

    @NotNull
    public Collection<? extends OutputFile> getOutputs() {
        Collection<? extends OutputFile> collection = this.myOutputs;
        if (collection == null) {
            IdeOutputFile.$$$reportNull$$$0(11);
        }
        return collection;
    }

    public int getVersionCode() {
        if (this.myVersionCode != null) {
            return this.myVersionCode;
        }
        throw new UnsupportedMethodException("getVersionCode");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeOutputFile)) {
            return false;
        }
        IdeOutputFile file = (IdeOutputFile)o;
        return Objects.equals(this.myVersionCode, file.myVersionCode) && Objects.equals(this.myOutputType, file.myOutputType) && Objects.equals(this.myFilterTypes, file.myFilterTypes) && Objects.equals(this.myFilters, file.myFilters) && Objects.equals(this.myOutputFile, file.myOutputFile) && Objects.equals(this.myOutputs, file.myOutputs) && this.mainOutputFileEquals(file);
    }

    private boolean mainOutputFileEquals(@NotNull IdeOutputFile file) {
        if (file == null) {
            IdeOutputFile.$$$reportNull$$$0(12);
        }
        return this.myMainOutputFile == this ? file.myMainOutputFile == file : Objects.equals(this.myMainOutputFile, file.myMainOutputFile);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        int result = this.myOutputType.hashCode();
        result = 31 * result + this.myFilterTypes.hashCode();
        result = 31 * result + this.myFilters.hashCode();
        result = 31 * result + FileUtil.fileHashCode((File)this.myOutputFile);
        result = 31 * result + this.hashCode(this.myMainOutputFile);
        result = 31 * result + this.hashCode(this.myOutputs);
        result = 31 * result + Objects.hashCode(this.myVersionCode);
        return result;
    }

    private int hashCode(@NotNull Collection<? extends OutputFile> outputFiles) {
        if (outputFiles == null) {
            IdeOutputFile.$$$reportNull$$$0(13);
        }
        int hashCode = 1;
        for (OutputFile outputFile : outputFiles) {
            hashCode = 31 * hashCode + this.hashCode(outputFile);
        }
        return hashCode;
    }

    private int hashCode(@Nullable OutputFile outputFile) {
        return outputFile != this ? Objects.hashCode(outputFile) : 1;
    }

    public String toString() {
        return "IdeOutputFile{myOutputType='" + this.myOutputType + '\'' + ", myFilterTypes=" + this.myFilterTypes + ", myFilters=" + this.myFilters + ", myOutputFile=" + this.myOutputFile + ", myMainOutputFile=" + this.toString(this.myMainOutputFile) + ", myOutputs=" + this.toString(this.myOutputs) + ", myVersionCode=" + this.myVersionCode + "}";
    }

    @NotNull
    private String toString(@NotNull Collection<? extends OutputFile> outputFiles) {
        int max;
        if (outputFiles == null) {
            IdeOutputFile.$$$reportNull$$$0(14);
        }
        if ((max = outputFiles.size() - 1) == -1) {
            if ("[]" == null) {
                IdeOutputFile.$$$reportNull$$$0(15);
            }
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        for (OutputFile outputFile : outputFiles) {
            b.append(this.toString(outputFile));
            if (i++ == max) {
                b.append(']');
                break;
            }
            b.append(", ");
        }
        String string = b.toString();
        if (string == null) {
            IdeOutputFile.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private String toString(@Nullable OutputFile outputFile) {
        if (outputFile == this) {
            if ("this" == null) {
                IdeOutputFile.$$$reportNull$$$0(17);
            }
            return "this";
        }
        String string = Objects.toString(outputFile);
        if (string == null) {
            IdeOutputFile.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelCache";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/ide/android/IdeOutputFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/ide/android/IdeOutputFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyOutputs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterTypes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainOutputFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputs";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyOutputs";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mainOutputFileEquals";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hashCode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyOutputs$2";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

