/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaSyncPopulateProjectTask {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostSyncProjectSetup myProjectSetup;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final ProjectDataManager myDataManager;

    public IdeaSyncPopulateProjectTask(@NotNull Project project) {
        if (project == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(0);
        }
        this(project, PostSyncProjectSetup.getInstance(project), GradleSyncState.getInstance(project), ProjectDataManager.getInstance());
    }

    @VisibleForTesting
    IdeaSyncPopulateProjectTask(@NotNull Project project, @NotNull PostSyncProjectSetup projectSetup, @NotNull GradleSyncState syncState, @NotNull ProjectDataManager dataManager) {
        if (project == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(1);
        }
        if (projectSetup == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(2);
        }
        if (syncState == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(3);
        }
        if (dataManager == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myProjectSetup = projectSetup;
        this.mySyncState = syncState;
        this.myDataManager = dataManager;
    }

    public void populateProject(@NotNull DataNode<ProjectData> projectInfo) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(5);
        }
        this.populateProject(projectInfo, null, null, false);
    }

    public void populateProject(@NotNull DataNode<ProjectData> projectInfo, @Nullable PostSyncProjectSetup.Request setupRequest, @Nullable Runnable syncFinishedCallback, boolean allowModuleSelection) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(6);
        }
        Collection<DataNode<ModuleData>> activeModules = this.getActiveModules(projectInfo, allowModuleSelection);
        this.populateProject(projectInfo, activeModules, setupRequest, syncFinishedCallback);
    }

    @NotNull
    private Collection<DataNode<ModuleData>> getActiveModules(@NotNull DataNode<ProjectData> projectInfo, boolean allowModuleSelection) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(7);
        }
        Collection modules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        ProjectSubset subview = ProjectSubset.getInstance(this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode() && ProjectSubset.getInstance(this.myProject).isFeatureEnabled() && modules.size() > 1) {
            if (allowModuleSelection) {
                Collection<DataNode<ModuleData>> selection = subview.showModuleSelectionDialog(modules);
                if (selection != null) {
                    Collection<DataNode<ModuleData>> collection = selection;
                    if (collection == null) {
                        IdeaSyncPopulateProjectTask.$$$reportNull$$$0(8);
                    }
                    return collection;
                }
            } else {
                int moduleCount;
                Object[] persistedModuleNames = subview.getSelection();
                if (persistedModuleNames != null && (moduleCount = persistedModuleNames.length) > 0) {
                    ArrayList moduleNames = Lists.newArrayList((Object[])persistedModuleNames);
                    ArrayList selectedModules = Lists.newArrayListWithExpectedSize((int)moduleCount);
                    for (DataNode module : modules) {
                        String name = ((ModuleData)module.getData()).getExternalName();
                        if (!moduleNames.contains(name)) continue;
                        selectedModules.add(module);
                    }
                    ArrayList arrayList = selectedModules;
                    if (arrayList == null) {
                        IdeaSyncPopulateProjectTask.$$$reportNull$$$0(9);
                    }
                    return arrayList;
                }
            }
        }
        subview.clearSelection();
        Collection collection = modules;
        if (collection == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(10);
        }
        return collection;
    }

    public void populateProject(@NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> activeModules, @Nullable PostSyncProjectSetup.Request setupRequest) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(11);
        }
        if (activeModules == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(12);
        }
        this.populateProject(projectInfo, activeModules, setupRequest, null);
    }

    public void populateProject(final @NotNull DataNode<ProjectData> projectInfo, final @NotNull Collection<DataNode<ModuleData>> activeModules, final @Nullable PostSyncProjectSetup.Request setupRequest, final @Nullable Runnable syncFinishedCallback) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(13);
        }
        if (activeModules == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(14);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> GradleSyncMessages.getInstance(this.myProject).removeProjectMessages());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.populate(projectInfo, activeModules, (ProgressIndicator)new EmptyProgressIndicator(), setupRequest, syncFinishedCallback);
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Project Setup", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeaSyncPopulateProjectTask.this.populate((DataNode<ProjectData>)projectInfo, activeModules, indicator, setupRequest, syncFinishedCallback);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/idea/IdeaSyncPopulateProjectTask$1", "run"));
            }
        };
        task.queue();
    }

    private void populate(@NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> activeModules, @NotNull ProgressIndicator indicator, @Nullable PostSyncProjectSetup.Request setupRequest, @Nullable Runnable syncFinishedCallback) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(15);
        }
        if (activeModules == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(17);
        }
        IdeaSyncPopulateProjectTask.disableExcludedModules(projectInfo, activeModules);
        this.doSelectiveImport(activeModules, this.myProject, setupRequest);
        if (syncFinishedCallback != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                syncFinishedCallback.run();
            } else {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, syncFinishedCallback);
            }
        }
        if (setupRequest != null) {
            PostSyncProjectSetup.getInstance(this.myProject).setUpProject(setupRequest, indicator);
        }
    }

    private static void disableExcludedModules(@NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> activeModules) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(18);
        }
        if (activeModules == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(19);
        }
        Collection allModules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        if (activeModules.size() != allModules.size()) {
            HashSet moduleToIgnore = Sets.newHashSet((Iterable)allModules);
            moduleToIgnore.removeAll(activeModules);
            for (DataNode moduleNode : moduleToIgnore) {
                ExternalSystemApiUtil.visit((DataNode)moduleNode, node -> node.setIgnored(true));
            }
        }
    }

    @VisibleForTesting
    void doSelectiveImport(@NotNull Collection<DataNode<ModuleData>> activeModules, @NotNull Project project, @Nullable PostSyncProjectSetup.Request setupRequest) {
        if (activeModules == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(20);
        }
        if (project == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(21);
        }
        DataNode projectNode = activeModules.isEmpty() ? null : ExternalSystemApiUtil.findParent(activeModules.iterator().next(), (Key)ProjectKeys.PROJECT);
        try {
            if (projectNode != null) {
                Collection allModules = ExternalSystemApiUtil.findAll((DataNode)projectNode, (Key)ProjectKeys.MODULE);
                if (activeModules.size() != allModules.size()) {
                    THashSet moduleToIgnore = ContainerUtil.newIdentityTroveSet((Collection)allModules);
                    moduleToIgnore.removeAll(activeModules);
                    for (DataNode moduleNode : moduleToIgnore) {
                        ExternalSystemApiUtil.visit((DataNode)moduleNode, node -> node.setIgnored(true));
                    }
                }
                this.myDataManager.importData(projectNode, project, true);
            } else {
                this.myDataManager.importData(activeModules, project, true);
            }
        }
        catch (RuntimeException unexpected) {
            String message = ExceptionUtil.getRootCause((Throwable)unexpected).getMessage();
            Logger.getInstance(this.getClass()).warn("Sync failed: " + message, (Throwable)unexpected);
            if (setupRequest != null && setupRequest.isUsingCachedGradleModels()) {
                this.myProjectSetup.onCachedModelsSetupFailure(setupRequest);
                return;
            }
            this.mySyncState.syncFailed(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSetup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/IdeaSyncPopulateProjectTask";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeModules";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/IdeaSyncPopulateProjectTask";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "populateProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActiveModules";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "disableExcludedModules";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doSelectiveImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

