/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.common;

import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.project.sync.idea.data.DataNodeCaches;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.common.CommonProjectValidationStrategy;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class UniquePathModuleValidatorStrategy
extends CommonProjectValidationStrategy {
    @NotNull
    private final Multimap<String, Module> myModulesByPath;

    UniquePathModuleValidatorStrategy(@NotNull Project project) {
        if (project == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(0);
        }
        super(project);
        this.myModulesByPath = HashMultimap.create();
    }

    @Override
    void validate(@NotNull Module module) {
        if (module == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(1);
        }
        if (!Projects.isIdeaAndroidModule(module)) {
            return;
        }
        File moduleFolderPath = Projects.findModuleRootFolderPath(module);
        if (moduleFolderPath != null) {
            this.myModulesByPath.put((Object)moduleFolderPath.getPath(), (Object)module);
        }
    }

    @Override
    void fixAndReportFoundIssues() {
        Set modulePaths = this.myModulesByPath.keySet();
        for (String modulePath : modulePaths) {
            DataNode<ProjectData> projectInfo;
            ArrayList<Module> modules = new ArrayList<Module>(this.myModulesByPath.get((Object)modulePath));
            modules.sort(Comparator.comparing(Module::getName));
            int moduleCount = modules.size();
            if (moduleCount <= 1) continue;
            StringBuilder msg = new StringBuilder();
            msg.append("The modules [");
            int i = 0;
            HashSet<String> moduleNames = new HashSet<String>();
            for (Module module : modules) {
                if (i++ != 0) {
                    msg.append(", ");
                }
                String name = module.getName();
                moduleNames.add(name);
                msg.append("'").append(name).append("'");
            }
            msg.append("] point to the same directory in the file system.");
            String[] lines = new String[]{msg.toString(), "Each module must have a unique path."};
            SyncMessage message = new SyncMessage("Project Structure Issues", MessageType.ERROR, lines);
            ArrayList modulesToDisplayInDialog = Lists.newArrayList();
            Project project = this.getProject();
            if (ProjectSubset.getInstance(project).isFeatureEnabled() && (projectInfo = DataNodeCaches.getInstance(project).getCachedProjectData()) != null) {
                Collection cachedModules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
                for (DataNode moduleNode : cachedModules) {
                    if (!moduleNames.contains(((ModuleData)moduleNode.getData()).getExternalName())) continue;
                    modulesToDisplayInDialog.add(moduleNode);
                }
            }
            if (!modulesToDisplayInDialog.isEmpty()) {
                message.add(new AddOrRemoveModulesHyperlink());
            }
            GradleSyncMessages.getInstance(project).report(message);
        }
    }

    @VisibleForTesting
    @NotNull
    Multimap<String, Module> getModulesByPath() {
        Multimap<String, Module> multimap = this.myModulesByPath;
        if (multimap == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(2);
        }
        return multimap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/validation/common/UniquePathModuleValidatorStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/validation/common/UniquePathModuleValidatorStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddOrRemoveModulesHyperlink
    extends NotificationHyperlink {
        AddOrRemoveModulesHyperlink() {
            super("add.or.remove.modules", "Configure Project Subset");
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                AddOrRemoveModulesHyperlink.$$$reportNull$$$0(0);
            }
            ProjectSubset subset = ProjectSubset.getInstance(project);
            subset.addOrRemoveModules();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/validation/common/UniquePathModuleValidatorStrategy$AddOrRemoveModulesHyperlink", "execute"));
        }
    }
}

