/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.resolve;

import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class AndroidDslContributor
implements GradleMethodContextContributor {
    @NonNls
    private static final String DSL_ANDROID = "android";
    @NonNls
    private static final String ANDROID_FQCN = "com.android.build.gradle.AppExtension";
    @NonNls
    private static final String ANDROID_LIB_FQCN = "com.android.build.gradle.LibraryExtension";
    private static final Key<PsiElement> CONTRIBUTOR_KEY = Key.create((String)"AndroidDslContributor.key");
    private static final Map<String, String> ourDslForClassMap = ImmutableMap.of((Object)"com.android.builder.DefaultProductFlavor", (Object)"com.android.build.gradle.internal.dsl.ProductFlavorDsl", (Object)"com.android.builder.DefaultBuildType", (Object)"com.android.build.gradle.internal.dsl.BuildTypeDsl", (Object)"com.android.builder.model.SigningConfig", (Object)"com.android.build.gradle.internal.dsl.SigningConfigDsl");

    public boolean process(@NotNull List<String> callStack, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        String topLevel;
        if (callStack == null) {
            AndroidDslContributor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            AndroidDslContributor.$$$reportNull$$$0(1);
        }
        if (state == null) {
            AndroidDslContributor.$$$reportNull$$$0(2);
        }
        if (place == null) {
            AndroidDslContributor.$$$reportNull$$$0(3);
        }
        if (!DSL_ANDROID.equals(topLevel = (String)ContainerUtil.getLastItem(callStack, null))) {
            return true;
        }
        if (callStack.size() == 1) {
            PsiClass contributorClass;
            String fqcn = AndroidDslContributor.resolveAndroidExtension(place.getContainingFile());
            PsiClass psiClass = contributorClass = fqcn == null ? null : AndroidDslContributor.findClassByName(place.getProject(), place.getResolveScope(), fqcn);
            if (contributorClass != null) {
                String qualifiedName = contributorClass.getQualifiedName();
                if (qualifiedName == null) {
                    qualifiedName = fqcn;
                }
                AndroidDslContributor.resolveToMethodWithClosure(place, (PsiElement)contributorClass, qualifiedName, processor, state);
                AndroidDslContributor.cacheContributorInfo(place, (PsiElement)contributorClass);
            }
            return true;
        }
        PsiElement parentContributor = AndroidDslContributor.getParentContributor(place);
        if (parentContributor == null) {
            return true;
        }
        if (parentContributor instanceof PsiClass) {
            PsiMethod method = AndroidDslContributor.findAndProcessContributingMethod(callStack.get(0), processor, state, place, (PsiClass)parentContributor);
            AndroidDslContributor.cacheContributorInfo(place, (PsiElement)method);
            return true;
        }
        if (!(parentContributor instanceof PsiMethod)) {
            return true;
        }
        ParametrizedTypeExtractor typeExtractor = AndroidDslContributor.getTypeExtractor((PsiMethod)parentContributor);
        if (typeExtractor == null) {
            Logger.getInstance(AndroidDslContributor.class).info("inside the closure of a method, but unable to extract the closure parameter's type.");
            return true;
        }
        if (typeExtractor.hasNamedDomainObjectContainer()) {
            String namedDomainObject = typeExtractor.getNamedDomainObject();
            assert (namedDomainObject != null) : typeExtractor.getCanonicalType();
            PsiClass contributorClass = AndroidDslContributor.findClassByName(place.getProject(), place.getResolveScope(), namedDomainObject);
            if (contributorClass != null) {
                String qualifiedName = contributorClass.getQualifiedName();
                if (qualifiedName == null) {
                    qualifiedName = namedDomainObject;
                }
                AndroidDslContributor.resolveToMethodWithClosure(place, (PsiElement)contributorClass, qualifiedName, processor, state);
                AndroidDslContributor.cacheContributorInfo(place, (PsiElement)contributorClass);
            }
            return true;
        }
        if (typeExtractor.isClosure()) {
            String clz = typeExtractor.getClosureType();
            assert (clz != null) : typeExtractor.getCanonicalType();
            PsiClass contributorClass = AndroidDslContributor.findClassByName(place.getProject(), place.getResolveScope(), clz);
            if (contributorClass == null) {
                return true;
            }
            PsiMethod method = AndroidDslContributor.findAndProcessContributingMethod(callStack.get(0), processor, state, place, contributorClass);
            AndroidDslContributor.cacheContributorInfo(place, (PsiElement)method);
        }
        return true;
    }

    private static void resolveToMethodWithClosure(PsiElement place, PsiElement resolveToElement, String closureTypeFqcn, PsiScopeProcessor processor, ResolveState state) {
        if (place.getParent() instanceof GrMethodCallExpression) {
            GrLightMethodBuilder methodWithClosure = GradleResolverUtil.createMethodWithClosure((String)place.getText(), (String)closureTypeFqcn, null, (PsiElement)place);
            if (methodWithClosure != null) {
                processor.execute((PsiElement)methodWithClosure, state);
                methodWithClosure.setNavigationElement(resolveToElement);
            }
        } else if (place.getParent() instanceof GrReferenceExpression) {
            GrLightVariable variable = new GrLightVariable(place.getManager(), place.getText(), closureTypeFqcn, place);
            processor.execute((PsiElement)variable, state);
        }
    }

    @Nullable
    private static PsiMethod findAndProcessContributingMethod(String symbol, PsiScopeProcessor processor, ResolveState state, PsiElement place, PsiClass contributorClass) {
        PsiMethod method = AndroidDslContributor.getContributingMethod(place, contributorClass, symbol);
        if (method == null) {
            return null;
        }
        ParametrizedTypeExtractor typeExtractor = AndroidDslContributor.getTypeExtractor(method);
        if (typeExtractor != null && !typeExtractor.hasNamedDomainObjectContainer() && typeExtractor.isClosure()) {
            String clz = typeExtractor.getClosureType();
            if (clz == null) {
                clz = "java.lang.Object";
            }
            if (ourDslForClassMap.containsKey(clz)) {
                clz = ourDslForClassMap.get(clz);
            }
            AndroidDslContributor.resolveToMethodWithClosure(place, (PsiElement)method, clz, processor, state);
        } else {
            GrLightMethodBuilder builder = new GrLightMethodBuilder(place.getManager(), method.getName());
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getManager().getProject());
            PsiArrayType type = new PsiArrayType((PsiType)factory.createTypeByFQClassName("java.lang.Object", place.getResolveScope()));
            builder.addParameter((GrParameter)new GrLightParameter("param", (PsiType)type, (PsiElement)builder));
            PsiClassType retType = factory.createTypeByFQClassName("java.lang.Object", place.getResolveScope());
            builder.setReturnType((PsiType)retType);
            processor.execute((PsiElement)builder, state);
            builder.setNavigationElement((PsiElement)method);
        }
        return method;
    }

    @Nullable
    private static PsiMethod getContributingMethod(PsiElement place, PsiClass contributorClass, String methodName) {
        PsiMethod[] methodsByName;
        GrMethodCall call = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethodCall.class);
        if (call == null) {
            return null;
        }
        GrArgumentList args = call.getArgumentList();
        int argsCount = GradleResolverUtil.getGrMethodArumentsCount((GrArgumentList)args);
        for (PsiMethod method : methodsByName = AndroidDslContributor.findMethodByName(contributorClass, methodName)) {
            if (method.getParameterList().getParametersCount() != argsCount) continue;
            return method;
        }
        return methodsByName.length > 0 ? methodsByName[0] : null;
    }

    @NotNull
    private static PsiMethod[] findMethodByName(PsiClass contributorClass, String methodName) {
        List<String> possibleMethods = Arrays.asList(methodName, GroovyPropertyUtils.getSetterName((String)methodName), GroovyPropertyUtils.getGetterNameNonBoolean((String)methodName), GroovyPropertyUtils.getGetterNameBoolean((String)methodName));
        for (String possibleMethod : possibleMethods) {
            PsiMethod[] methods = contributorClass.findMethodsByName(possibleMethod, true);
            if (methods.length <= 0) continue;
            if (methods == null) {
                AndroidDslContributor.$$$reportNull$$$0(4);
            }
            return methods;
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            AndroidDslContributor.$$$reportNull$$$0(5);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @Nullable
    private static ParametrizedTypeExtractor getTypeExtractor(PsiMethod parentContributor) {
        PsiParameter[] parameters = parentContributor.getParameterList().getParameters();
        if (parameters.length < 1) {
            return null;
        }
        PsiParameter param = parameters[parameters.length - 1];
        String parameterType = param.getType().getCanonicalText();
        return new ParametrizedTypeExtractor(parameterType);
    }

    @Nullable
    private static PsiElement getParentContributor(PsiElement place) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GrClosableBlock closeableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)place, GrClosableBlock.class);
        if (closeableBlock == null || !(closeableBlock.getParent() instanceof GrMethodCall)) {
            return null;
        }
        PsiElement parentContributor = (PsiElement)closeableBlock.getParent().getUserData(CONTRIBUTOR_KEY);
        if (parentContributor == null) {
            return null;
        }
        return parentContributor;
    }

    @Nullable
    public static PsiClass findClassByName(Project project, GlobalSearchScope resolveScope, @NotNull String fqcn) {
        if (fqcn == null) {
            AndroidDslContributor.$$$reportNull$$$0(6);
        }
        if (ourDslForClassMap.containsKey(fqcn)) {
            fqcn = ourDslForClassMap.get(fqcn);
        }
        return JavaPsiFacade.getInstance((Project)project).findClass(fqcn, resolveScope);
    }

    private static void cacheContributorInfo(@NotNull PsiElement place, @Nullable PsiElement contributor) {
        if (place == null) {
            AndroidDslContributor.$$$reportNull$$$0(7);
        }
        if (contributor == null) {
            return;
        }
        if (!(place.getParent() instanceof GrMethodCall)) {
            return;
        }
        GrMethodCall method = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethodCall.class);
        if (method != null) {
            method.putUserData(CONTRIBUTOR_KEY, (Object)contributor);
        }
    }

    @Nullable
    private static String resolveAndroidExtension(PsiFile file) {
        assert (file instanceof GroovyFile);
        List<String> plugins = GradleBuildFile.getPlugins((GroovyFile)file);
        if (plugins.contains("com.android.application") || plugins.contains(DSL_ANDROID)) {
            return ANDROID_FQCN;
        }
        if (plugins.contains("com.android.library") || plugins.contains("android-library")) {
            return ANDROID_LIB_FQCN;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStack";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/service/resolve/AndroidDslContributor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqcn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/service/resolve/AndroidDslContributor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClassByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cacheContributorInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ParametrizedTypeExtractor {
        private static final String GRADLE_ACTION_FQCN = "org.gradle.api.Action";
        private static final String GRADLE_NAMED_DOMAIN_OBJECT_CONTAINER_FQCN = "org.gradle.api.NamedDomainObjectContainer";
        private static final Splitter SPLITTER = Splitter.onPattern((String)"[<>]").trimResults().omitEmptyStrings();
        private final ArrayList<String> myParameterTypes;
        private final String myCanonicalType;

        public ParametrizedTypeExtractor(String canonicalType) {
            this.myCanonicalType = canonicalType;
            this.myParameterTypes = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)canonicalType));
        }

        public String getCanonicalType() {
            return this.myCanonicalType;
        }

        public boolean isClosure() {
            return this.myParameterTypes.contains(GRADLE_ACTION_FQCN);
        }

        @Nullable
        public String getClosureType() {
            int i;
            if (!this.isClosure()) {
                return null;
            }
            StringBuilder sb = new StringBuilder(100);
            for (i = 1; i < this.myParameterTypes.size(); ++i) {
                String type = this.myParameterTypes.get(i);
                type = type.replace("? extends ", "");
                type = type.replace("? super ", "");
                sb.append(type);
                if (i == this.myParameterTypes.size() - 1) continue;
                sb.append('<');
            }
            for (i = 1; i < this.myParameterTypes.size() - 1; ++i) {
                sb.append('>');
            }
            return sb.toString();
        }

        @Nullable
        public String getNamedDomainObject() {
            return this.hasNamedDomainObjectContainer() ? (String)ContainerUtil.getLastItem(this.myParameterTypes) : null;
        }

        public boolean hasNamedDomainObjectContainer() {
            for (String type : this.myParameterTypes) {
                if (!type.contains(GRADLE_NAMED_DOMAIN_OBJECT_CONTAINER_FQCN)) continue;
                return true;
            }
            return false;
        }
    }
}

