/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsCheckBoxList<T>
extends CheckBoxList<T> {
    @NotNull
    private final List<CheckBoxListListener> myListeners;
    @Nullable
    private SelectionChangeListener<ImmutableList<T>> mySelectionChangeListener;

    public PsCheckBoxList(@NotNull List<T> items) {
        if (items == null) {
            PsCheckBoxList.$$$reportNull$$$0(0);
        }
        this.myListeners = Lists.newCopyOnWriteArrayList();
        this.setItems(items, null);
        super.setCheckBoxListListener((index, value) -> {
            for (CheckBoxListListener listener : this.myListeners) {
                listener.checkBoxSelectionChanged(index, value);
            }
        });
        this.addCheckBoxListListener((index, value) -> this.fireSelectionChangedEvent());
    }

    @Deprecated
    public void setCheckBoxListListener(CheckBoxListListener checkBoxListListener) {
        throw new UnsupportedOperationException("Invoke 'setSelectionChangeListener' instead");
    }

    public void addCheckBoxListListener(@NotNull CheckBoxListListener checkBoxListListener) {
        if (checkBoxListListener == null) {
            PsCheckBoxList.$$$reportNull$$$0(1);
        }
        this.myListeners.add(checkBoxListListener);
    }

    @NotNull
    public AnAction createSelectAllAction() {
        AnAction anAction = new AnAction("Select All", "", AllIcons.Actions.Selectall){

            public void actionPerformed(AnActionEvent e) {
                PsCheckBoxList.this.setItemsSelected(true);
            }
        };
        if (anAction == null) {
            PsCheckBoxList.$$$reportNull$$$0(2);
        }
        return anAction;
    }

    @NotNull
    public AnAction createUnselectAllAction() {
        AnAction anAction = new AnAction("Unselect All", "", AllIcons.Actions.Unselectall){

            public void actionPerformed(AnActionEvent e) {
                PsCheckBoxList.this.setItemsSelected(false);
            }
        };
        if (anAction == null) {
            PsCheckBoxList.$$$reportNull$$$0(3);
        }
        return anAction;
    }

    public void setItemsSelected(boolean selected) {
        int itemsCount = this.getItemsCount();
        for (int i = 0; i < itemsCount; ++i) {
            Object item = this.getItemAt(i);
            this.setItemSelected(item, selected);
        }
        this.repaint();
        this.fireSelectionChangedEvent();
    }

    private void fireSelectionChangedEvent() {
        if (this.mySelectionChangeListener != null) {
            this.mySelectionChangeListener.selectionChanged(this.getSelectedItems());
        }
    }

    @NotNull
    public ImmutableList<T> getSelectedItems() {
        int count = this.getItemsCount();
        if (count == 0) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                PsCheckBoxList.$$$reportNull$$$0(4);
            }
            return immutableList;
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int i = 0; i < count; ++i) {
            Object item = this.getItemAt(i);
            if (item == null || !this.isItemSelected(item)) continue;
            listBuilder.add(item);
        }
        ImmutableList immutableList = listBuilder.build();
        if (immutableList == null) {
            PsCheckBoxList.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    public void setSelectionChangeListener(@Nullable SelectionChangeListener<ImmutableList<T>> listener) {
        this.mySelectionChangeListener = listener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBoxListListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/PsCheckBoxList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/PsCheckBoxList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectAllAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnselectAllAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addCheckBoxListListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

