/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesByTypeAndTextComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.AbstractPsModelTableCellRenderer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDeclaredDependenciesTableModel<T extends PsDependency>
extends ListTableModel<T> {
    @NotNull
    private final PsModule myModule;
    @NotNull
    private final PsContext myContext;
    @Nullable
    private PsModuleDependency myHoveredDependency;

    protected AbstractDeclaredDependenciesTableModel(@NotNull PsModule module, @NotNull PsContext context) {
        if (module == null) {
            AbstractDeclaredDependenciesTableModel.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AbstractDeclaredDependenciesTableModel.$$$reportNull$$$0(1);
        }
        super(new ColumnInfo[0]);
        this.myModule = module;
        this.myContext = context;
        this.createAndSetColumnInfos();
        this.reset();
    }

    private void createAndSetColumnInfos() {
        ColumnInfo specColumnInfo = new ColumnInfo<T, String>("Dependency"){

            @NotNull
            public String valueOf(T dependency) {
                String string = dependency.toText(PsDependency.TextType.PLAIN_TEXT);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public TableCellRenderer getRenderer(T dependency) {
                DependencyCellRenderer dependencyCellRenderer = new DependencyCellRenderer((PsDependency)dependency, AbstractDeclaredDependenciesTableModel.this.myContext, dependency == AbstractDeclaredDependenciesTableModel.this.myHoveredDependency);
                if (dependencyCellRenderer == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dependencyCellRenderer;
            }

            @NotNull
            public String getPreferredStringValue() {
                if ("com.android.support:appcompat-v7:23.1.0" == null) {
                    1.$$$reportNull$$$0(2);
                }
                return "com.android.support:appcompat-v7:23.1.0";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDeclaredDependenciesTableModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "valueOf";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRenderer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPreferredStringValue";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        ColumnInfo scopeColumnInfo = new ColumnInfo<T, String>("Scope"){

            @Nullable
            public String valueOf(T dependency) {
                return ((PsDependency)dependency).getJoinedConfigurationNames();
            }

            @NotNull
            public String getPreferredStringValue() {
                if ("flavor1AndroidTestCompile" == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "flavor1AndroidTestCompile";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDeclaredDependenciesTableModel$2", "getPreferredStringValue"));
            }
        };
        this.setColumnInfos(new ColumnInfo[]{specColumnInfo, scopeColumnInfo});
    }

    @NotNull
    protected PsModule getModule() {
        PsModule psModule = this.myModule;
        if (psModule == null) {
            AbstractDeclaredDependenciesTableModel.$$$reportNull$$$0(2);
        }
        return psModule;
    }

    public void setHoveredDependency(@Nullable PsModuleDependency hoveredDependency) {
        this.myHoveredDependency = hoveredDependency;
    }

    public void reset() {
    }

    @Nullable
    public PsLibraryDependency findDependency(@NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            AbstractDeclaredDependenciesTableModel.$$$reportNull$$$0(3);
        }
        for (PsDependency dependency : this.getItems()) {
            PsLibraryDependency libraryDependency;
            if (!(dependency instanceof PsLibraryDependency) || !spec.equals((libraryDependency = (PsLibraryDependency)((Object)dependency)).getDeclaredSpec())) continue;
            return libraryDependency;
        }
        return null;
    }

    @NotNull
    static String displayTextOf(@NotNull PsDependency dependency) {
        if (dependency == null) {
            AbstractDeclaredDependenciesTableModel.$$$reportNull$$$0(4);
        }
        String text = dependency.toText(PsDependency.TextType.PLAIN_TEXT);
        if (dependency instanceof PsLibraryDependency) {
            PsLibraryDependency library = (PsLibraryDependency)((Object)dependency);
            PsArtifactDependencySpec spec = library.getDeclaredSpec();
            assert (spec != null);
            text = spec.getDisplayText();
        }
        String string = text;
        if (string == null) {
            AbstractDeclaredDependenciesTableModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDeclaredDependenciesTableModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDeclaredDependenciesTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "displayTextOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDependency";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "displayTextOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class DependencyCellRenderer
    extends AbstractPsModelTableCellRenderer<PsDependency> {
        @NotNull
        private final PsDependency myDependency;
        @NotNull
        private final PsContext myContext;
        private final boolean myIsHovered;

        DependencyCellRenderer(@NotNull PsDependency dependency, @NotNull PsContext context, boolean isHovered) {
            if (dependency == null) {
                DependencyCellRenderer.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DependencyCellRenderer.$$$reportNull$$$0(1);
            }
            super(dependency);
            this.myDependency = dependency;
            this.myContext = context;
            this.myIsHovered = isHovered;
        }

        @Override
        protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            SimpleTextAttributes textAttributes;
            this.setIcon(this.myDependency.getIcon());
            this.setIconOpaque(true);
            this.setFocusBorderAroundIcon(true);
            PsIssueCollection issueCollection = this.myContext.getAnalyzerDaemon().getIssues();
            List<PsIssue> issues = issueCollection.findIssues(this.myDependency, (Comparator<PsIssue>)IssuesByTypeAndTextComparator.INSTANCE);
            this.setToolTipText(PsIssueCollection.getTooltipText(issues, false));
            if (this.myIsHovered) {
                textAttributes = SimpleTextAttributes.LINK_ATTRIBUTES;
            } else {
                textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                if (!issues.isEmpty()) {
                    PsIssue issue2 = issues.get(0);
                    Color waveColor = issue2.getSeverity().getColor();
                    textAttributes = textAttributes.derive(8, null, null, waveColor);
                }
            }
            this.append(this.getText(), textAttributes);
        }

        @Override
        @NotNull
        protected String getText() {
            String string = AbstractDeclaredDependenciesTableModel.displayTextOf((PsDependency)this.getModel());
            if (string == null) {
                DependencyCellRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDeclaredDependenciesTableModel$DependencyCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDeclaredDependenciesTableModel$DependencyCellRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

