/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.structure.model.PsChildModel;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModel;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsAndroidArtifact
extends PsChildModel
implements PsAndroidModel {
    @NonNls
    private static final String API_SUFFIX = "Api";
    @NonNls
    private static final String COMPILE_SUFFIX = "Compile";
    @NonNls
    private static final String IMPLEMENTATION_SUFFIX = "Implementation";
    @NotNull
    private final String myName;
    @NotNull
    private final String myResolvedName;
    @NotNull
    private final Icon myIcon;
    @Nullable
    private final IdeBaseArtifact myResolvedModel;

    public PsAndroidArtifact(@NotNull PsVariant parent, @NotNull String resolvedName, @Nullable IdeBaseArtifact resolvedModel) {
        if (parent == null) {
            PsAndroidArtifact.$$$reportNull$$$0(0);
        }
        if (resolvedName == null) {
            PsAndroidArtifact.$$$reportNull$$$0(1);
        }
        super(parent);
        this.myResolvedName = resolvedName;
        Icon icon = AllIcons.Nodes.Artifact;
        String name = "";
        switch (resolvedName) {
            case "_main_": {
                icon = AllIcons.Modules.SourceRoot;
                break;
            }
            case "_android_test_": {
                name = "AndroidTest";
                icon = AndroidIcons.AndroidTestRoot;
                break;
            }
            case "_unit_test_": {
                name = "UnitTest";
                icon = AllIcons.Modules.TestRoot;
            }
        }
        this.myName = name;
        this.myIcon = icon;
        this.myResolvedModel = resolvedModel;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PsAndroidArtifact.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getResolvedName() {
        String string = this.myResolvedName;
        if (string == null) {
            PsAndroidArtifact.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public IdeBaseArtifact getResolvedModel() {
        return this.myResolvedModel;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            PsAndroidArtifact.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Override
    @NotNull
    public AndroidModuleModel getGradleModel() {
        AndroidModuleModel androidModuleModel = this.getParent().getGradleModel();
        if (androidModuleModel == null) {
            PsAndroidArtifact.$$$reportNull$$$0(5);
        }
        return androidModuleModel;
    }

    @Override
    @NotNull
    public PsVariant getParent() {
        PsVariant psVariant = (PsVariant)super.getParent();
        if (psVariant == null) {
            PsAndroidArtifact.$$$reportNull$$$0(6);
        }
        return psVariant;
    }

    @Override
    public boolean isDeclared() {
        return false;
    }

    public boolean containsAny(@NotNull Collection<DependencyModel> parsedDependencies) {
        if (parsedDependencies == null) {
            PsAndroidArtifact.$$$reportNull$$$0(7);
        }
        for (DependencyModel parsedDependency : parsedDependencies) {
            if (!this.contains(parsedDependency)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(@NotNull DependencyModel parsedDependency) {
        if (parsedDependency == null) {
            PsAndroidArtifact.$$$reportNull$$$0(8);
        }
        String configurationName = parsedDependency.configurationName();
        return this.containsConfigurationName(configurationName);
    }

    public boolean containsConfigurationName(@NotNull String configurationName) {
        if (configurationName == null) {
            PsAndroidArtifact.$$$reportNull$$$0(9);
        }
        return this.getPossibleConfigurationNames().contains(configurationName);
    }

    @VisibleForTesting
    @NotNull
    List<String> getPossibleConfigurationNames() {
        ArrayList configurationNames = Lists.newArrayList();
        switch (this.myResolvedName) {
            case "_main_": {
                configurationNames.add("compile");
                configurationNames.add("api");
                configurationNames.add("implementation");
                break;
            }
            case "_unit_test_": {
                configurationNames.add("testCompile");
                configurationNames.add("testApi");
                configurationNames.add("testImplementation");
                break;
            }
            case "_android_test_": {
                configurationNames.add("androidTestCompile");
                configurationNames.add("androidTestApi");
                configurationNames.add("androidTestImplementation");
            }
        }
        PsVariant variant = this.getParent();
        String buildTypeName = variant.getBuildType().getName();
        switch (this.myResolvedName) {
            case "_main_": {
                configurationNames.add(buildTypeName + COMPILE_SUFFIX);
                configurationNames.add(buildTypeName + API_SUFFIX);
                configurationNames.add(buildTypeName + IMPLEMENTATION_SUFFIX);
                break;
            }
            case "_unit_test_": {
                configurationNames.add("test" + StringUtil.capitalize((String)buildTypeName) + COMPILE_SUFFIX);
                configurationNames.add("test" + StringUtil.capitalize((String)buildTypeName) + API_SUFFIX);
                configurationNames.add("test" + StringUtil.capitalize((String)buildTypeName) + IMPLEMENTATION_SUFFIX);
            }
        }
        variant.forEachProductFlavor(productFlavor -> {
            String productFlavorName = productFlavor.getName();
            switch (this.myResolvedName) {
                case "_main_": {
                    configurationNames.add(productFlavorName + COMPILE_SUFFIX);
                    configurationNames.add(productFlavorName + API_SUFFIX);
                    configurationNames.add(productFlavorName + IMPLEMENTATION_SUFFIX);
                    break;
                }
                case "_unit_test_": {
                    configurationNames.add("test" + StringUtil.capitalize((String)productFlavorName) + COMPILE_SUFFIX);
                    configurationNames.add("test" + StringUtil.capitalize((String)productFlavorName) + API_SUFFIX);
                    configurationNames.add("test" + StringUtil.capitalize((String)productFlavorName) + IMPLEMENTATION_SUFFIX);
                    break;
                }
                case "_android_test_": {
                    configurationNames.add("androidTest" + StringUtil.capitalize((String)productFlavorName) + COMPILE_SUFFIX);
                    configurationNames.add("androidTest" + StringUtil.capitalize((String)productFlavorName) + API_SUFFIX);
                    configurationNames.add("androidTest" + StringUtil.capitalize((String)productFlavorName) + IMPLEMENTATION_SUFFIX);
                }
            }
        });
        ArrayList arrayList = configurationNames;
        if (arrayList == null) {
            PsAndroidArtifact.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/android/PsAndroidArtifact";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedDependencies";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedDependency";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/android/PsAndroidArtifact";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleConfigurationNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsAny";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsConfigurationName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

