/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.util.AssetUtil;
import com.android.resources.Density;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.concurrent.FutureUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedIcons;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.PrimitiveShapesHelper;
import com.android.tools.idea.npw.assetstudio.VectorDrawableTransformer;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdaptiveIconGenerator
extends GraphicGenerator {
    public static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 108, 108);
    public static final Dimension SIZE_FULL_BLEED_DP = IMAGE_SIZE_FULL_BLEED_DP.getSize();
    public static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 66, 66);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 72, 72);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 48, 48);
    private static final Rectangle IMAGE_SIZE_VIEW_PORT_WEB_PX = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_WEB_PX = new Rectangle(0, 0, 768, 768);
    private static final Density[] DENSITIES = new Density[]{Density.MEDIUM, Density.HIGH, Density.XHIGH, Density.XXHIGH, Density.XXXHIGH};

    @Override
    @NotNull
    public GeneratedIcons generateIcons(@NotNull GraphicGeneratorContext context, @NotNull GraphicGenerator.Options options, @NotNull String name) {
        List results;
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(0);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(1);
        }
        if (name == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(2);
        }
        AdaptiveIconOptions adaptiveIconOptions = (AdaptiveIconOptions)options;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context, name, adaptiveIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, adaptiveIconOptions, tasks);
        AdaptiveIconGenerator.createPreviewImagesTasks(context, adaptiveIconOptions, tasks);
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        tasks.forEach(arg_0 -> ((WaitableExecutor)executor).execute(arg_0));
        try {
            results = executor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        GeneratedIcons icons = new GeneratedIcons();
        results.forEach(icons::add);
        GeneratedIcons generatedIcons = icons;
        if (generatedIcons == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(3);
        }
        return generatedIcons;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull AdaptiveIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(5);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(6);
        }
        if (tasks == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(7);
        }
        if (!options.generateOutputIcons) {
            return;
        }
        for (Density density : DENSITIES) {
            AdaptiveIconOptions localOptions = options.clone();
            localOptions.density = density;
            localOptions.showGrid = false;
            localOptions.showSafeZone = false;
            this.createOutputIconsForSingleDensityTasks(context, name, localOptions, density, tasks);
        }
        if (options.generateWebIcon) {
            tasks.add(() -> {
                if (options == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(152);
                }
                if (context == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(153);
                }
                if (name == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(154);
                }
                AdaptiveIconOptions localOptions = options.clone();
                localOptions.showGrid = false;
                localOptions.showSafeZone = false;
                localOptions.generateWebIcon = true;
                localOptions.generateOutputIcons = true;
                localOptions.generatePreviewIcons = false;
                localOptions.legacyIconShape = localOptions.webIconShape;
                BufferedImage image = AdaptiveIconGenerator.generateLegacyImage(context, localOptions);
                return new GeneratedImageIcon(name, Paths.get(this.getIconPath(localOptions, name), new String[0]), IconCategory.WEB, Density.NODPI, image);
            });
        }
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull AdaptiveIconOptions options, @NotNull Density density, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(8);
        }
        if (name == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(9);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(10);
        }
        if (density == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(11);
        }
        if (tasks == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(12);
        }
        if (options.foregroundImage != null && options.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                if (options == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(149);
                }
                if (context == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(150);
                }
                if (density == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(151);
                }
                AdaptiveIconOptions foregroundOptions = options.clone();
                foregroundOptions.generateWebIcon = false;
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                BufferedImage foregroundImage = AdaptiveIconGenerator.generateIconForegroundLayer(context, foregroundOptions);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, Paths.get(this.getIconPath(foregroundOptions, options.foregroundLayerName), new String[0]), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                if (options == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(146);
                }
                if (context == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(147);
                }
                if (density == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(148);
                }
                AdaptiveIconOptions backgroundOptions = options.clone();
                backgroundOptions.generateWebIcon = false;
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                BufferedImage backgroundImage = AdaptiveIconGenerator.generateIconBackgroundLayer(context, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, Paths.get(this.getIconPath(backgroundOptions, options.backgroundLayerName), new String[0]), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options.generateLegacyIcon) {
            tasks.add(() -> {
                if (options == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(142);
                }
                if (context == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(143);
                }
                if (name == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(144);
                }
                if (density == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(145);
                }
                AdaptiveIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generateWebIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                BufferedImage legacy = AdaptiveIconGenerator.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name, Paths.get(this.getIconPath(legacyOptions, name), new String[0]), IconCategory.LEGACY, density, legacy);
            });
        }
        if (options.generateRoundIcon) {
            tasks.add(() -> {
                if (options == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(138);
                }
                if (context == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(139);
                }
                if (name == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(140);
                }
                if (density == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(141);
                }
                AdaptiveIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY_ROUND;
                legacyOptions.generateWebIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                legacyOptions.legacyIconShape = GraphicGenerator.Shape.CIRCLE;
                BufferedImage legacyRound = AdaptiveIconGenerator.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name + "_round", Paths.get(this.getIconPath(legacyOptions, name + "_round"), new String[0]), IconCategory.ROUND_API_25, density, legacyRound);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name, @NotNull AdaptiveIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (name == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(13);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(14);
        }
        if (tasks == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(15);
        }
        if (!options.generateOutputIcons) {
            return;
        }
        AdaptiveIconOptions xmlOptions = options.clone();
        xmlOptions.density = Density.ANYDPI;
        xmlOptions.generateWebIcon = false;
        xmlOptions.iconFolderKind = GraphicGenerator.IconFolderKind.MIPMAP_V26;
        tasks.add(() -> {
            if (name == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(137);
            }
            String xmlAdaptiveIcon = AdaptiveIconGenerator.getAdaptiveIconXml(xmlOptions);
            return new GeneratedXmlResource(name, Paths.get(this.getIconPath(xmlOptions, name), new String[0]), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        tasks.add(() -> {
            if (name == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(136);
            }
            String xmlAdaptiveIcon = AdaptiveIconGenerator.getAdaptiveIconXml(xmlOptions);
            return new GeneratedXmlResource(name + "_round", Paths.get(this.getIconPath(xmlOptions, name + "_round"), new String[0]), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (options.foregroundImage != null && options.foregroundImage.isDrawable()) {
            tasks.add(() -> {
                if (options == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(134);
                }
                if (name == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(135);
                }
                AdaptiveIconOptions iconPathOptions = xmlOptions.clone();
                iconPathOptions.generateWebIcon = false;
                iconPathOptions.density = Density.ANYDPI;
                iconPathOptions.iconFolderKind = GraphicGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                String xmlDrawable = options.foregroundImage.getScaledDrawable();
                assert (xmlDrawable != null);
                return new GeneratedXmlResource(name, Paths.get(this.getIconPath(iconPathOptions, xmlOptions.foregroundLayerName), new String[0]), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawable);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isDrawable()) {
            tasks.add(() -> {
                if (options == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(132);
                }
                if (name == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(133);
                }
                AdaptiveIconOptions iconPathOptions = xmlOptions.clone();
                iconPathOptions.generateWebIcon = false;
                iconPathOptions.density = Density.ANYDPI;
                iconPathOptions.iconFolderKind = GraphicGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                String xmlDrawable = options.backgroundImage.getScaledDrawable();
                assert (xmlDrawable != null);
                return new GeneratedXmlResource(name, Paths.get(this.getIconPath(iconPathOptions, xmlOptions.backgroundLayerName), new String[0]), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawable);
            });
        } else if (xmlOptions.backgroundImage == null) {
            tasks.add(() -> {
                if (name == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(131);
                }
                AdaptiveIconOptions iconPathOptions = xmlOptions.clone();
                iconPathOptions.generateWebIcon = false;
                iconPathOptions.density = Density.ANYDPI;
                iconPathOptions.iconFolderKind = GraphicGenerator.IconFolderKind.VALUES;
                String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n    <color name=\"%s\">#%06X</color>\n</resources>";
                String xmlColor = String.format(format, xmlOptions.backgroundLayerName, xmlOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, Paths.get(this.getIconPath(iconPathOptions, xmlOptions.backgroundLayerName), new String[0]), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    @NotNull
    private static String getAdaptiveIconXml(@NotNull AdaptiveIconOptions options) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(16);
        }
        String backgroundType = options.backgroundImage == null ? "color" : (options.backgroundImage.isDrawable() ? "drawable" : "mipmap");
        String foregroundType = options.foregroundImage != null && options.foregroundImage.isDrawable() ? "drawable" : "mipmap";
        String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <background android:drawable=\"@%s/%s\"/>\n    <foreground android:drawable=\"@%s/%s\"/>\n</adaptive-icon>";
        String string = String.format(format, backgroundType, options.backgroundLayerName, foregroundType, options.foregroundLayerName);
        if (string == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(18);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(19);
        }
        if (tasks == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(20);
        }
        if (!options.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>();
        previewShapes.add(PreviewShape.FULL_BLEED);
        previewShapes.add(PreviewShape.SQUIRCLE);
        previewShapes.add(PreviewShape.CIRCLE);
        previewShapes.add(PreviewShape.SQUARE);
        previewShapes.add(PreviewShape.ROUNDED_SQUARE);
        if (options.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        if (options.generateRoundIcon) {
            previewShapes.add(PreviewShape.LEGACY_ROUND);
        }
        if (options.generateWebIcon) {
            previewShapes.add(PreviewShape.WEB);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                if (options == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(129);
                }
                if (context == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(130);
                }
                AdaptiveIconOptions localOptions = options.clone();
                localOptions.density = options.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                localOptions.generateRoundIcon = previewShape == PreviewShape.LEGACY_ROUND;
                localOptions.generateWebIcon = previewShape == PreviewShape.WEB;
                BufferedImage image = AdaptiveIconGenerator.generatePreviewImage(context, localOptions);
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generate(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, GraphicGenerator.Options options, String name) {
        AdaptiveIconOptions adaptiveIconOptions = (AdaptiveIconOptions)options;
        AdaptiveIconOptions localOptions = adaptiveIconOptions.clone();
        localOptions.generateWebIcon = false;
        GeneratedIcons icons = this.generateIcons(context, options, name);
        icons.getList().stream().filter(x -> x instanceof GeneratedImageIcon).map(x -> (GeneratedImageIcon)x).filter(x -> x.getOutputPath() != null).forEach(x -> {
            assert (x.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(x.getCategory().toString(), k -> new LinkedHashMap());
            AdaptiveIconOptions iconOptions = localOptions.clone();
            iconOptions.density = x.getDensity();
            iconOptions.iconFolderKind = GraphicGenerator.IconFolderKind.MIPMAP;
            iconOptions.generateWebIcon = x.getCategory() == IconCategory.WEB;
            imageMap.put(x.getOutputPath().toString(), x.getImage());
        });
    }

    @Override
    @NotNull
    public BufferedImage generate(@NotNull GraphicGeneratorContext context, @NotNull GraphicGenerator.Options options) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(21);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(22);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(23);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = AdaptiveIconGenerator.generatePreviewImage(context, (AdaptiveIconOptions)options);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(24);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generatePreviewImage(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(25);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(26);
        }
        switch (options.previewShape) {
            case CIRCLE: 
            case SQUIRCLE: 
            case ROUNDED_SQUARE: 
            case SQUARE: {
                BufferedImage bufferedImage = AdaptiveIconGenerator.generateViewportPreviewImage(context, options);
                if (bufferedImage == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(27);
                }
                return bufferedImage;
            }
            case LEGACY: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = false;
                BufferedImage bufferedImage = AdaptiveIconGenerator.generateLegacyImage(context, options);
                if (bufferedImage == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(28);
                }
                return bufferedImage;
            }
            case LEGACY_ROUND: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = false;
                options.legacyIconShape = GraphicGenerator.Shape.CIRCLE;
                BufferedImage bufferedImage = AdaptiveIconGenerator.generateLegacyImage(context, options);
                if (bufferedImage == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(29);
                }
                return bufferedImage;
            }
            case FULL_BLEED: {
                BufferedImage image = AdaptiveIconGenerator.generateFullBleedPreviewImage(context, options);
                BufferedImage bufferedImage = AdaptiveIconGenerator.scaledPreviewImage(image, 0.8f);
                if (bufferedImage == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(30);
                }
                return bufferedImage;
            }
            case WEB: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = true;
                options.legacyIconShape = options.webIconShape;
                BufferedImage image = AdaptiveIconGenerator.generateLegacyImage(context, options);
                image = AssetUtil.trimmedImage((BufferedImage)image);
                float scale = AdaptiveIconGenerator.getMdpiScaleFactor(options.previewDensity);
                BufferedImage bufferedImage = AdaptiveIconGenerator.scaledPreviewImage(image, 0.25f * scale);
                if (bufferedImage == null) {
                    AdaptiveIconGenerator.$$$reportNull$$$0(31);
                }
                return bufferedImage;
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private static BufferedImage generateFullBleedPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(32);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(33);
        }
        Layers layers = AdaptiveIconGenerator.generateIconLayers(context, options);
        BufferedImage result = AdaptiveIconGenerator.mergeLayers(layers, Color.BLACK);
        AdaptiveIconGenerator.drawGrid(options, result);
        BufferedImage bufferedImage = result;
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(34);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateLegacyImage(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(35);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(36);
        }
        Density legacyOrWebDensity = options.generateWebIcon ? null : options.density;
        Rectangle viewportRect = AdaptiveIconGenerator.getViewportRectangle(options);
        Rectangle legacyRect = AdaptiveIconGenerator.getLegacyRectangle(options);
        Rectangle legacyShapeRect = LauncherIconGenerator.getTargetRect(options.legacyIconShape, legacyOrWebDensity);
        Layers layers = AdaptiveIconGenerator.generateIconLayers(context, options);
        BufferedImage fullBleed = AdaptiveIconGenerator.mergeLayers(layers);
        float viewportScale = AdaptiveIconGenerator.getRectangleInsideScale(viewportRect, legacyShapeRect);
        BufferedImage scaledFullBleed = options.generatePreviewIcons ? AdaptiveIconGenerator.scaledPreviewImage(fullBleed, viewportScale) : AdaptiveIconGenerator.scaledImage(fullBleed, viewportScale);
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (options.legacyIconShape != GraphicGenerator.Shape.NONE) {
            shapeImageBack = LauncherIconGenerator.loadBackImage(context, options.legacyIconShape, legacyOrWebDensity);
            shapeImageFore = LauncherIconGenerator.loadStyleImage(context, options.legacyIconShape, legacyOrWebDensity, GraphicGenerator.Style.SIMPLE);
            shapeImageMask = LauncherIconGenerator.loadMaskImage(context, options.legacyIconShape, legacyOrWebDensity);
        }
        BufferedImage legacyImage = AssetUtil.newArgbBufferedImage((int)legacyRect.width, (int)legacyRect.height);
        Graphics2D gLegacy = (Graphics2D)legacyImage.getGraphics();
        if (shapeImageBack != null) {
            AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)shapeImageBack, (Rectangle)legacyRect);
        }
        if (shapeImageMask != null) {
            scaledFullBleed = AdaptiveIconGenerator.applyMask(scaledFullBleed, shapeImageMask);
        }
        AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)scaledFullBleed, (Rectangle)legacyRect);
        if (shapeImageFore != null) {
            gLegacy.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gLegacy.dispose();
        BufferedImage bufferedImage = legacyImage;
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(37);
        }
        return bufferedImage;
    }

    private static float getRectangleInsideScale(@NotNull Rectangle source, @NotNull Rectangle destination) {
        if (source == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(38);
        }
        if (destination == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(39);
        }
        return AssetUtil.getRectangleInsideScale((Rectangle)source, (Rectangle)destination);
    }

    @NotNull
    private static BufferedImage scaledImage(@NotNull BufferedImage image, float scale) {
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(40);
        }
        int width = Math.round((float)image.getWidth() * scale);
        int height = Math.round((float)image.getHeight() * scale);
        BufferedImage bufferedImage = AdaptiveIconGenerator.scaledImage(image, width, height);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(41);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage scaledImage(@NotNull BufferedImage image, int width, int height) {
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(42);
        }
        BufferedImage bufferedImage = AssetUtil.scaledImage((BufferedImage)image, (int)width, (int)height);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(43);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage scaledPreviewImage(@NotNull BufferedImage image, float scale) {
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(44);
        }
        int width = Math.round((float)image.getWidth() * scale);
        int height = Math.round((float)image.getHeight() * scale);
        BufferedImage bufferedImage = AdaptiveIconGenerator.scaledPreviewImage(image, width, height);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(45);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage scaledPreviewImage(@NotNull BufferedImage source, int width, int height) {
        if (source == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(46);
        }
        if (source.getWidth() == width && source.getHeight() == height) {
            BufferedImage bufferedImage = source;
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(47);
            }
            return bufferedImage;
        }
        BufferedImage scaledBufImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D g = scaledBufImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        BufferedImage bufferedImage = scaledBufImage;
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(48);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateViewportPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(49);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(50);
        }
        Layers layers = AdaptiveIconGenerator.generateIconLayers(context, options);
        BufferedImage result = AdaptiveIconGenerator.mergeLayers(layers);
        BufferedImage mask = AdaptiveIconGenerator.generateMaskLayer(context, options, options.previewShape);
        result = AdaptiveIconGenerator.cropImageToViewport(options, result);
        result = AdaptiveIconGenerator.applyMask(result, mask);
        AdaptiveIconGenerator.drawGrid(options, result);
        BufferedImage bufferedImage = result;
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(51);
        }
        return bufferedImage;
    }

    private static BufferedImage cropImageToViewport(@NotNull AdaptiveIconOptions options, @NotNull BufferedImage image) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(52);
        }
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(53);
        }
        return AdaptiveIconGenerator.cropImage(image, AdaptiveIconGenerator.getViewportRectangle(options));
    }

    private static BufferedImage cropImage(@NotNull BufferedImage image, @NotNull Rectangle targetRect) {
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(54);
        }
        if (targetRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(55);
        }
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage subImage = image.getSubimage((imageRect.width - targetRect.width) / 2, (imageRect.height - targetRect.height) / 2, targetRect.width, targetRect.height);
        BufferedImage viewportImage = AssetUtil.newArgbBufferedImage((int)targetRect.width, (int)targetRect.height);
        Graphics2D gViewport = (Graphics2D)viewportImage.getGraphics();
        gViewport.drawImage((Image)subImage, 0, 0, null);
        gViewport.dispose();
        return viewportImage;
    }

    @NotNull
    private static BufferedImage mergeLayers(@NotNull Layers layers) {
        if (layers == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(56);
        }
        BufferedImage bufferedImage = AdaptiveIconGenerator.mergeLayers(layers, null);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(57);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage mergeLayers(@NotNull Layers layers, @Nullable Color fillColor) {
        if (layers == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(58);
        }
        int width = Math.max(layers.background.getWidth(), layers.foreground.getWidth());
        int height = Math.max(layers.background.getHeight(), layers.foreground.getHeight());
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (fillColor != null) {
            gOut.setPaint(fillColor);
            gOut.fillRect(0, 0, width, height);
        }
        gOut.drawImage((Image)layers.background, 0, 0, null);
        gOut.drawImage((Image)layers.foreground, 0, 0, null);
        gOut.dispose();
        BufferedImage bufferedImage = outImage;
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(59);
        }
        return bufferedImage;
    }

    @NotNull
    private static Layers generateIconLayers(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(60);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(61);
        }
        BufferedImage backgroundImage = AdaptiveIconGenerator.generateIconBackgroundLayer(context, options);
        BufferedImage foregroundImage = AdaptiveIconGenerator.generateIconForegroundLayer(context, options);
        Layers layers = new Layers(backgroundImage, foregroundImage);
        if (layers == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(62);
        }
        return layers;
    }

    @Nullable
    private static BufferedImage generateMaskLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options, @NotNull PreviewShape shape) {
        String maskName;
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(63);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(64);
        }
        if (shape == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(65);
        }
        switch (shape) {
            case CIRCLE: {
                maskName = "circle";
                break;
            }
            case SQUARE: {
                maskName = "square";
                break;
            }
            case ROUNDED_SQUARE: {
                maskName = "rounded_corner";
                break;
            }
            case SQUIRCLE: {
                maskName = "squircle";
                break;
            }
            default: {
                maskName = null;
            }
        }
        if (maskName == null) {
            return null;
        }
        if (options.generateWebIcon) {
            String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, Density.XXXHIGH.getResourceValue());
            BufferedImage mask = context.loadImageResource(resourceName);
            if (mask == null) {
                return null;
            }
            Rectangle maskRect = new Rectangle(0, 0, mask.getWidth(), mask.getHeight());
            float scale = AdaptiveIconGenerator.getRectangleInsideScale(maskRect, AdaptiveIconGenerator.getViewportRectangle(options));
            return options.generatePreviewIcons ? AdaptiveIconGenerator.scaledPreviewImage(mask, scale) : AdaptiveIconGenerator.scaledImage(mask, scale);
        }
        String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, options.density.getResourceValue());
        return context.loadImageResource(resourceName);
    }

    @NotNull
    private static Rectangle getFullBleedRectangle(@NotNull AdaptiveIconOptions options) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(66);
        }
        if (options.generateWebIcon) {
            Rectangle rectangle = IMAGE_SIZE_FULL_BLEED_WEB_PX;
            if (rectangle == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(67);
            }
            return rectangle;
        }
        Rectangle rectangle = AssetUtil.scaleRectangle((Rectangle)IMAGE_SIZE_FULL_BLEED_DP, (float)GraphicGenerator.getMdpiScaleFactor(options.density));
        if (rectangle == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(68);
        }
        return rectangle;
    }

    @NotNull
    private static Rectangle getViewportRectangle(@NotNull AdaptiveIconOptions options) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(69);
        }
        if (options.generateWebIcon) {
            Rectangle rectangle = IMAGE_SIZE_VIEW_PORT_WEB_PX;
            if (rectangle == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(70);
            }
            return rectangle;
        }
        Rectangle rectangle = AssetUtil.scaleRectangle((Rectangle)IMAGE_SIZE_VIEWPORT_DP, (float)GraphicGenerator.getMdpiScaleFactor(options.density));
        if (rectangle == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(71);
        }
        return rectangle;
    }

    @NotNull
    private static Rectangle getLegacyRectangle(@NotNull AdaptiveIconOptions options) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(72);
        }
        if (options.generateWebIcon) {
            Rectangle rectangle = IMAGE_SIZE_VIEW_PORT_WEB_PX;
            if (rectangle == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(73);
            }
            return rectangle;
        }
        Rectangle rectangle = AssetUtil.scaleRectangle((Rectangle)IMAGE_SIZE_LEGACY_DP, (float)GraphicGenerator.getMdpiScaleFactor(options.density));
        if (rectangle == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(74);
        }
        return rectangle;
    }

    @NotNull
    private static BufferedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(75);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(76);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(77);
            }
            return bufferedImage;
        }
        Rectangle imageRect = AdaptiveIconGenerator.getFullBleedRectangle(options);
        if (options.backgroundImage != null) {
            BufferedImage bufferedImage = AdaptiveIconGenerator.generateIconLayer(context, options.backgroundImage, imageRect, false, 0, !options.generateOutputIcons);
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(78);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = AdaptiveIconGenerator.generateFlatColorRectangle(new Color(options.backgroundColor), imageRect);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(79);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateIconForegroundLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(80);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(81);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(82);
            }
            return bufferedImage;
        }
        Rectangle imageRect = AdaptiveIconGenerator.getFullBleedRectangle(options);
        if (options.foregroundImage != null) {
            BufferedImage bufferedImage = AdaptiveIconGenerator.generateIconLayer(context, options.foregroundImage, imageRect, options.useForegroundColor, options.foregroundColor, !options.generateOutputIcons);
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(83);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(84);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateFlatColorRectangle(@NotNull Color color, @NotNull Rectangle imageRect) {
        if (color == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(85);
        }
        if (imageRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(86);
        }
        BufferedImage result = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)result.getGraphics();
        gTemp.setPaint(color);
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        gTemp.dispose();
        BufferedImage bufferedImage = result;
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(87);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage applyMask(@NotNull BufferedImage image, @Nullable BufferedImage mask) {
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(88);
        }
        if (mask == null) {
            BufferedImage bufferedImage = image;
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(89);
            }
            return bufferedImage;
        }
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)mask, (Rectangle)imageRect);
        gTemp.setComposite(AlphaComposite.SrcIn);
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)image, (Rectangle)imageRect);
        gTemp.dispose();
        BufferedImage bufferedImage = tempImage;
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(90);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull ImageAssetSnapshot sourceImage, @NotNull Rectangle imageRect, boolean useFillColor, int fillColor, boolean forPreview) {
        String scaledDrawable;
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(91);
        }
        if (sourceImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(92);
        }
        if (imageRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(93);
        }
        if ((scaledDrawable = sourceImage.getScaledDrawable()) != null) {
            BufferedImage bufferedImage = AdaptiveIconGenerator.generateIconLayer(context, scaledDrawable, imageRect);
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(94);
            }
            return bufferedImage;
        }
        BufferedImage trimmedImage = sourceImage.getTrimmedImage();
        if (trimmedImage != null) {
            BufferedImage bufferedImage = AdaptiveIconGenerator.generateIconLayer(context, trimmedImage, imageRect, sourceImage.getScaleFactor(), useFillColor, fillColor, forPreview);
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(95);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(96);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull String xmlDrawable, @NotNull Rectangle imageRect) {
        block7: {
            BufferedImage bufferedImage;
            if (context == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(97);
            }
            if (xmlDrawable == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(98);
            }
            if (imageRect == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(99);
            }
            ListenableFuture<BufferedImage> imageFuture = context.renderDrawable(xmlDrawable, imageRect.getSize());
            try {
                BufferedImage image = (BufferedImage)imageFuture.get();
                if (image == null) break block7;
                bufferedImage = image;
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(100);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(101);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor, boolean bl) {
        void forPreview;
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(102);
        }
        if (sourceImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(103);
        }
        if (imageRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(104);
        }
        if (forPreview != false && (double)Math.max(sourceImage.getWidth(), sourceImage.getHeight()) > IMAGE_SIZE_FULL_BLEED_WEB_PX.getWidth() * 1.2) {
            sourceImage = AdaptiveIconGenerator.generateIconLayer(context, sourceImage, IMAGE_SIZE_FULL_BLEED_WEB_PX, 1.0, false, 0);
        }
        BufferedImage bufferedImage = AdaptiveIconGenerator.generateIconLayer(context, sourceImage, imageRect, scaleFactor, useFillColor, fillColor);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(105);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int n) {
        void fillColor;
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(106);
        }
        if (sourceImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(107);
        }
        if (imageRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(108);
        }
        Callable<ListenableFuture<BufferedImage>> generator = () -> AdaptiveIconGenerator.lambda$generateIconLayer$17(imageRect, scaleFactor, sourceImage, useFillColor, (int)fillColor);
        class CacheKey {
            @NotNull
            private final Object mySource;
            @NotNull
            private final Rectangle myImageRect;
            private final int myScaleFactorTimes1000;
            private final boolean myUseFillColor;
            private final int myFillColor;

            /*
             * WARNING - void declaration
             */
            CacheKey(@NotNull Object source, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int n) {
                void fillColor;
                if (source == null) {
                    CacheKey.$$$reportNull$$$0(0);
                }
                if (imageRect == null) {
                    CacheKey.$$$reportNull$$$0(1);
                }
                this.mySource = source;
                this.myImageRect = imageRect;
                this.myScaleFactorTimes1000 = AdaptiveIconGenerator.roundToInt(scaleFactor * 1000.0);
                this.myUseFillColor = useFillColor;
                this.myFillColor = fillColor;
            }

            public int hashCode() {
                return Objects.hash(this.mySource, this.myImageRect, this.myScaleFactorTimes1000, this.myUseFillColor, this.myFillColor);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)obj;
                return Objects.equals(this.mySource, other.mySource) && Objects.equals(this.myImageRect, other.myImageRect) && this.myScaleFactorTimes1000 == other.myScaleFactorTimes1000 && this.myUseFillColor == other.myUseFillColor && this.myFillColor == other.myFillColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "imageRect";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator$1CacheKey";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        CacheKey cacheKey = new CacheKey(sourceImage, imageRect, scaleFactor, useFillColor, (int)fillColor);
        ListenableFuture<BufferedImage> imageFuture = context.getFromCacheOrCreate(cacheKey, generator);
        BufferedImage bufferedImage = (BufferedImage)Futures.getUnchecked(imageFuture);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(109);
        }
        return bufferedImage;
    }

    private static Rectangle scaleRectangleAroundCenter(Rectangle rect, double scaleFactor) {
        int width = AdaptiveIconGenerator.roundToInt((double)rect.width * scaleFactor);
        int height = AdaptiveIconGenerator.roundToInt((double)rect.height * scaleFactor);
        return new Rectangle(AdaptiveIconGenerator.roundToInt((double)rect.x * scaleFactor - (double)(width - rect.width) / 2.0), AdaptiveIconGenerator.roundToInt((double)rect.y * scaleFactor - (double)(width - rect.width) / 2.0), width, height);
    }

    private static int roundToInt(double f) {
        return Math.round((float)f);
    }

    private static void drawGrid(@NotNull AdaptiveIconOptions adaptiveIconOptions, @NotNull BufferedImage image) {
        if (adaptiveIconOptions == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(110);
        }
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(111);
        }
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        AdaptiveIconGenerator.drawGrid(adaptiveIconOptions, gOut);
        gOut.dispose();
    }

    private static void drawGrid(@NotNull AdaptiveIconOptions adaptiveIconOptions, @NotNull Graphics2D gOut) {
        if (adaptiveIconOptions == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(112);
        }
        if (gOut == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(113);
        }
        if (adaptiveIconOptions.generateWebIcon) {
            return;
        }
        if (adaptiveIconOptions.previewShape == PreviewShape.FULL_BLEED) {
            if (adaptiveIconOptions.showGrid || adaptiveIconOptions.showSafeZone) {
                AdaptiveIconGenerator.drawFullBleedIconGrid(adaptiveIconOptions, gOut);
            }
            return;
        }
        if (adaptiveIconOptions.previewShape == PreviewShape.LEGACY || adaptiveIconOptions.previewShape == PreviewShape.LEGACY_ROUND) {
            if (adaptiveIconOptions.showGrid) {
                AdaptiveIconGenerator.drawLegacyIconGrid(adaptiveIconOptions, gOut);
            }
            return;
        }
        if (adaptiveIconOptions.showGrid || adaptiveIconOptions.showSafeZone) {
            AdaptiveIconGenerator.drawAdaptiveIconGrid(adaptiveIconOptions, gOut);
        }
    }

    private static void drawAdaptiveIconGrid(@NotNull AdaptiveIconOptions options, @NotNull Graphics2D out) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(114);
        }
        if (out == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(115);
        }
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        int size = AdaptiveIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
            int arcSize = 4;
            int rect1 = 36;
            int rect2 = 44;
            int rect3 = 52;
            g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
            g.drawRoundRect((size - rect2) / 2, (size - rect2) / 2, rect2, rect2, arcSize, arcSize);
            g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
            g.drawCenteredCircle(center, center, 18);
            g.drawCenteredCircle(center, center, 26);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, 33);
        }
    }

    private static void drawFullBleedIconGrid(@NotNull AdaptiveIconOptions options, @NotNull Graphics2D out) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(116);
        }
        if (out == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(117);
        }
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        int size = AdaptiveIconGenerator.IMAGE_SIZE_FULL_BLEED_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawRect(18, 18, AdaptiveIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width, AdaptiveIconGenerator.IMAGE_SIZE_VIEWPORT_DP.height);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, AdaptiveIconGenerator.IMAGE_SIZE_SAFE_ZONE_DP.width / 2);
        }
    }

    private static void drawLegacyIconGrid(@NotNull AdaptiveIconOptions options, @NotNull Graphics2D out) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(118);
        }
        if (out == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(119);
        }
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        int size = AdaptiveIconGenerator.IMAGE_SIZE_LEGACY_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        g.drawRect(0, 0, size, size);
        g.drawLine(0, 0, size, size);
        g.drawLine(size, 0, 0, size);
        g.drawLine(0, center, size, center);
        g.drawLine(center, 0, center, size);
        int arcSize = 3;
        int rect1 = 32;
        int rect3 = 44;
        g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
        g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
        g.drawCenteredCircle(center, center, 10);
        g.drawCenteredCircle(center, center, 22);
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        if (density == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(120);
        }
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    @NotNull
    protected String getIconPath(@NotNull GraphicGenerator.Options options, @NotNull String name) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(121);
        }
        if (name == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(122);
        }
        if (((AdaptiveIconOptions)options).generateWebIcon) {
            String string = name + "-web.png";
            if (string == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(123);
            }
            return string;
        }
        String string = super.getIconPath(options, name);
        if (string == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(124);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ ListenableFuture lambda$generateIconLayer$17(@NotNull Rectangle imageRect, double scaleFactor, @NotNull BufferedImage sourceImage, boolean useFillColor, int n) throws Exception {
        void fillColor;
        if (imageRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(125);
        }
        if (sourceImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(126);
        }
        return FutureUtils.executeOnPooledThread(() -> AdaptiveIconGenerator.lambda$null$16(imageRect, scaleFactor, sourceImage, useFillColor, (int)fillColor));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ BufferedImage lambda$null$16(@NotNull Rectangle imageRect, double scaleFactor, @NotNull BufferedImage sourceImage, boolean useFillColor, int n) throws Exception {
        void fillColor;
        if (imageRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(127);
        }
        if (sourceImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(128);
        }
        BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
        Rectangle rect = AdaptiveIconGenerator.scaleRectangleAroundCenter(imageRect, (float)scaleFactor);
        AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)rect);
        gIcon.dispose();
        if (!useFillColor) {
            return iconImage;
        }
        BufferedImage effectImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gEffect = (Graphics2D)effectImage.getGraphics();
        AssetUtil.Effect[] effects = new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color((int)fillColor), 1.0)};
        AssetUtil.drawEffects((Graphics2D)gEffect, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
        gEffect.dispose();
        return effectImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 17: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 51: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 89: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 100: 
            case 101: 
            case 105: 
            case 109: 
            case 123: 
            case 124: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 17: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 51: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 89: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 100: 
            case 101: 
            case 105: 
            case 109: 
            case 123: 
            case 124: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 26: 
            case 33: 
            case 36: 
            case 50: 
            case 52: 
            case 61: 
            case 64: 
            case 66: 
            case 69: 
            case 72: 
            case 76: 
            case 81: 
            case 114: 
            case 116: 
            case 118: 
            case 121: 
            case 129: 
            case 132: 
            case 134: 
            case 138: 
            case 142: 
            case 146: 
            case 149: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 122: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 140: 
            case 144: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 17: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 51: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 89: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 100: 
            case 101: 
            case 105: 
            case 109: 
            case 123: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator";
                break;
            }
            case 7: 
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 11: 
            case 120: 
            case 141: 
            case 145: 
            case 148: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 40: 
            case 42: 
            case 44: 
            case 53: 
            case 54: 
            case 88: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRect";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layers";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shape";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 86: 
            case 93: 
            case 99: 
            case 104: 
            case 108: 
            case 125: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageRect";
                break;
            }
            case 92: 
            case 103: 
            case 107: 
            case 126: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceImage";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawable";
                break;
            }
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adaptiveIconOptions";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gOut";
                break;
            }
            case 115: 
            case 117: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcons";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdaptiveIconXml";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreviewImage";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFullBleedPreviewImage";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLegacyImage";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "scaledImage";
                break;
            }
            case 45: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "scaledPreviewImage";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "generateViewportPreviewImage";
                break;
            }
            case 57: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeLayers";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconLayers";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullBleedRectangle";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewportRectangle";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyRectangle";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconBackgroundLayer";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconForegroundLayer";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFlatColorRectangle";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "applyMask";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 100: 
            case 101: 
            case 105: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconLayer";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateIcons";
                break;
            }
            case 3: 
            case 17: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 51: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 89: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 100: 
            case 101: 
            case 105: 
            case 109: 
            case 123: 
            case 124: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOutputIconsTasks";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createOutputIconsForSingleDensityTasks";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createXmlDrawableResourcesTasks";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAdaptiveIconXml";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewImagesTasks";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "generatePreviewImage";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "generateFullBleedPreviewImage";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "generateLegacyImage";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getRectangleInsideScale";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "scaledImage";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "scaledPreviewImage";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "generateViewportPreviewImage";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "cropImageToViewport";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "cropImage";
                break;
            }
            case 56: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "mergeLayers";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "generateIconLayers";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "generateMaskLayer";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getFullBleedRectangle";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getViewportRectangle";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyRectangle";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "generateIconBackgroundLayer";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "generateIconForegroundLayer";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "generateFlatColorRectangle";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "applyMask";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "generateIconLayer";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "drawGrid";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "drawAdaptiveIconGrid";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "drawFullBleedIconGrid";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "drawLegacyIconGrid";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "includeDensity";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getIconPath";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateIconLayer$17";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$16";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPreviewImagesTasks$10";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createXmlDrawableResourcesTasks$9";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createXmlDrawableResourcesTasks$8";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createXmlDrawableResourcesTasks$7";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createXmlDrawableResourcesTasks$6";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createXmlDrawableResourcesTasks$5";
                break;
            }
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createOutputIconsForSingleDensityTasks$4";
                break;
            }
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createOutputIconsForSingleDensityTasks$3";
                break;
            }
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createOutputIconsForSingleDensityTasks$2";
                break;
            }
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createOutputIconsForSingleDensityTasks$1";
                break;
            }
            case 152: 
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createOutputIconsTasks$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 17: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 51: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 89: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 100: 
            case 101: 
            case 105: 
            case 109: 
            case 123: 
            case 124: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ImageAssetSnapshot {
        @Nullable
        private final ListenableFuture<BufferedImage> myImageFuture;
        @Nullable
        private final ListenableFuture<String> myDrawableFuture;
        private final double myScaleFactor;
        private final boolean myIsTrimmed;
        @NotNull
        private final GraphicGeneratorContext myContext;
        @Nullable
        private Rectangle2D myTrimRectangle;
        @GuardedBy(value="myLock")
        @Nullable
        private String myScaledDrawable;
        @GuardedBy(value="myLock")
        @Nullable
        private BufferedImage myTrimmedImage;
        private final Object myLock;

        /*
         * WARNING - void declaration
         */
        public ImageAssetSnapshot(@NotNull BaseAsset asset, double scaleFactor, @NotNull GraphicGeneratorContext graphicGeneratorContext) {
            void context;
            if (asset == null) {
                ImageAssetSnapshot.$$$reportNull$$$0(0);
            }
            if (graphicGeneratorContext == null) {
                ImageAssetSnapshot.$$$reportNull$$$0(1);
            }
            this.myLock = new Object();
            this.myDrawableFuture = asset instanceof ImageAsset ? ((ImageAsset)asset).getXmlDrawable() : null;
            this.myImageFuture = this.myDrawableFuture == null ? asset.toImage() : null;
            this.myIsTrimmed = (Boolean)asset.trimmed().get();
            this.myScaleFactor = scaleFactor;
            this.myContext = context;
        }

        public boolean isDrawable() {
            return this.myDrawableFuture != null;
        }

        public boolean isRasterImage() {
            return this.myImageFuture != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public String getScaledDrawable() {
            if (this.myDrawableFuture == null) {
                return null;
            }
            try {
                Object object = this.myLock;
                synchronized (object) {
                    String xmlDrawable = (String)this.myDrawableFuture.get();
                    if (xmlDrawable == null) {
                        return null;
                    }
                    if (this.myScaledDrawable == null) {
                        Rectangle2D clipRectangle = this.myIsTrimmed ? this.getTrimRectangle(xmlDrawable) : null;
                        this.myScaledDrawable = VectorDrawableTransformer.resizeAndCenter(xmlDrawable, SIZE_FULL_BLEED_DP, this.myScaleFactor, clipRectangle);
                    }
                    return this.myScaledDrawable;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                return null;
            }
        }

        public double getScaleFactor() {
            return this.myScaleFactor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public BufferedImage getTrimmedImage() {
            if (this.myImageFuture == null) {
                return null;
            }
            Object object = this.myLock;
            synchronized (object) {
                if (this.myTrimmedImage == null) {
                    try {
                        BufferedImage image = (BufferedImage)this.myImageFuture.get();
                        this.myTrimmedImage = this.myIsTrimmed ? AssetStudioUtils.trim(image) : image;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        return null;
                    }
                }
                return this.myTrimmedImage;
            }
        }

        @NotNull
        private Rectangle2D getTrimRectangle(@NotNull String xmlDrawable) {
            if (xmlDrawable == null) {
                ImageAssetSnapshot.$$$reportNull$$$0(2);
            }
            if (this.myTrimRectangle == null) {
                this.myTrimRectangle = this.calculateTrimRectangle(xmlDrawable);
            }
            Rectangle2D rectangle2D = this.myTrimRectangle;
            if (rectangle2D == null) {
                ImageAssetSnapshot.$$$reportNull$$$0(3);
            }
            return rectangle2D;
        }

        @NotNull
        private Rectangle2D calculateTrimRectangle(@NotNull String xmlDrawable) {
            Rectangle2D rectangle2D;
            if (xmlDrawable == null) {
                ImageAssetSnapshot.$$$reportNull$$$0(4);
            }
            ListenableFuture<BufferedImage> futureImage = this.myContext.renderDrawable(xmlDrawable, SIZE_FULL_BLEED_DP);
            ListenableFuture rectangleFuture = Futures.transform(futureImage, image -> {
                Rectangle bounds = ImageUtils.getCropBounds((BufferedImage)image, (ImageUtils.CropFilter)ImageUtils.TRANSPARENCY_FILTER, null);
                if (bounds == null) {
                    return IMAGE_SIZE_FULL_BLEED_DP;
                }
                double width = SIZE_FULL_BLEED_DP.getWidth();
                double height = SIZE_FULL_BLEED_DP.getHeight();
                return new Rectangle2D.Double(bounds.getX() / width, bounds.getY() / height, bounds.getWidth() / width, bounds.getHeight() / height);
            });
            try {
                rectangle2D = (Rectangle2D)rectangleFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Rectangle rectangle = IMAGE_SIZE_FULL_BLEED_DP;
                if (rectangle == null) {
                    ImageAssetSnapshot.$$$reportNull$$$0(6);
                }
                return rectangle;
            }
            if (rectangle2D == null) {
                ImageAssetSnapshot.$$$reportNull$$$0(5);
            }
            return rectangle2D;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "asset";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlDrawable";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator$ImageAssetSnapshot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator$ImageAssetSnapshot";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTrimRectangle";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculateTrimRectangle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getTrimRectangle";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calculateTrimRectangle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum PreviewShape {
        NONE("none", "none"),
        CIRCLE("circle", "Circle"),
        SQUIRCLE("squircle", "Squircle"),
        ROUNDED_SQUARE("rounded-square", "Rounded Square"),
        SQUARE("square", "Square"),
        FULL_BLEED("full-bleed-layers", "Full Bleed Layers"),
        LEGACY("legacy", "Legacy Icon"),
        LEGACY_ROUND("legacy-round", "Round Icon"),
        WEB("web", "Google Play Store");

        public final String id;
        public final String displayName;

        private PreviewShape(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }
    }

    public static class AdaptiveIconOptions
    extends GraphicGenerator.Options
    implements Cloneable {
        public String foregroundLayerName;
        public String backgroundLayerName;
        public boolean useForegroundColor = true;
        public int foregroundColor = 0;
        @Nullable
        public ImageAssetSnapshot foregroundImage;
        public int backgroundColor = 0;
        @Nullable
        public ImageAssetSnapshot backgroundImage;
        public boolean generateOutputIcons = true;
        public boolean generatePreviewIcons = true;
        public boolean generateLegacyIcon = true;
        public boolean generateRoundIcon = true;
        public boolean generateWebIcon;
        public PreviewShape previewShape = PreviewShape.NONE;
        public Density previewDensity;
        public GraphicGenerator.Shape legacyIconShape = GraphicGenerator.Shape.SQUARE;
        public GraphicGenerator.Shape webIconShape = GraphicGenerator.Shape.SQUARE;
        public boolean showGrid;
        public boolean showSafeZone;

        public AdaptiveIconOptions() {
            this.iconFolderKind = GraphicGenerator.IconFolderKind.MIPMAP;
        }

        public AdaptiveIconOptions clone() {
            try {
                return (AdaptiveIconOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }
    }

    private static class Layers {
        @NotNull
        public BufferedImage background;
        @NotNull
        public BufferedImage foreground;

        public Layers(@NotNull BufferedImage background, @NotNull BufferedImage foreground) {
            if (background == null) {
                Layers.$$$reportNull$$$0(0);
            }
            if (foreground == null) {
                Layers.$$$reportNull$$$0(1);
            }
            this.background = background;
            this.foreground = foreground;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "background";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "foreground";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator$Layers";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

